/* @(#)serial.c	2.1
 *****************************************************************
 *                                                               *
 *       All rights reserved:    VENTURCOM INC.  1984, 1985	 *
 *                                                               *
 *       This source listing is supplied in accordance with      *
 *       the Software Agreement you have with VenturCom.	 *
 *                                                               *
 *****************************************************************
 *
 *	Program to write serial numbers etc. on XFER disks
 *
 * Flags:
 *	-s num	write serial number num
 *	-d dist	write distributor string dist (maximum 2 characters)
 *	-u num	write num into the number of users allowed field
 *	-f dev	read/write on device dev
 *	-q	quiet; don't print values
 *
 *	prints current values if no flags except -f; retains current values
 *	for flags not specified; uses device /dev/f0 if no device
 *	specified.
 */

#include <stdio.h>
#include <fcntl.h>
#include "sn.h"

char	optstring[] = "s:d:u:f:q";
char	device[50] = "/dev/f0";

extern	char *optarg;

struct	snum snbuf;

main(argc, argv)
int	argc;
char	**argv;

{	char	sflg, dflg, uflg, qflg;
	unsigned int sn, users;
	char	dist[2];
	int	opt, size, fd;

	size = sizeof(struct snum);
	qflg = sflg = dflg = uflg = 0;
	while ((opt = getopt(argc, argv, optstring)) != EOF) {
		switch (opt) {
			case 's':
				sn = atoi(optarg);
				sflg++;
				break;
			case 'd':
				strncpy(dist, optarg, 2);
				dflg++;
				break;
			case 'u':
				uflg++;
				users = atoi(optarg);
				break;
			case 'f':
				strcpy(device, optarg);
				break;
			case 'q':
				qflg++;
				break;
			default:
				goto usage;
		}
	}

	if ((fd = open(device, O_RDWR)) < 0) {
		quit("Error opening %s", device);
	}
	if (lseek(fd, SN_OFF, 0) < 0L) {
		quit("Error seeking to serial number structure.");
	}
	if (read(fd, &snbuf, size) != size) {
		quit("Error reading serial number structure.");
	}
	if (sflg) {
		snbuf.s_snlow = sn & 0xff;
		snbuf.s_snhigh = (sn >> 8) & 0xff;
	}
	if (dflg) {
		strncpy(snbuf.s_dist, dist, 2);
	}
	if (uflg) {
		snbuf.s_nusers = users;
	}
	if (sflg || dflg || uflg) {
		lseek(fd, SN_OFF, 0);
		if (write(fd, &snbuf, size) != size) {
			quit("Error writing serial number structure.");
		}
	}
	if (!qflg) {
		sn = (snbuf.s_snhigh << 8) | (snbuf.s_snlow & 0xff);
		printf("serial number = %d\nnumber of users = %d\n\
distributor abreviation = %.2s\n", sn, snbuf.s_nusers, snbuf.s_dist);
	}
	exit(0);

usage:	quit("Usage: serial [-s serial] [-u users] [-d distributor] [-q] \
[-f device]\n");
}

quit(s, a1)
char	*s, *a1;
{
	printf(s, a1);
	exit(-1);
}
