/* tape: scsi tape driver */

#include <sys/param.h>
#include <sys/inode.h>
#include <sys/types.h>
#include "saio.h"
#include "scsi.h"

#define	setbn(cmd, bn)	{cmd[1] = (bn >> 16) & 0x1f;\
			 cmd[2] = (bn >> 8) & 0xff; \
			 cmd[3] = bn & 0xff;}


tapeopen(io)			/* do a unit ready command to clear the tape */
	register struct iob *io;
{
	struct scsi_wh wh;
	struct scsi_rh rh;

	memset((char *)&wh, 0, sizeof wh);
	memset((char *)&rh, 0, sizeof rh);
	wh.cmd[0] = 3;
	wh.cmd[4] = 4;
	wh.target = io->i_unit;
	wh.flags = SCSI_RD;
	scsi(&wh, &rh, rh.sense, 4, NULL);
}

tapestrategy(io, func)
register struct iob *io;
{
	register u_char *f, *t;
	register int i;
	struct scsi_wh wh;
	struct scsi_rh rh;

	memset((char *)&rh, 0, sizeof rh);
	memset((char *)&wh, 0, sizeof wh);
	if (func == READ) {
		wh.cmd[0] = 8;	/* read */
		wh.flags = SCSI_RD;
	} else {
		wh.cmd[0] = 10;	/* write */
		wh.flags = SCSI_WR;
	}
	wh.cmd[1] = 1;		/* fixed block */
	wh.cmd[4] = (io->i_cc + 511) >> 9;
	wh.target = io->i_unit;
	scsi(&wh, &rh, (char *)io->i_ma, io->i_cc, NULL);
	return io->i_cc;
}

tapeclose(io)
	register struct iob *io;
{
	struct scsi_wh wh;
	struct scsi_rh rh;


	memset((char *)&wh, 0, sizeof wh);
	memset((char *)&rh, 0, sizeof rh);
	wh.cmd[0] = 1;
	wh.target = io->i_unit;
	scsi(&wh, &rh, NULL, 0, NULL);
}
