# include <stdio.h>
# define PAGESIZE 22
char *progname;
char	kludge[BUFSIZ];

main(argc, argv)
	int argc;
	char *argv[];
{
	FILE *fp, *efopen();
	int i, pagesize = PAGESIZE;
	char *p, *getenv(), buf[BUFSIZ];

	setbuf(stdout, kludge);
	progname = argv[0];
	if((p=getenv("PAGESIZE")) != NULL)
		pagesize = atoi(p);
	if(argc > 1 && argv[1][0] == '-') {
		pagesize = atoi(&argv[1][1]);
		argc--;
		argv++;
	}
	if(argc == 1)
		print(stdin, pagesize);
	else
		for(i = 1; i < argc; i++) 
			switch(spname(argv[i], buf)) {
			case -1:	/* no match possible */
				fp = efopen(argv[i], "r");
				break;
			case 1:
				fprintf(stderr, "\"%s\"? ", buf);
				if(ttyin() == 'n')
					break;
				argv[i] = buf;
				/* fall through ... */
			case 0: /* exact match */
				fp = efopen(argv[i], "r");
				print(fp, pagesize);
				fclose(fp);
			}
	exit(0);
}

print( fp, pagesize) /* print fp in pagesize chuncks */
	FILE *fp;
	int pagesize;
{
	static int lines = 0;		/* number of lines so far */
	char buf[BUFSIZ], *addr, *sttyin();

	for (;;) {
		if (!dqline(buf)) {
			if (fgets(buf, sizeof buf, fp) == NULL)
				return;
			qline(buf);
		}
		if (++lines < pagesize)
			fputs(buf, stdout);
		else {
			buf[strlen(buf)-1] = '\0';
			fputs(buf, stdout);
			fflush(stdout);
			addr = sttyin();
			if (*addr == '-')
				bkline(countem(addr) * pagesize);
			lines = 0;
		}
	}
}

countem(s)		/* count the number of '-' in string */
	char *s;
{
	int n = 0;

	while (*s++ == '-')
		n++;
	return n;
}

db(fmt, a, b, c, d, e)
	char *fmt;
{
	fprintf(stderr, "DB ");
	fprintf(stderr, fmt, a, b, c, d, e);
	fprintf(stderr, "\n");
}
