/*
 * adb - string table version; common definitions
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/dir.h>
#include <sys/signal.h>
#include <sys/seg.h>
#include <sys/user.h>
#include <sys/reg.h>

#include <ctype.h>
#include <a.out.h>

#include "mac.h"
#include "mode.h"
#include "head.h"

/* access modes */
#define RD	0
#define WT	1

#define NSP	0
#define	ISP	1
#define	DSP	2
#define STAR	4
#define STARCOM 0200

/*
 * Symbol types, used internally in calls to findsym routine.
 * On the VAX this all degenerates since I & D symbols are indistinct.
 * Basically we get NSYM==0 for `=' command, ISYM==DSYM otherwise.
 */
#define NSYM	0
#define DSYM	1		/* Data space symbol */
#define ISYM	DSYM		/* Instruction space symbol == DSYM on VAX */

#define BKPTSET	1
#define BKPTEXEC 2

#define BPT	0x4E410000	/* bpt instruction */
#define	SETTRC	0
#define	RDUSER	2
#define	RIUSER	1
#define	WDUSER	5
#define WIUSER	4
#define	RUREGS	3
#define	WUREGS	6
#define	CONTIN	7
#define	EXIT	8
#define SINGLE	9

#define KSP	0


#define PSL	PS
#define TXT_BASE 0x20
#define MAXOFF	255
#define MAXPOS	80
#define MAXLIN	128
#define EOF	0
#define EOR	'\n'
#define SPC	' '
#define TB	'\t'
#define QUOTE	0200
#define STRIP	0177
#define LOBYTE	0377
#define EVEN	-2

/* long to ints and back (puns) */
union {
	INT	I[2];
	L_INT	L;
} itolws;

#define leng(a)		itol(0,a)
#define shorten(a)	((short)(a))
#ifndef vax
#define itol(a,b)	(itolws.I[0]=(a), itolws.I[1]=(b), itolws.L)
#else
#define itol(a,b)	(itolws.I[0]=(b), itolws.I[1]=(a), itolws.L)
#endif

/* result type declarations */
L_INT		inkdot();
POS		get();
POS		chkget();
STRING		exform();
L_INT		round();
BKPTR		scanbkpt();
VOID		fault();

int	kernel;
int	kcore;
int	slr;

# define MINPCVAL 0x44

#define NUM_FPS  	8	/* number of floating point registers  */
#define FP_SIZE		12	/* size of floating point reg. in bytes */
#define NUM_FP_STAT	3	/* number of floating point status regs.*/
#define STAT_SIZE	4	/* size of fp status regs. in bytes */
#define NUM_FP_BYTES	((NUM_FPS * FP_SIZE) + (NUM_FP_STAT * STAT_SIZE))

typedef	int u_int;

#define	DBNAME	"adb\n"
#define	MAXFILE	0x7fffffff
#define	PAGSIZ	NBPC
#define	KERNOFF	0
#define	UPAGES	USIZE
#define	INSTACK(x)	1
#define INKERNEL(x)	0
#define	KVTOPH(x)	(x)
