/* sh.local.h 4.1 10/9/80 */

/*
 * This file defines certain local parameters
 * A symbol should be defined in Makefile for local conditional
 * compilation, e.g. IIASA or ERNIE, to be tested here and elsewhere.
 */

/*
 * Fundamental definitions which may vary from system to system.
 *
 *	BUFSIZ		The i/o buffering size; also limits word size
 *	SHELLPATH	Where the shell will live; initalizes $shell
 *	MAILINTVL	How often to mailcheck; more often is more expensive
 *	HZ		Cycle of ac power
 *	OTHERSH		Shell for scripts which don't start with #
 */

#define	BUFSIZ	512		/* default buffer size */
#define HZ	60		/* for division into seconds */
#define	SHELLPATH	"/bin/csh"
#define	OTHERSH		"/bin/sh"
#define FORKSLEEP	10	/* delay loop on non-interactive fork failure */
#define	MAILINTVL	600	/* 10 minutes */

/*
 * NCARGS and NOFILE are from <sys/param.h> which we choose not
 * to wholly include
 */
/* #define	NCARGS	10240		/* Max. chars in an argument list */

/*
 * The shell moves std in/out/diag and the old std input away from units
 * 0, 1, and 2 so that it is easy to set up these standards for invoked
 * commands.  If possible they should go into descriptors closed by exec.
 */
#define	NOFILE	20		/* Max number of open files */
#define	FSHTTY	15		/* /dev/tty when manip pgrps */
#define	FSHIN	16		/* Preferred desc for shell input */
#define	FSHOUT	17		/* ... shell output */
#define	FSHDIAG	18		/* ... shell diagnostics */
#define	FOLDSTD	19		/* ... old std input */

#define	V7

#ifdef IIASA
#undef	HZ
#define	HZ	60
#undef	OTHERSH
#endif

#ifdef VMUNIX
#include <pagsiz.h>
#undef BUFSIZ
#define	BUFSIZ	BSIZE
#endif

/* DTS HACKS */
#define TIOCGETD	99
#define TIOCSETD	99
#define TIOCGPGRP	99
#define TIOCSPGRP	99

#define SIGTSTP		SIGKILL
#define SIGTTIN		SIGKILL
#define SIGTTOU		SIGKILL
#define SIGCHLD		SIGKILL
#define SIGCONT		SIGKILL

#define NTTYDISC	2
#define OTTYDISC	0


/*
 * Limits for u.u_limit[i], per process, inherited.
 */
#define	LIM_NORAISE	0	/* if <> 0, can't raise limits */
#define	LIM_CPU		1	/* max secs cpu time */
#define	LIM_FSIZE	2	/* max size of file created */
#define	LIM_DATA	3	/* max growth of data space */
#define	LIM_STACK	4	/* max growth of stack */
#define	LIM_CORE	5	/* max size of ``core'' file */
#define	LIM_MAXRSS	6	/* max desired data+stack core usage */

#define	NLIMITS		6

#define	INFINITY	0x7fffffff
