#
/*
 * getty -- adapt to terminal speed on dialup, and call login
 */
/* This version contains stream etld stuff */

#include <sys/types.h>
#include <sys/filio.h>
#include <sys/ttyio.h>
#include <sys/utsname.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/enio.h>
#include <sys/ethernet.h>
#include <sys/et.h>
#define ERASE	'#'
#define KILL	'@'
#define	ANYP	0		/* bwc junk */

struct sgttyb tmode;
struct tchars tchars = { '\177', '\034', '\021', '\023', '\004', '\377' };

struct	tab {
	char	tname;		/* this table name */
	char	nname;		/* successor table name */
	int	iflags;		/* initial flags */
	int	fflags;		/* final flags */
	int	ispeed;		/* input speed */
	int	ospeed;		/* output speed */
	char	*message;	/* login message */
} itab[] = {

/* table '0'-1-2 1200, 2400, 9600 */
	'0', 1,
	ANYP+RAW, ANYP+ECHO+CRMOD,
	B1200, B1200,
	"\n\rlogin: ",

	1, 2,
        ANYP+RAW, ANYP+ECHO+CRMOD,
	B9600, B9600,
	"\n\rlogin: ",

	2, '0',
        ANYP+RAW, ANYP+ECHO+CRMOD,
	B2400, B2400,
	"\n\rlogin: ",

/* table '-' -- Console TTY 110 */
	'-', '-',
	ANYP+RAW+NL1+CR1, ANYP+ECHO+CRMOD+XTABS+LCASE+CR1+TANDEM,
	B110, B110,
	"\n\rlogin: ",

/* table '1' -- 150 */
	'1', '1',
	ANYP+RAW+NL1+CR1, EVENP+ECHO+FF1+CR2+TAB1+NL1+TANDEM,
	B150, B150,
	"\n\r\033:\006\006\017login: ",

/* table '2' -- 9600 */
	'2', '2',
	ANYP+RAW+NL1+CR1, ECHO+CRMOD,
	B9600, B9600,
	"\n\rlogin: ",

/* table '3'-'5' -- 1200,300 */
	'3', '5',
	ANYP+RAW+NL1+CR1, ANYP+XTABS+ECHO+CRMOD+FF1+TANDEM,
	B1200, B1200,
	"\n\r\033;login: ",

/* table '5'-'3' -- 300,1200 */
	'5', '3',
	ANYP+RAW+NL1+CR1, ANYP+ECHO+CR1+TANDEM,
	B300, B300,
	"\n\r\033;\007login: ",

/* table '4' -- Console Decwriter */
	'4', '4',
	ANYP+RAW, ANYP+ECHO+CRMOD+XTABS+TANDEM,
	B300, B300,
	"\n\rlogin: ",

/* table 'i' -- Interdata Console */
	'i', 'i',
	RAW+CRMOD, CRMOD+ECHO+LCASE+TANDEM,
	0, 0,
	"\n\rlogin: ",

/* table 'l' -- LSI Chess Terminal */
	'l', 'l',
	ANYP+RAW/*+HUPCL*/, ANYP+ECHO/*+HUPCL*/,
	B300, B300,
	"*",
/* table '6' -- 2400 11/23 line */
	'6', '6',
	ANYP+RAW+NL1+CR1, ANYP+ECHO+TANDEM,
	B2400, B2400,
	"\n\rlogin: ",

/* table '7' - 19.2 */
	'7', '7',
	ANYP+RAW+NL1+CR1, ANYP+XTABS+ECHO+CRMOD+FF1+TANDEM,
	EXTA, EXTA,
	"\n\rlogin: ",
/* table '8' - 4800 */
	'8', '8',
	ANYP+RAW+NL1+CR1, ANYP+XTABS+ECHO+CRMOD+FF1+TANDEM,
	B4800, B4800,
	"\n\rlogin: ",
/* table 'e' -- Ethernet */
	'e', 'e',
	RAW, ECHO+CRMOD,
	B0, B0,
	"\n\rEnet login: ",
/* table '9' - 1200, 2400, 9600 */
};

#define	NITAB	sizeof itab/sizeof itab[0]
#define	EOT	04		/* EOT char */

char	name[16];
int	crmod;
int	upper;
int	lower;

char partab[] = {
	0001,0201,0201,0001,0201,0001,0001,0201,
	0202,0004,0003,0205,0005,0206,0201,0001,
	0201,0001,0001,0201,0001,0201,0201,0001,
	0001,0201,0201,0001,0201,0001,0001,0201,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0000,0200,0200,0000,0200,0000,0000,0201
};

main(argc, argv)
char **argv;
{
	register struct tab *tabp;
	int tname;
	struct utsname uts;

	if (uname(&uts) == -1) 
		strcpy(uts.nodename, "unknown");
	tname = '0';
	if (argc > 1)
		tname = argv[1][0];
	switch (tname) {

	case '3':		/* adapt to connect speed (212) */
		ioctl(0, TIOCGETP, &tmode);
		if (tmode.sg_ispeed==B300)
			tname = '0';
		else
			tname = '3';
		break;
	}
	for (;;) {
		for(tabp = itab; tabp < &itab[NITAB]; tabp++)
			if(tabp->tname == tname)
				break;
		if(tabp >= &itab[NITAB])
			tabp = itab;
		if (tname == 'e')
			enet_setup();
		tmode.sg_flags = tabp->iflags;
		tmode.sg_ispeed = tabp->ispeed;
		tmode.sg_ospeed = tabp->ospeed;
		ioctl(0, TIOCSETP, &tmode);
		ioctl(0, TIOCSETC, &tchars);
		puts("\r\n");
		puts(uts.nodename);
		puts(" login: ");
		if(getname()) {
			tmode.sg_erase = ERASE;
			tmode.sg_kill = KILL;
			tmode.sg_flags = tabp->fflags;
			if(crmod)
				tmode.sg_flags |= CRMOD;
			if(upper)
				tmode.sg_flags |= LCASE;
			if(lower)
				tmode.sg_flags &= ~LCASE;
			stty(0, &tmode);
			putchr('\n');
			execl("/bin/login", "login", name, 0);
			exit(1);
		}
		tname = tabp->nname;
	}
}

getname()
{
	register char *np;
	register c;
	char cs;

	crmod = 0;
	upper = 0;
	lower = 0;
	np = name;
	for (;;) {
		if (read(0, &cs, 1) <= 0)
			exit(0);
		if ((c = cs&0177) == 0)
			return(0);
		if (c==EOT)
			exit(1);
		if (c=='\r' || c=='\n' || np >= &name[16])
			break;
		putchr(cs);
		if (c>='a' && c <='z')
			lower++;
		else if (c>='A' && c<='Z') {
			upper++;
			c += 'a'-'A';
		} else if (c==ERASE) {
			if (np > name)
				np--;
			continue;
		} else if (c==KILL) {
			putchr('\r');
			putchr('\n');
			np = name;
			continue;
		} else if(c == ' ')
			c = '_';
		*np++ = c;
	}
	*np = 0;
	if (c == '\r')
		crmod++;
	return(1);
}

puts(as)
char *as;
{
	register char *s;

	s = as;
	while (*s)
		putchr(*s++);
}

putchr(cc)
{
	char c;
	c = cc;
/*	c |= partab[c&0177] & 0200;*/
	write(1, &c, 1);
}


/* 
 * stuff to setup an enet tty connection.
 */


/* Caution: test code with hardcoded values */

enet_setup()
{
	struct stat s;
	struct ether e;
	int fd;
	extern int tty_ld, et_ld;
	char buf[512];

	bzero((char *)&e, sizeof e);
	fstat(0, &s);
	e.type = minor(s.st_rdev) | 0x5000;
	eioctl(0, ENIOTYPE, &e.type);
	if ((fd = open("/etc/enet_tty", 0)) == -1)
		strcpy(buf, "080020073938");
	else {
		read(fd, buf, sizeof buf);
		close(fd);
	}
	buf[12] = '\0';
	seteaddr((char *)e.dhost, buf);
	eioctl(0, FIOPUSHLD, &et_ld);
	eioctl(0, ETSET, &e);
	eioctl(0, FIOPUSHLD, &tty_ld);
	eioctl(0, TIOCSPGRP, NULL);
}
	
seteaddr(p1, s)		/* a version of jcm's routine */
	char *p1;
	char *s;
{
	register n = 6;
	register i;

	while (n--) {
		*p1 = 0;
		for (i = 0; i < 2; i++) {
			*p1 <<= 4;
			if (*s == '\0')
				return;
			if (*s >= '0' && *s <= '9')
				*p1 |= *s++ - '0';
			else if (*s >= 'A' && *s <= 'F')
				*p1 |= *s++ - 'A' + 10;
			else if (*s >= 'a' && *s <= 'f')
				*p1 |= *s++ - 'a' + 10;
			else
				s++;		/*skip it */
		}
		p1++;
	}
}

eioctl(fd, cmd, addr)
	char *addr;	/* void * */
{
	register rv;

	if ((rv = ioctl(fd, cmd, addr)) == -1)
		abort();
	return rv;
}
