/* tcpstat.c: print tcp's tcb structure */
#include <stdio.h>
#include <sys/types.h>
#include <nlist.h>
#include <sys/inet/in.h>
#include <sys/inet/tcp.h>

char	*fcore	= "/dev/kmem";
char	*fnlist	= "/unix";
int	fc;

struct	nlist setup[] = {
#define	STCB	0
	{ "_tcb"},
	0
};

int	allflag;
int	nflag;

main(argc, argv)
char **argv;
{

	while (--argc && **++argv == '-') {
		while (*++*argv)
		switch (**argv) {
		case 'a':
			allflag++;
			break;
		case 'n':
			nflag++;
			break;
		}
	}
	if (argc>0)
		fcore = argv[0];
	if ((fc = open(fcore, 0)) < 0) {
		printf("Can't find %s\n", fcore);
		exit(1);
	}
	if (argc>1)
		fnlist = argv[1];
	nlist(fnlist, setup);
	if (setup[0].n_type == -1) {
		printf("no namelist\n");
		exit(1);
	}
	tcpstate();
}

tcpstate()
{
	register struct tcb *tp;
	struct tcb xtcb[NTCB];
	register int nin, loc;

	nin = 0;
	kseek(fc, (long)setup[STCB].n_value, 0);
	read(fc, (char *)xtcb, sizeof(xtcb));
	for (tp = xtcb; tp < &xtcb[NTCB]; tp++)
		if (tp->flags)
			nin++;
	printf("%d active tcbs\n", nin);
	loc = setup[STCB].n_value;
	for (tp = xtcb; tp < &xtcb[NTCB]; tp++, loc += sizeof(xtcb[0])) {
		if (tp->flags == 0 && ! allflag)
			continue;
		printf("tcp%02d: ", tp - xtcb);
		printf("#%08x ", loc);
		putstate(tp->state);
		printf(" ");
		putqstate(tp->qstate);
		printf("; flags ");
		putf(tp->flags & TCP_ISOPEN, 'O');
		putf(tp->flags & TCP_CLOSING, 'C');
		putf(tp->flags & TCP_CLEXPIRED, 'E');
		printf("\n\t");
		pr_addr(tp->laddr);
		pr_port(tp->lport, "tcp");
		printf(" ");
		pr_addr(tp->faddr);
		pr_port(tp->fport, "tcp");
		printf("\n");
		printf("\t");
		printf("rtt %d, srtt %d, tries %d,\n", tp->rtt, tp->srtt, tp->tries);
		printf("\tsnd(%u, %u, %u),\n", tp->snd_una, tp->snd_nxt, tp->snd_wnd);
		printf("\trcv(%u, %d),\n", tp->rcv_nxt, tp->rcv_wnd);
		printf("\t");
		printf("snd_wl1 %u, snd_wl2 %u, ", tp->snd_wl1, tp->snd_wl2);
		printf("\n\t");
		printf("iss %u, irs %u, ", tp->iss, tp->irs);
		printf("\n");
		printf("\t");
		printf("rt_timer %d, tw_timer %d, cl_timer %d, per_timer %d, ", 
			tp->rt_timer, tp->tw_timer, tp->cl_timer, tp->per_timer);
		printf("\n");
		printf("\t");
		printf("upq #%08x, dnq #%08x\n", tp->upq, tp->dnq);
		printf("\n");
	}
}

putstate(state)
{
	static char *states[] = {
		"closed", "listen", "syn_sent", "syn_received", "established",
		"fin_wait_1", "fin_wait_2", "close_wait", "closing", "last_ack",
		"time_wait" 
	};

	if (state < 0 || state > TIME_WAIT)
		printf("#%x ", state);
	printf("%s  ", states[state]);
}

putf(v, n)
{
	printf("%c", v ? n : ' ');
}

kseek(fd, offset, how)
{
	return lseek(fd, offset & ~0xC0000000, how);
}
pr_addr(a)		/* catenate ascii for address */
	in_addr a;
{
	if (nflag) {
		printf("%s:", in_ntoa(a));
		return;
	}
	printf("%s:", in_host(a));
}

pr_port(p, proto)		/* catenate ascii for port */
	char *proto;
	unsigned long p;
{
	register struct in_service *ip;

	if ((ip = in_service((char *)0, proto, p)) == NULL || nflag)
		printf("%d", p);
	else
		printf("%s", ip->name);
}

putqstate(s)
{
	static char *qstates[] = {
		"idle", "wopen", "started", "broken"
	};

	if (s < 0 || s > TCP_BROKEN)
		printf("UNKNOWN");
	printf("%s", qstates[s]);
}
