/******************************BEGIN*****************************************
 *                         ADAPTIVE CONFIDENTIAL
 *
 * This listing of source code is proprietary and confidential to Adaptive
 * Corporation. It may not be copied or made available in any form (electronic
 * or hard copy) to any person not authorized by Adaptive Corporation. 
 * Unpublished--Rights reserved under all copyright laws. 
 *
 *                          Copyright (C) 1991
 *               Adaptive Corporation, Redwood City, CA 94063
 *                          All Rights Reserved
 *****************************************************************************
 * Name:         fnd
 * Type:         c source
 * Originator:   Grant Haidinyak
 * File:         %M%
 * Version:      %I% (from %P%)
 * Date:         %G% %U%
 * Description:
 *               <Description of the general category of file contents>
 *******************************END******************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <sys/inet/in.h>
#include <sys/inet/udp_user.h>
#include <sys/utsname.h>

#define FALSE (0)
#define TRUE (!FALSE)

struct fnd_pkt_s {
	struct udpaddr 	from_addr;
	char      	data[256];
};
typedef struct fnd_pkt_s fnd_pkt_t;
#define SIZE_FND_PKT	 (sizeof(fnd_pkt_t))

int  		 fnd_sock;
char 		*fnd_name;
fnd_pkt_t	 fnd_response;
char		 rsp_string[256];
char		*pim_name = "/dev/pim.cs";

struct utsname 	 my_name;

extern char	*nc_status();
extern char	*sys_errlist[];
extern int	 errno;

main(argc, argv)
int   argc;
char *argv[];
{
	init(argc, argv);
	doit(argc, argv);
	cleanup(argc, argv);
}

init(argc, argv)
int   argc;
char *argv[];
{
	struct in_service	 *fnd_srvc;
	in_addr   	    	  my_addr;
	
	fnd_name  = argv[0];
	fnd_srvc  = in_service("fnd", "udp", 0);
	if (fnd_srvc == NULL) {
		fprintf(stderr, "%s: couldn't find \"fnd\" in services file\n",
			fnd_name);
		exit(-1);
	}
	
	fnd_sock = udp_datagram(fnd_srvc->port);
	if (fnd_sock < 0) {
		fprintf(stderr, "%s: upd_datagram - %s\n", fnd_name,
			sys_errlist[errno]);
		exit(-1);
	}

	uname(&my_name);
	my_addr = in_address(my_name.nodename);
	sprintf(rsp_string, "%s %s %d", my_name.nodename,
		in_ntoa(my_addr), getnode());
}

doit(argc, argv)
int   argc;
char *argv[];
{
	fd_set    fds;
	int       nfds;
	
	while (TRUE) {
		FD_ZERO(fds);
		FD_SET(fnd_sock, fds);
		if (select(fnd_sock + 1, &fds, NULL, 0xefffffff) < 0) {
			if (errno != EINTR) {
				perror(fnd_name);
			}
			continue;
		}
		if (FD_ISSET(fnd_sock, fds)) {
			do_fnd_req(fnd_sock);
		}
	}
}

do_fnd_req(s)
int  s;
{
	fnd_pkt_t	pkt;
	int		 i;
	int		*p;
	
	read(s, &pkt, SIZE_FND_PKT);
	fnd_response.from_addr = pkt.from_addr;
	sprintf(fnd_response.data, "%s %s", rsp_string, nc_status());
	write(s, &fnd_response, SIZE_FND_PKT);
}

cleanup(argc, argv)
int   argc;
char *argv[];
{
	close(fnd_sock);
}

print_fnd_pkt(pkt)
fnd_pkt_t *pkt;
{
	printf("%x - addr = %s:%d\n\t%s\n", pkt, in_host(pkt->from_addr.host),
	       pkt->from_addr.port, pkt->data);
}

char *nc_status()
{
	char	 	 status[18];
	char		 side;
	char		*ret;
	char		*stat;
	int		 num_read;
	int		 pim_fd;
	static char	 buff[16];

	ret = buff;
	strcpy(ret, "error ?");
	
	pim_fd = open(pim_name, O_RDONLY);
	if (pim_fd < 0) {
		fprintf(stderr, "%s: open %s failed - %s\n", fnd_name,
			pim_name, sys_errlist[errno]);
		return(ret);
	}

	bzero(status, 18);
	num_read = read(pim_fd, status, 17);
	if (num_read < 0) {
		fprintf(stderr, "%s: can't read from %s - %s\n", fnd_name,
			pim_name, sys_errlist[errno]);
		close(pim_fd);
		return(ret);
	}
	
	status[num_read] = 0;
	side = (status[6] == '0') ? 'a' : 'b';
	
	switch (status[0]) {
	case 'a':
		stat = (side == 'a') ? "active" : "standby";
		break;

	case 'b':
		stat = (side == 'b') ? "active" : "standby";
		break;

	case '-':
		stat = "unknown";
		break;

	default:
		stat = "'error";
		break;
	}
	close(pim_fd);

	sprintf(ret, "%s %c", stat, side);
	return(ret);
}
