#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/inet/in.h>
#include <sys/inet/udp_user.h>

main(argc, argv)
	int argc;
	char *argv[];
{
	struct udpaddr ua;
	struct in_service *sp;
	char buf[128];
	static char mesg[] = "pling!";
	int fd, n, tries;
	int tictok();
	extern int errno;

	argc--;
	argv++;
	if ((sp = in_service("echo", "udp", 0)) == NULL) {
		fprintf(stderr, "I don't know about echo service\n");
		exit(1);
	}
	ua.port = sp->port;
	signal(SIGALRM, tictok);
	while (argc--) {
		tries = 0;
		if ((ua.host = in_address(*argv)) == 0) {
			fprintf(stderr, "Don't know about %s\n", *argv);
			continue;
		}
		if ((fd = udp_connect(0, ua.host, ua.port)) == -1) {
			perror("udp_connec");
			continue;
		}
		memcpy(buf, (char *)&ua, sizeof ua);
		memcpy(buf+sizeof ua, mesg, sizeof mesg);
		do {
			write(1, ".", 1);
			write(fd, buf, sizeof ua + sizeof mesg);
			alarm(1);
			if ((n = read(fd, buf, sizeof buf)) == -1)
				if (errno == EINTR)
					tries++;
				else
					perror("read");
			alarm(0);
		} while (tries < 10 && n == -1);
		if (n == -1)
			printf("%s is down\n", *argv);
		else
			printf("%s is up\n", in_host(((struct udpaddr *)buf)->host));
		close(fd);
		argv++;
	}
}

tictok()
{
	signal(SIGALRM, tictok);
}
