#include <stdio.h>
#include <signal.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/filio.h>
#include <sys/ttyio.h>
#include <sys/inet/in.h>
#include <sys/inio.h>
#include <sys/inet/tcp_user.h>
#include <utmp.h>
#include <errno.h>
#include <sys/wait.h>
#include <string.h>

#define	SCPYN(a, b)	strncpy(a, b, sizeof(a))
#define	SCMPN(a, b)	strncmp(a, b, sizeof(a))

char	utmp[] = "/etc/utmp";
char	wtmpf[] = "/usr/adm/wtmp";

#define	NPIDS	100
struct	pid {
	int	pid;
	char	name[8];
} pids[NPIDS];

struct	sgttyb sg = { 9600, 9600, '#', '@', ECHO+CRMOD };


main()			/* listen for rlogin connection requests */
{
	struct in_service *sp;
	char *cp, *ttyname();
	extern tty_ld;
	struct tcpuser tu;
	register fd, nfd;
	char buf[128];
	int i, h, pid;
	register struct pid *p;
	extern int errno;
	int ding();

	signal(SIGALRM, ding);
	setpgrp(getpid(), getpid());
	tu.laddr = INADDR_ANY;
	tu.faddr = INADDR_ANY;
	if (sp = in_service("login", "tcp", 0))
		tu.lport = sp->port;
	else
		tu.lport = 513;
	tu.fport = 0;
	if ((fd = tcp_sock()) == -1)
		quit("can't get a socket");
	if (tcp_listen(fd, &tu) == -1)
		quit("Can't listen on socket");
	for (;;) {
		alarm(2);
		if ((nfd = tcp_accept(fd, &tu)) == -1) {
			if (errno == EINTR) 
				check_kids();
			else
				quit("can't accept");
			continue;
		}
		alarm(0);
		if ((pid = fork()) == 0) {	/* child */
			char *host;
			host = in_host(tu.faddr);
			i = 0;
			do {
				if (read(nfd, buf, 1) < 1)
					exit(0);
				if (buf[0] == '\0')
					i++;
			} while (i < 4);
			write(nfd, "\0", 1);
			close(0); close(1); close(2); close(3);
			dup(nfd), dup(nfd), dup(nfd), dup(nfd);
			for (i = 4; i < NOFILE; i++)
				close(i);
			ioctl(0, TIOCSPGRP, NULL);
			ioctl(0, FIOPUSHLD, &tty_ld);
			ioctl(0, TIOCSETP, &sg);
			execl("/bin/login", "login", "-h", host, (char *)0);
			write(0, "Oops!\n\r", 7);
			exit(0);
		}
		for (p = pids; p <= &pids[NPIDS]; p++)
			if (p->pid == 0) {
				p->pid = pid;
				if (cp = ttyname(nfd))
				if (cp = strrchr(cp, '/'))
					SCPYN(p->name, cp+1);
				break;
			}
		close(nfd);
	}
}

quit(s)
	char *s;
{
	perror(s);
	exit(1);
}

check_kids()	/* collect the bodies */
{
	register struct pid *p;

	for (p = pids; p <= &pids[NPIDS]; p++)
		if (p->pid)
			switch (waitpid(p->pid, (int *)0, WNOHANG)) {
			case -1:
				p->pid = 0;
				break;
			case 0:
				break;
			default:
				p->pid = 0;
				rmut(p->name);
				break;
			}
}

rmut(line)
	char *line;
{
	struct utmp wtmp;
	register f;
	int found = 0;

	f = open(utmp, 2);
	if (f >= 0) {
		while (read(f, (char *)&wtmp, sizeof wtmp) == sizeof wtmp) {
			if (SCMPN(wtmp.ut_line, line) || wtmp.ut_name[0]==0)
				continue;
			lseek(f, -(long)sizeof(wtmp), 1);
			SCPYN(wtmp.ut_name, "");
			time(&wtmp.ut_time);
			write(f, (char *)&wtmp, sizeof wtmp);
			found++;
		}
		close(f);
	}
	if (found) {
		f = open(wtmpf, 1);
		if (f >= 0) {
			SCPYN(wtmp.ut_line, line);
			SCPYN(wtmp.ut_name, "");
			time(&wtmp.ut_time);
			lseek(f, (long)0, 2);
			write(f, (char *)&wtmp, sizeof wtmp);
			close(f);
		}
	}
}

ding()
{
	signal(SIGALRM, ding);
}
