#include <sys/types.h>
#include <sys/inet/in.h>
#include <sys/inet/udp_user.h>
#include <sys/ipm.h>
#include <sys/signal.h>
#include <stdio.h>
#define MAX_MSG 2048


int ufd, mfd;
struct udpaddr uaddr;
main(argc, argv)
int argc;
char *argv[];
{
	udp_port sport;
	int to = 0xefffffff;
	char buf[MAX_MSG];
	struct mesghdr mh;
	char *p, *q;
	fd_set fdv;
	int cc;
	u_short sid;

	setpgrp(getpid(), getpid());
	if (argc != 2) {
		printf("usage: %s port_number\n", argv[0]);
		exit(-1);
	}
	sport = atoi(argv[1]);
	ufd = udp_datagram(sport);
	if (ufd == -1) {
		perror("udp_datagram()");
		exit(-1);
	}
	mfd = msgbind(0);
	if (mfd < 0) {
		perror("smg:msgbind");
		exit(-1);
	}
	sid = fdsid(mfd);
	while (1) {
		FD_ZERO(fdv);
		FD_SET(ufd, fdv);
		FD_SET(mfd, fdv);
		switch(select(mfd+1, &fdv, (fd_set *)0, to)) {
			case 1:
			case 2:
				if(FD_ISSET(ufd, fdv)) {
					cc = read(ufd, buf, MAX_MSG);
					if (cc > 0) {
						bcopy(buf,&uaddr,sizeof uaddr);
						sendmsg(buf, cc, sid);
					} else {
						printf("udp read ret < 0\n");
					}
				}
				if(FD_ISSET(mfd, fdv)) {
					p = msgrecv(mfd, &mh);
					if (p) {
						sendudp(&mh, p);
					} else {
						printf("error in msgrecv\n");
					}
				}
				break;
			case 0:
				printf("smg:select ret 0\n");
				break;

			case -1:
				printf("smg:select ret -1\n");
				break;
		}
	}


}

sendmsg(b, c, mysid)
char *b;
int c;
int mysid;
{
	
	struct udpaddr *udpp;
	struct mesghdr *mhp, mh;
	char *p;

	udpp = (struct udpaddr *)b;
	mhp = (struct mesghdr *)((char *)b + sizeof (struct udpaddr));
	p = msgalloc(mhp->length);
	memcpy(&mh, mhp, sizeof mh);
	memcpy(p,b+sizeof(struct udpaddr)+sizeof(struct mesghdr), mhp->length);
	mh.orig.net = 0;
	mh.orig.node = getnode();
	mh.orig.scope = getscope();
	mh.orig.sid = mysid;

	if (msgsend(&mh, p) < 0) {
		perror("smg:msgsend");
	}
}

sendudp(mhp, p)
struct mesghdr *mhp;
char *p;
{
	char buf[MAX_MSG];
	register char *q;
	int totlen;

	q = buf;
	memcpy (q, &uaddr, sizeof(struct udpaddr));
	q += sizeof(struct udpaddr);
	memcpy(q, mhp, sizeof(struct mesghdr));
	q += sizeof(struct mesghdr);
	memcpy(q, p, mhp->length);
	totlen = q - buf + mhp->length;
	msgfree(p);
	if (write(ufd, buf, totlen) < 0)
		perror("smg:udp write");
}
