/* bcopy(from, to, size) */

_bcopy:	.globl	_bcopy
	movl	sp@(4),a0	/* source */
	movl	sp@(8),a1	/* destination */

	movw	a0,d0		/* check for one addr even & one addr odd */
	movw	a1,d1
	eorw	d1,d0
	andw	#1,d0

	movl	sp@(12),d1	/* count */

	cmpl	a0,a1		/* check for nasty overlap */
	jls	forward		/* no nasty overlap, copy in forward dir */
	addl	d1,a0		/* point a0 just past end of source string */
	cmpl	a0,a1		/* see if strings really overlap */
	jge	1f		/* no */
	addl	d1,a1		/* yes, point a1 just past end of dest string */
	jlt	backward	/* overlapping, must do backwards */

1:				/* no overlap */
	subl	d1,a0		/* point back at beginning of source string */

forward:
	cmpl	#8,d1		/* if less than 8 bytes just copy bytes */
	jlt	4f
	tstw	d0		/* if one addr even & one addr odd copy bytes */
	jne	4f

	movw	a0,d0		/* check for odd addrs */
	lsrw	#1,d0
	jcc	1f
	subql	#1,d1		/* both addrs odd, copy 1 byte */
	movb	a0@+,a1@+	/*  and then both addrs will be even */

1:				/* both addrs even, get ready to copy longs */
	movl	d1,d0		/* save byte count */
	lsrl	#2,d1		/* change to long count (truncated) */
	jra	3f		/* jump into long copy loop */

2:	movl	a0@+,a1@+	/* long copy loop */
3:	dbf	d1,2b		/* entry point of long copy loop */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jgt	2b

	movl	d0,d1		/* restore byte count */
	andl	#3,d1		/* 0-3 bytes left */
	jra	4f		/* jump into byte copy loop */

1:	movb	a0@+,a1@+	/* byte copy loop */
4:	dbf	d1,1b		/* entry point of byte copy loop */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jgt	1b

	movq	#0,d0		/* tidy */
	rts

backward:
	cmpl	#8,d1		/* if less than 8 bytes just copy bytes */
	jlt	4f
	tstw	d0		/* if one addr even & one addr odd copy bytes */
	jne	4f

	movw	a0,d0		/* check for odd addrs */
	lsrw	#1,d0
	jcc	1f
	subql	#1,d1		/* both addrs odd, copy 1 byte */
	movb	a0@-,a1@-	/*  and then both addrs will be even */

1:				/* both addrs even, get ready to copy longs */
	movl	d1,d0		/* save byte count */
	lsrl	#2,d1		/* change to long count (truncated) */
	jra	3f		/* jump into long copy loop */

2:	movl	a0@-,a1@-	/* long copy loop */
3:	dbf	d1,2b		/* entry point of long copy loop */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jgt	2b

	movl	d0,d1		/* restore byte count */
	andl	#3,d1		/* 0-3 bytes left */
	jra	4f		/* jump into byte copy loop */

1:	movb	a0@-,a1@-	/* byte copy loop */
4:	dbf	d1,1b		/* entry point of byte copy loop */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jgt	1b

	movq	#0,d0		/* tidy */
	rts
