/*
 * C library -- _setjmp, _longjmp
 *
 *	_longjmp(a,v)
 * will generate a "return(v)" from
 * the last call to
 *	_setjmp(a)
 * by restoring registers from the stack.
 * The previous signal state is NOT restored.
 *
 * BUG: registers should be restored as stack is unwound,
 *  instead of from jmpbuf.
 */

_setjmp:	.globl	_setjmp
	movl	sp@(4),a0
	movl	a6,a0@			/* save frame pointer of caller */
	movl	sp@+,a1			/* pop return address */
	movl	a1,a0@(4)		/* save pc of caller */
	movml	#0xBCFC,a0@(40)		/* XXX (shouldn't need this) XXX */
	movq	#0,d0 			/* zero return value */
	jmp	a1@

_longjmp:	.globl	_longjmp
	movl	sp@(8),d0		/* return value */
	movl	sp@(4),a0		/* fetch buffer */
	tstl	a0@
	jeq	botch

	movml	a0@(40),#0xBCFC		/* XXX (shouldn't need this) XXX */
	movl	a0@,a6			/* restore frame pointer */
	movl	a0@(4),a1		/* pc */
	jmp	a1@


botch:
	pea	msgend-msg
	pea	msg
	movl	#2,sp@-
	jsr	_write
	stop	#0

	.data
msg:	.ascii	"longjmp botch\n"
msgend:
