#include <sys/types.h>
#include <ipc.h>
#include <sys/filio.h>
#include <sys/utsname.h>
#include <sys/errno.h>
#include <string.h>

#define	close3(a, b, c)		close(a);close(b);close(c);

extern int errno;

ipcopen(name, param)
char *name, *param;
{
	struct passfd pfd;
	int fd, fd1, fd2;
	struct utsname un;
	static char buf[1024];
	char c, ptname[16], svc[256];

	if (*name != '/') {
		strcpy(svc, "/cs/");
		strncat(svc, name, sizeof svc - strlen(svc));
	} else
		strcpy(svc, name);
	if ((fd = open(svc, 2)) == -1)
		return(-1);
	fd1 = ptopen(ptname);
	fd2 = open(ptname, 2);
	if (ioctl(fd, FIOSNDFD, &fd1) < 0)
		return(-1);
	uname(&un);
	sprintf(buf, "%s %s %s %s", svc, un.nodename, getlogin(), param);
	if (write(fd2, buf, strlen(buf) + 1) != strlen(buf) + 1) {
		close3(fd, fd1, fd2);
		return(-1);
	}
	if (read(fd2, &c, 1) <= 0)
		return(-1);
	switch(c) {
	case '0':
		if (read(fd2, buf, sizeof buf) > 0) {
			sscanf(buf, "%d", &errno);
			errstr = strpbrk(buf, " ") + 1;
		}
		close3(fd, fd1, fd2);
		return(-1);
	case '1':
		close(fd);
		close(fd1);
		return(fd2);
	case '2':
		if (ioctl(fd2, FIORCVFD, &pfd) < 0)
			return(-1);
		close3(fd, fd1, fd2);
		return(pfd.fd);
	default:
		errno = EIO;
		close3(fd, fd1, fd2);
		return(-1);
	}
}
