/* zi.c:  Driver for 8530 SCC */
#include "../h/param.h"
#include "../h/tty.h"
#include "../h/dir.h"
#include "../h/signal.h"
#include "../h/seg.h"
#include "../h/user.h"
#include "../h/errno.h"
#include "../h/buf.h"
#include "../h/systm.h"

#define	SCC		((struct scc *) 0xfffe3000)
#define	aset(r, x)	(SCC->a_wr0 = r, SCC->a_wr0 = x)
#define	aget(r)		(SCC->a_wr0 = (r), SCC->a_wr0)
#define	bget(r)		(SCC->b_wr0 = (r), SCC->b_wr0)
#define	bset(r, x)	(SCC->b_wr0 = (r), SCC->b_wr0 = (x))

#define	VECTOR	0x80 
#define	B9600	13
#define	ACHANEL	01
#define	BCHANEL	02

struct	scc	{
	char	b_wr0;
	char	b_tdr;		/* xmit and rcv register */
	char	a_wr0;		/* control/status byte */
	char	a_tdr;		/* xmit and rcv register */
};
#define	b_rdr	b_tdr
#define	b_rr0	b_wr0
#define a_rdr	a_tdr
#define	a_rr0	a_wr0

ziinit()
{

	aset(9, 0xC0);		/* hard reset */
	aset(4, 0x4c);		/* /16, nopar, 1 stop */
	aset(3, 0xC0);		/* 8bits */
	aset(5, 0x62);		/* Xmit: 8bits, RTS  */
	aset(9, 2);		/* no interrupts */
	aset(11, 0x56);		/* use BRG */
	aset(12, 14);		/* lower byte of time constant */
	aset(13, 0);		/* high byte of time constant */
	aset(14, 0x02);		/* BRG gen src = PCLK pin */
	aset(14, 0x82);		/* clk = br gen */
	aset(14, 0x03);		/* br generator enable */
	aset(3, 0xC1);		/* rx enable */
	aset(5, 0x6a);		/* tx enable */
	aset(15, 0);		/* int on break, dcd */
	aset(0, 0x10);		/* reset external/status */
	aset(0, 0x10);		/* twice */
	aset(2,0);
	aset(9, 0);		/* no interrupts */
	aset(5, 0xea);		/* turn on the dtr bit */
	{ int i; for (i = 10000; i--; i * i);}	/* wait for chip to setup */
}


putchar(c)		/* print a character on the console status driven */
	char c;
{
	while ((SCC->a_rr0 & 04) == 0)
		;
	SCC->a_tdr = c;
	if (c == '\n')
		putchar('\r');
}

getchar()		/* return the next character typed */
{
	register char c;

	while ((SCC->a_rr0 & 01) == 0)
		;
	c = SCC->a_rdr & 0177;
	if (c == '\r')
		c = '\n';
	putchar(c);
	return c;
}
