#include "param.h"
#include "systm.h"
#include "map.h"
#include "dir.h"
#include "signal.h"
#include "seg.h"
#include "ipm.h"
#include "sid.h"
#include "user.h"
#include "errno.h"
#include "proc.h"
#include "buf.h"
#include "reg.h"
#include "file.h"
#include "inode.h"
#include "acct.h"
#include "wait.h"
#include "reboot.h"
#include "conf.h"


/*
 * exec system call, with and without environments.
 */
struct execa {
	char	*fname;
	char	**argp;
	char	**envp;
};

exec()
{
	((struct execa *)u.u_ap)->envp = NULL;
	exece();
}

exece()
{
	register unsigned nc;
	register char *cp;
	register struct buf *bp;
	register struct execa *uap;
	int na, ne, ucp, ap, c;
	unsigned bno;
	struct inode *ip;
	extern struct inode *gethead();

	bp = 0;
	bno = 0;
	if ((ip = namei(uchar, 0)) == NULL)
		return;
	if (access(ip, IEXEC) ||
	   (ip->i_mode & IFMT) != IFREG ||
	   (ip->i_mode & (IEXEC|(IEXEC>>3)|(IEXEC>>6))) == 0) {
		u.u_error = EACCES;
		goto bad;
	}
	na = nc = ne = 0;
	uap = (struct execa *)u.u_ap;
	/* collect arglist */
	if ((bno = malloc(swapmap, (NCARGS+BSIZE-1)/BSIZE)) == 0)
		panic("Out of swap");
	if (uap->argp) for (;;) {
		ap = NULL;
		if (uap->argp) {
			ap = fuword((caddr_t)uap->argp);
			uap->argp++;
		}
		if (ap == NULL && uap->envp) {
			uap->argp = NULL;
			if ((ap = fuword((caddr_t)uap->envp)) == NULL)
				break;
			uap->envp++;
			ne++;
		}
		if (ap==NULL)
			break;
		na++;
		if (ap == -1)
			u.u_error = EFAULT;
		do {
			if (nc >= NCARGS-1)
				u.u_error = E2BIG;
			if ((c = fubyte((caddr_t)ap++)) < 0)
				u.u_error = EFAULT;
			if (u.u_error)
				goto bad;
			if ((nc & BMASK) == 0) {
				if (bp)
					bdwrite(bp);
				bp = getblk(swapdev, swplo+bno+(nc>>BSHIFT));
				cp = bp->b_un.b_addr;
			}
			nc++;
			*cp++ = c;
		} while (c > 0);
	}
	if (bp)
		bdwrite(bp);
	bp = 0;
	nc = (nc + NBPW-1) & ~(NBPW-1);
	getxfile(ip, nc + sizeof (char *) *na);
	if (u.u_error)
		goto bad;

	/* copy back arglist */

	ucp = USRSTACK - nc - NBPW;
	ap = ucp - na*NBPW - 3*NBPW;
	u.u_ar0[SP] = ap;
	suword((caddr_t)ap, na-ne);
	nc = 0;
	for (;;) {
		ap += NBPW;
		if (na==ne) {
			ap += NBPW;
		}
		if (--na < 0)
			break;
		suword((caddr_t)ap, ucp);
		do {
			if ((nc & BMASK) == 0) {
				if (bp)
					brelse(bp);
				bp = bread(swapdev, swplo+bno+(nc>>BSHIFT));
				bp->b_flags |= B_AGE;
				bp->b_flags &= ~B_DELWRI;
				cp = bp->b_un.b_addr;
			}
			subyte((caddr_t)ucp++, (c = *cp++));
			nc++;
		} while (c & 0377);
	}
	suword((caddr_t)ap, 0);
	suword((caddr_t)ucp, 0);
	setregs();
bad:
	if (bp)
		brelse(bp);
	if (bno)
		mfree(swapmap, ((NCARGS+BSIZE-1)/BSIZE), bno);
	iput(ip);
	return;
}

/*
 *	Read in and set up memory for executed file.
 * Zero return is normal;
 * non-zero means only the text is being replaced
 */


getxfile(ip, nargc)
	register struct inode *ip;
{
	register unsigned ds, ts, ss;
	register i, n, lsize;

	/*
	 * read in first few bytes of file for segment sizes
	 * ux_mag = 407/410
	 *  407 is plain executable
	 *  410 is RO text
	 *  set ux_tstart to start of text portion
	 */
	u.u_base = (caddr_t)&u.u_exdata;
	u.u_count = sizeof(u.u_exdata);
	u.u_offset = 0;
	u.u_segflg = 1;
	readi(ip);
	u.u_segflg = 0;
	if (u.u_error)
		goto bad;
	if (u.u_count != 0) {
		u.u_error = ENOEXEC;
		goto bad;
	}
	if (u.u_exdata.ux_mag == 0407) {
		lsize = u.u_exdata.ux_dsize + u.u_exdata.ux_tsize;
		u.u_exdata.ux_dsize = lsize;
		u.u_exdata.ux_tsize = 0;
	} else if (u.u_exdata.ux_mag != 0410) {
		u.u_error = ENOEXEC;
		goto bad;
	}
	if (u.u_exdata.ux_tsize != 0 && (ip->i_flag & ITEXT) == 0)
	if (ip->i_count != 1) {
		register struct file *fp;

		for (fp = file; fp < &file[NFILE]; fp++)
			if (fp->f_count && fp->f_inode == ip)
			if (fp->f_flag & FWRITE) {
				u.u_error = ETXTBSY;
				goto bad;
			}
	}
	ts = btoc(u.u_exdata.ux_tsize);
	ds = btoc(u.u_exdata.ux_dsize+u.u_exdata.ux_bsize);
	ss = SSIZE + btoc(nargc);
	n = ts + ds + SSIZE + btoc(NCARGS - 1);
	if (n > MAXMEM || n > maxmem) {
		u.u_error = ENOMEM;
		goto bad;
	}
	if (estabur(ts, ds, ss, RO))
		goto bad;
	/*
	 * allocate and clear core
	 * at this point, committed
	 * to the new image
	 */

	u.u_prof.pr_scale = 0;
	xfree();
	i = USIZE + ds + ss;
	expand(i);
	while (--i >= USIZE)
		clearseg(u.u_procp->p_addr + i);
	xalloc(ip);

	/*
	 * read in data segment
	 */

	estabur((unsigned) 0, ds, (unsigned) 0, RO);
	u.u_base = (caddr_t) 0;
	u.u_offset = sizeof (u.u_exdata) + u.u_exdata.ux_tsize;
	u.u_count = u.u_exdata.ux_dsize;
	readi(ip);
	/*
	 * set SUID/SGID protections, if no tracing
	 */
	if ((u.u_procp->p_flag & STRC) == 0) {
		if (ip->i_mode & ISUID)
			if (u.u_uid != 0) {
				u.u_uid = ip->i_uid;
				u.u_procp->p_uid = ip->i_uid;
			}
		if (ip->i_mode & ISGID)
			u.u_gid = ip->i_gid;
	} else
		psignal(u.u_procp, SIGTRAP);
	u.u_tsize = ts;
	u.u_dsize = ds;
	u.u_ssize = ss;
	estabur(ts, ds, ss, RO);
bad:
	return;
}

/*
 * Clear registers on exec
 */
setregs()
{
	register int *rp;
	register i;
	register struct file *fp;

	for (rp = &u.u_signal[0]; rp < &u.u_signal[NSIG]; rp++)
		if ((*rp & 1) == 0)
			*rp = 0;
	for (i = 0; i < 15; i++)
		u.u_ar0[i] = 0;
	u.u_ar0[PC] = u.u_exdata.ux_entloc;
	u.u_rval1 = u.u_ar0[R8] = USRSTACK - ctob(u.u_ssize - USIZE);
	u.u_rval2 = 0;

	for (i = 0; i < NOFILE; i++) {
		if (u.u_pofile[i] & EXCLOSE) {
			closef(u.u_ofile[i]);
			u.u_ofile[i] = NULL;
			u.u_pofile[i] &= ~EXCLOSE;
		}
	}
	/*
	 * Remember file name for accounting.
	 */
	u.u_acflag &= ~AFORK;
	bcopy((caddr_t)u.u_dent.d_name, (caddr_t)u.u_comm, DIRSIZ);
}

/*
 * exit system call:
 * pass back caller's arg
 */
rexit()
{
	register struct a {
		int	rval;
	} *uap;

	uap = (struct a *)u.u_ap;
	exit((uap->rval & 0377) << 8);
}

/*
 * Release resources.
 * Enter zombie state.
 * Wake up parent and init processes,
 * and dispose of children.
 */
exit(rv)
{
	register int i;
	register struct proc *p, *q;

	if (u.u_procp->p_pid == 1)		/* very bad boy!!! */
		pcc_reboot(RB_NOSYNC);
	p = u.u_procp;
	p->p_flag &= ~(STRC|SULOCK);
	msgclean();		/* clean up any messages */
	p->p_clktim = 0;
	p->p_seltim = 0;
	for (i = 0; i < NSIG; i++)
		u.u_signal[i] = 1;
	for (i = 0; i < NOFILE; i++) {
		if (u.u_ofile[i] != NULL)
			closef(u.u_ofile[i]);
	}
	plock(u.u_cdir);
	iput(u.u_cdir);
	if (u.u_rdir) {
		plock(u.u_rdir);
		iput(u.u_rdir);
	}
	xfree();
	acct(rv);
	mfree(coremap, p->p_size, p->p_addr);
	p->p_stat = SZOMB;
	((struct xproc *)p)->xp_xstat = rv;
	((struct xproc *)p)->xp_utime = u.u_cutime + u.u_utime;
	((struct xproc *)p)->xp_stime = u.u_cstime + u.u_stime;
	for (q = &proc[1]; q < &proc[NPROC]; q++)
		if (p->p_pid == q->p_ppid) {
			wakeup((caddr_t) &proc[1]);
			q->p_ppid = 1;
			if (q->p_stat == SSTOP)
				setrun(q);
		}
	for (q = &proc[0]; q < &proc[NPROC]; q++)
		if (p->p_ppid == q->p_pid) {
			wakeup((caddr_t)q);
			swtch();
			/* no return */
		}
	swtch();
}

/*
 * Wait system call.
 * Search for a terminated (zombie) child,
 * finally lay it to rest, and collect its status.
 * Look also for stopped (traced) children,
 * and pass back status from them.
 */
wait()
{
	rwait(-1, 0);
}

waitpid()
{
	register struct a {
		int	pid;
		int	statloc;	/* unused */
		int	options;
	} *uap;

	uap = (struct a *)u.u_ap;
	rwait(uap->pid, uap->options);
}



rwait(pid, option)	/* do work of wait and waitpid */
{
	register f;
	register struct proc *p;

	f = 0;
loop:
	for (p = &proc[1]; p < &proc[NPROC]; p++) {
		if (pid == -1) {
			if (p->p_ppid != u.u_procp->p_pid)
				continue;
		} else if (pid < -1) {
			if (p->p_pgrp != -pid)
				continue;
		} else if (pid == 0) {
			if (p->p_pgrp != u.u_procp->p_pgrp)
				continue;
		} else
			if (p->p_pid != pid)
				continue;
		/* found one! */
		f++;
		if (p->p_stat == SZOMB) {
			u.u_rval1 = p->p_pid;
			u.u_rval2 = ((struct xproc *)p)->xp_xstat;
			u.u_cutime += ((struct xproc *)p)->xp_utime;
			u.u_cstime += ((struct xproc *)p)->xp_stime;
			p->p_stat = NULL;
			p->p_pid = 0;
			p->p_ppid = 0;
			p->p_pgrp = 0;
			p->p_sig = 0L;
			p->p_flag = 0;
			p->p_wchan = 0;
			return;
		}
		if (p->p_stat == SSTOP) {
			if ((p->p_flag&SWTED) == 0) {
				p->p_flag |= SWTED;
				u.u_rval1 = p->p_pid;
				u.u_rval2 = (fsig(p)<<8) | 0177;
				return;
			}
			continue;
		}
	}
	if (f) {
		if (option & WNOHANG) {
			u.u_rval1 = 0;
			u.u_rval2 = 0;
			return;
		}
		sleep((caddr_t)u.u_procp, PWAIT);
		goto loop;
	}
	u.u_error = ECHILD;
}

/*
 * fork system call.
 */
fork()
{
	register a;
	register struct proc *p1, *p2;

	/*
	 * Disallow if
	 *  No processes at all;
	 *  not su and too many procs owned; or
	 *  not su and would take last slot; or
	 *  not su and no space on swap.
	 * Part of check done in newproc().
	 */
	if ((a = malloc(swapmap, ctod(MAXMEM))) == 0) {
		u.u_error = ENOMEM;
		goto out;
	}
	mfree(swapmap, ctod(MAXMEM), a);
	a = 0;
	p2 = NULL;
	for (p1 = &proc[0]; p1 < &proc[NPROC]; p1++) {
		if (p1->p_stat == NULL && p2 == NULL)
			p2 = p1;
		else {
			if (p1->p_uid == u.u_uid && p1->p_stat != NULL)
				a++;
		}
	}
	if (p2 == NULL || (u.u_uid != 0 && (p2 == &proc[NPROC - 1]
		|| a > MAXUPRC))) {
		u.u_error = EAGAIN;
		goto out;
	}
	p1 = u.u_procp;
	if (newproc(1)) {
		u.u_rval1 = u.u_procp->p_ppid;
		u.u_rval2 = 1;  /* child */
		u.u_start = time;
		u.u_ticks = lbolt;
		u.u_mem = u.u_procp->p_size;
		u.u_ior = u.u_iow = u.u_ioch = 0;
		u.u_cstime = 0;
		u.u_stime = 0;
		u.u_cutime = 0;
		u.u_utime = 0;
		u.u_acflag = AFORK;
		return;
	}
out:
	u.u_rval2 = 0; /* parent */
}

/*
 * break system call.
 *  -- bad planning: "break" is a dirty word in C.
 */
sbreak()
{
	struct	a {
		char *nsize;
	};
	register a, n, d;
	int i;

	/*
	 * set n to new data size
	 * set d to new-old
	 * set n t- new total size
	 */

	n = btoc((int) ((struct a *)u.u_ap)->nsize);
	n -= ctos(u.u_tsize) * stoc(1);
	if (n < 0)
		n = 0;
	d = n - u.u_dsize;
	n += USIZE + u.u_ssize;
	if (estabur(u.u_tsize, u.u_dsize + d, u.u_ssize, RO))
		return;
	u.u_dsize += d;
	if (d > 0)
		goto bigger;
	a = (int) (u.u_procp->p_addr + n - u.u_ssize);
	i = n;
	n = u.u_ssize;
	while (n--) {
		copyseg(a - d, a);
		a++;
	}
	expand(i);
	return;
bigger:
	expand(n);
	a = (int) (u.u_procp->p_addr + n);
	n = u.u_ssize;
	while (n--) {
		a--;
		copyseg(a - d, a);
	}
	while (d--)
		clearseg(--a);
}
