.
. Reconstructed source code of NOS/MT
.
.   Original code by John Walker / Dan Drake, ca. 1980
.   Disassembly tool by Peter Buro, 1986
.
          idt       "FILESYST"
.
          copy      "../systemdef/sysdef"
          copy      "../systemdef/filedef"
          copy      "../systemdef/fsdef"
.
lru$hd    equ       lru$q+qfl
ino$hd    equ       ino$q+qfl
.
. =============================================================================
.         FILE SYSTEM TASK INITIALISATION
. =============================================================================
.
FSINIT*   mov       ACTIVE,r10                initialise stack ptr
          ai        r10,phls                  (max 50 words, see def. of fsph)

          li        r9,lru$q                  initialise buffer lru list
          blwp      INITQ$
          li        r9,ino$fq                 initialise free inode table
          blwp      INITQ$
          li        r9,ino$q                  initialise open inode table      
          blwp      INITQ$

          li        r9,lru$q                  BUILD DISK BUFFER LRU QUEUE
          li        r8,FBLKS
          li        r0,NXFB
jlb000    clr       dbsu(r8)                  mark each block as unused
          clr       dbdrty(r8)                and not dirty
          blwp      INSERT
          ai        r8,NXBS
          dec       r0
          jne       jlb000

          li        r9,ino$fq                 BUILD FREE MEMORY INODE QUEUE
          li        r8,FMIB
          ai        r8,inodmq                 offset to queue words
          li        r0,NXMI
jlb001    blwp      INSERT
          ai        r8,iml                    move to next memory inode
          dec       r0
          jne       jlb001

          li        r3,BTVOLM                 AUTOMOUNT VOLUME IF NEEDED
          jeq       fsloop  
          li        r7,BTVOLT                 get automount name from config
          li        r6,BTVOLN
          bl        domount                   attempt mount
          data      fsloop                      -> ignore all errors
          data      fsloop  
          data      fsloop  
          data      fsloop  
          data      fsloop
.
. =============================================================================
.         FILE SYSTEM TASK MAIN MESSAGE LOOP
. =============================================================================
.
fsloop    li        r0,FSWORK                 wait for request msg to arrive
          blwp      P$
          li        r9,FSMSGQ                 fetch message, ptr in r8
          blwp      REMOVE
          mov       r8,msgptr

          mov       mbtype(r8),r0             SEARCH FOR SERVICE ROUTINE
          li        r1,jsystb                 22 routines in FS jsys table
          li        r2,22
jlb004    c         r0,*r1+
          jeq       jlb003
          inct      r1                         
          dec       r2
          jne       jlb004  
          lrex                                not found, panic into boot rom

jlb003    mov       *r1,r1                    fetch service routine
          b         *r1                       -> go do the work

jsystb    data      11, jread   
          data      12, jwrite  
          data      36, jlock  
          data      18, jfstat  
          data       5, jopen  
          data       6, jclose  
          data       7, jcreat  
          data       8, jlink  
          data       9, jdelete  
          data      34, jfdup  
          data      35, jfosta  
          data      10, jmkdir  
          data      16, jioctl
          data      19, jalloc  
          data      20, jsboot  
          data      21, jsync  
          data      22, jmount  
          data      23, jdmount  
          data      24, jchacc  
          data      25, jchown  
          data      31, jvstat  
          data      33, jprep

replok    mov       msgptr,r8                 re-use request as reply
          clr       frstat(r8)                set status OK

sndrep    mov       msgptr,r8                 send reply to reply queue
          mov       mbrpl(r8),r9
          blwp      INSERT
          mov       r9,r0                     signal new reply arrival
          ai        r0,4                         to user handler process
          blwp      V$
          b         fsloop                    -> go process next request
.
. =============================================================================
.         FILE SYSTEM CALL PROCESSING
. =============================================================================

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | path len     |    0 | status       |
.  2 | path text    |    2 | file code    |
.  x |    ..        |      +--------------+
.    +--------------+

jopen     clr       r0                        TEST FOR BLOCK SPECIAL DEVICE
          bl        testsp                    path is "vol:DISC$.DEV"?
          data      opndev                      -> yes

          clr       r0                        OPEN REGULAR FILE
          bl        opnpath                   parse path, open inode buffer
          data      err$r0                      -> relay error
          bl        filino                    close directory, open file
jlb008    mov       msgptr,r7
          mov       r1,frtext(r7)             reply is inode ptr (= file code)
          b         replok                    -> reply with status OK
.
. Open a pseudo-file ("inode #0") that spans the entire disk volume
.
opndev    mov       sustat(r2),r0             OPEN DEVICE, get mount status
          ci        r0,0                      is SU mounted?
          jne       jlb005                      -> yes
          b         efsfmt                      -> no, report invalid volume

jlb005    ci        r0,2                      is SU mounted raw ('*')?
          jeq       jlb006                      -> yes
          mov       msgptr,r1
          mov       fmgid(r1),r0              user is group zero (super)?
          jeq       jlb006                      -> yes
          b         e$perm                    report permission violation

jlb006    li        r9,ino$fq                 GET A FREE INODE BUFFER
          blwp      REMOVE
          c         r8,r9                     free list empty?
          jne       jlb007                      -> no
          b         einful                    -> report too many files open
jlb007    li        r9,ino$q                  add inode to in-use list
          blwp      PUSH$

          mov       r8,r1                     BUILD CUSTOM INODE BUFFER
          ai        r1,-inodmq                go to start of buffer
          li        r9,1
          mov       r9,imrefc(r1)             set buffer refcount to 1
          mov       r9,irefc(r1)              set inode refcount to 1
          clr       inonum(r1)                set inode no. to zero
          mov       r2,isuptr(r1)             set SU block ptr
          clr       idirty(r1)                clear dirty flag
          clr       ilckvl(r1)                clear locking
          clr       ilck$q(r1)
          li        r0,0C1B6                  set flags: contiguous,
          mov       r0,iflags(r1)               acess rw-rw-rw
          mov       sunblk(r2),r4             set file length to disk size
          mpy       sublkl(r2),r4               in bytes
          mov       r4,isizeh(r1)
          mov       r5,isizel(r1)
          clr       igroup(r1)                set owner gid to zero
          clr       iuser(r1)                 set owner uid to zero
          clr       ipgmap(r1)                set start at block 0
          mov       sunblk(r2),ipgmap+2(r1)   set length in blocks
          inc       ipgmap+2(r2)                to disk size
          jmp       jlb008                    -> reply with inode ptr

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | file code    |    0 | status       |
.    +--------------+      +--------------+

jclose    mov       fmrqst(r8),r1             fetch inode ptr
          bl        clsino                    close inode
          data      e$dkio                      -> catch I/O error
          b         replok                    -> reply with status OK

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | access bits  |    0 | status       |
.  2 | path len     |    2 | file code    |
.  4 | path text    |      +--------------+
.  . |    ..        |
.    +--------------+

jcreat    mov       msgptr,r7                 GET PATH
          ai        r7,fmrqst+2
          mov       *r7+,r6                   r6 = len, r7 = ptr
          bl        basedir                   get base volume/directory
          data      enmfmt                      -> catch invalid volume

          mov       msgptr,r3                 CREATE FILE
          mov       fmrqst(r3),r3             get access bits
          bl        mkpath                    -> do the work
          data      e$dkio  
          data      einful  
          data      enmfmt  
          data      e$nfnd  
          data      enodir  
          data      e$perm  
          data      edkful  
          data      emaxfl  
          data      efsfmt  
          mov       msgptr,r7                 set file code in reply
          mov       r1,frtext(r7)
          b         replok                    -> reply with status OK

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | path len     |    0 | status       |
.  2 | path text    |      +--------------+
.  x |    ..        |
.    +--------------+

jdelete   mov       msgptr,r7                 GET PATH
          ai        r7,fmrqst
          mov       *r7+,r6                   r6 = len, r7 = ptr
          bl        basedir                   get base volume/directory
          data      enmfmt                      -> catch invalid volume

          bl        rmpath                    DELETE FILE
          data      e$dkio  
          data      einful  
          data      enmfmt  
          data      e$nfnd  
          data      enodir  
          data      e$perm  
          data      e$void  
          data      emaxfl  
          data      efsfmt  
          b         replok                    -> reply with status OK

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | alias len    |    0 | status       |
.  2 | path len     |      +--------------+
.  x | alias + path |
.  x |   texts      |
.    +--------------+

jlink     mov       msgptr,r7                 GET PATH
          mov       fmrqst(r7),r6             r6 = len
          ai        r7,fmrqst+4               r7 = path string ptr
          bl        basedir                   get base volume/directory
          data      enmfmt                      -> catch invalid volume
          mov       r0,lbl030                 save SU ptr
          mov       r2,lbl031                 save SU #

          bl        rdpath                    PARSE PATH FOR READ ACCESS
          data      e$dkio  
          data      einful  
          data      enmfmt  
          data      e$nfnd  
          data      enodir  
          data      e$perm  
          data      edkful  
          data      emaxfl  
          data      efsfmt
          mov       r0,temp3                  save file inode#
          bl        clsino                    close encl. dir inode
          data      e$dkio                      -> catch I/O error
          mov       temp3,r0
          bl        opnino                    open file
          data      e$dkio                      -> catch I/O error
          data      einful                      -> catch inode table full
          mov       iflags(r1),r0             is it a directory?
          andi      r0,ifft
          ci        r0,ifftd
          jne       jlb00A                      -> no
          bl        clsino                    close inode
          data      e$dkio                      -> catch I/O error
          b         e$2dir                    -> report 'cannot link to dir'

jlb00A    bl        clsino                    close file at path
          data      e$dkio                      -> catch I/O error

          mov       msgptr,r7                 CHECK ALIAS PATH
          mov       fmrqst+2(r7),r6           get alias length
          a         fmrqst(r7),r7             calc start of alias string
          ai        r7,fmrqst+4
          bl        getsu                     parse SU string for alias
          data      lbl037                      -> no SU string found
          data      enmfmt                      -> volume not mounted
          c         r2,lbl031                 alias is on same volume?
          jeq       jlb00B                      -> yes
          b         e$span                    -> report 'bad link span'

jlb00B    mov       lbl030,r0                 CREATE ALIAS DIR ENTRY
          mov       temp3,r3
          bl        mkalias                   create file entry
          data      e$dkio  
          data      einful  
          data      enmfmt  
          data      e$nfnd  
          data      enodir  
          data      e$perm  
          data      edkful  
          data      eexist  
          data      efsfmt  
          b         replok                    -> reply with status OK

lbl037    mov       lbl031,r2                 default is alias on same volume
          jmp       jlb00B                    -> create alias dir entry

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | file code    |    0 | status       |
.    +--------------+    2 | file code    |
.                          +--------------+

jfdup     mov       fmrqst(r8),r1             get file code = inode buf ptr
          mov       isuptr(r1),r2             get SU ptr
          mov       inonum(r1),r0             get inode#
          bl        opnino                    open again (= increase refcount)
          data      e$dkio                      -> catch I/O error
          data      einful                      -> catch inode table full
          mov       msgptr,r7                 put file code in reply
          mov       r1,frtext(r7)
          b         replok                    -> send reply with status OK

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | path len     |    0 | status       |
.  2 | path text    |      +--------------+
.    +--------------+

jmkdir    clr       r0                        PARSE THE PATH
          bl        opnpath                   find dir + inode#
          data      err$r0                      -> catch errors

          mov       inonum(r1),temp3          save inode# of dir ("..")
          mov       r0,lbl030                 save inode# of file
          bl        clsino                    close the enclosing dir
          data      e$dkio                      -> catch I/O error
          mov       lbl030,r0                 get the file (= new dir) inode#
          bl        opnino                    open the file
          data      e$dkio                      -> catch I/O errors
          data      einful                      -> catch inode table full
          mov       temp3,r3                  get the parent dir inode#

          bl        mk$dir                    CONVERT FILE TO DIRECTORY
          data      c$dkio                      -> catch I/O errors
          data      cinful                      -> catch inode table full
          data      cdkful                      -> catch disk full
          data      cfltyp                      -> catch bad file type
          data      c$2dir                      -> catch double dir name
          data      c$void                      -> catch file not empty
          data      c$perm                      -> catch permission errors

          bl        clsino                    close file
          data      e$dkio                      -> catch I/O errors
          b         replok                    -> reply with status OK

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | path len     |    0 | status       |
.  2 | path text    |      +--------------+
.    +--------------+

jsboot    clr       r0                        PARSE THE PATH
          bl        opnpath                   find dir + inode#
          data      err$r0                      -> catch errors
          bl        filino                    close directory, open file

          bl        doboot                    UPDATE THE DISK BOOT SECTOR
          data      c$dkio                      -> catch I/O errors
          data      cfltyp                      -> catch bad file type

          bl        clsino                    close the file
          data      e$dkio                      -> catch I/O errors
          b         replok                    -> reply with status OK

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | access bits  |    0 | status       |
.  2 | path len     |      +--------------+
.  4 | path text    |
.  . |    ..        |
.    +--------------+

jchacc    li        r0,2                      PARSE PATH
          bl        opnpath                   find dir + inode#
          data      err$r0                      -> catch errors
          bl        filino                    close directory, open file

          mov       msgptr,r7                 CHECK PERMISSISIONS
          mov       fmgid(r7),r0              caller gid = 0 (superuser)?
          jeq       jlb00C                      -> yes, go do it
          c         r0,igroup(r1)             caller gid = file gid?
          jne       jlb00D                      -> no, group mismatch
          c         fmuid(r7),iuser(r1)       caller uid = file uid?
          jne       jlb00D                      -> no, user mismatch

jlb00C    mov       fmrqst(r7),r0             SET NEW ACCESS PERMISSION BITS
          andi      r0,003FF                  mask out non-permission bits
          mov       iflags(r1),r3             get file flags
          andi      r3,0FC00                  mask out the permission bits
          soc       r0,r3                     merge both parts
          mov       r3,iflags(r1)             and store back to inode
          bl        updtim                    new last modified time
          bl        clsino                    close file
          data      e$dkio                      -> catch I/O errors
          b         replok                    -> reply with status OK

jlb00D    b         c$perm                    -> reply with 'perm. violation'

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | new gid      |    0 | status       |
.  2 | new uid      |      +--------------+
.  4 | path len     |
.  6 | path text    |
.  . |  ..          |
.    +--------------+

jchown    li        r0,4                      PARSE PATH
          bl        opnpath                   find dir + inode#
          data      err$r0                      -> catch errors
          bl        filino                    close directory, open file

          mov       msgptr,r7                 CHECK PERMISSISIONS
          mov       fmgid(r7),r0              caller gid = 0 (superuser)?
          jeq       jlb00E                      -> yes, go do it
          b         c$perm                    -> no, cls ino & security error

jlb00E    mov       fmrqst(r7),igroup(r1)     update inode gid
          mov       fmrqst+2(r7),iuser(r1)    update inode uid
          bl        updtim                    set modified time
          bl        clsino                    close inode buffer
          data      e$dkio                      -> report I/O error
          b         replok                    -> reply with status OK

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | file code    |    0 | status       |
.  2 | offset H     |    2 | actual len   |
.  4 | offset L     |      +--------------+
.  6 | buffer addr  |
.  8 | user mem bnk |
. 10 | read len     |
.    +--------------+

jread     ai        r8,fmrqst                 get inode ptr
          mov       *r8+,r1
          bl        getperm                   get permission bits
          andi      r5,ifread                 read permitted?
          jeq       jlb00F                      -> no, error

          mov       *r8+,r3                   fetch offset (32 bit)
          mov       *r8+,r4
          mov       *r8+,r6                   fetch buffer address
          mov       *r8+,usrbnk               fetch & save user memory bank
          mov       *r8,r5                    fetch length
          seto      umode                     set user mode operation
          bl        rdfile                    read from the file
          data      lbl049                      -> catch I/O error
          mov       msgptr,r7                 place bytes read in response
          mov       r0,frtext(r7)
          b         replok                    -> reply with status OK

lbl049    mov       msgptr,r7                 reply with actual len so far
          mov       r0,frtext(r7)
          b         e$dkio                    -> reply with I/O error

jlb00F    mov       msgptr,r7                 reply with actual len zero
          clr       frtext(r7)
          b         e$perm                    -> reply with security error
          
. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | file code    |    0 | status       |
.  2 | offset H     |    2 | actual len   |
.  4 | offset L     |      +--------------+
.  6 | buffer addr  |
.  8 | user mem bnk |
. 10 | write len    |
.    +--------------+

jwrite    ai        r8,fmrqst                 get inode ptr
          mov       *r8+,r1
          bl        getperm                   get permission bits
          andi      r5,ifwrite                write permitted?
          jeq       jlb010                      -> no, error
          mov       iflags(r1),r0             is it a normal file?
          andi      r0,ifft
          ci        r0,ifftn
          jne       jlb010                      -> no, error

          mov       *r8+,r3                   fetch offset (32 bit)
          mov       *r8+,r4
          mov       *r8+,r6                   fetch buffer address
          mov       *r8+,usrbnk               fetch & save user memory bank
          mov       *r8,r5                    fetch length
          seto      umode                     set user mode operation
          bl        wrfile                    write the data
          data      lbl049                      -> catch I/O error
          data      lbl04B                      -> catch disk full
          mov       msgptr,r7                 place bytes written in response
          mov       r0,frtext(r7)
          b         replok                    -> reply with status OK

lbl04B    mov       msgptr,r7                 reply with actual len so far
          mov       r0,frtext(r7)
          b         edkful                    -> reply with device full error

jlb010    mov       msgptr,r7                 reply with actual len zero
          clr       frtext(r7)
          b         e$perm                    -> reply with security error

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | file code    |    0 | status       |
.  2 | operation    |      +--------------+
.  4 | user code    |
.    +--------------+

jlock     ai        r8,fmrqst                 GET PARAMS
          mov       *r8+,r1                   r1 = inode buffer ptr
          mov       *r8+,r3                   r3 = operation, operation = 0?
          jeq       jlb011                      -> yes, bad operation code
          ci        r3,5                      operation > 5?
          jh        jlb011                      -> yes, bad operation code
          a         r3,r3                     look up service routine
          mov       lcktab(r3),r3
          b         *r3                       -> jump to subop routine

jlb011    b         ebadsb                    -> reply 'bad operation' status

lcktab    data      lckwait                   1: lock inode, wait if needed
          data      unlock                    2: unlock inode
          data      lcktry                    3: lock inode (non-blocking)
          data      unlwait                   4: unlock, wait for next unlock
          data      funlck                    5: force unlock (priviledged)

lckwait   mov       ilckvl(r1),r0             is file currently locked?
          jne       jlb012                      -> yes
jlb013    mov       *r8,ilckvl(r1)            lock file with number
          b         replok                    return OK

jlb012    mov       msgptr,r8                 place lock request on wait list
          bl        dolock
          b         fsloop                    process next request

lcktry    mov       ilckvl(r1),r0             is file currently locked?
          jeq       jlb013                      -> no
          b         e$busy                    report device busy error

unlock    c         *r8,ilckvl(r1)            does lock value match?
          jne       jlb014                      -> no, permission error
          bl        dounlk                    remove lock from list
          b         replok                    return OK
          
jlb014    b         e$perm                    report security error

unlwait   c         *r8,ilckvl(r1)            does lock value match?
          jne       jlb014                      -> no, permission error
          bl        dounlk                    free lock
          mov       msgptr,r8                 add lock
          bl        dolock
          b         fsloop

funlck    mov       msgptr,r2                 user has group id zero?
          mov       fmgid(r2),r0
          jne       jlb014                      -> no, permission error
          bl        dounlk                    remove lock
          b         replok                    return OK

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.    +--------------+    0 | status       |
.                          +--------------+

jsync     bl        dosync                    flush all inode & disk buffers
          data      e$dkio                      -> catch & report I/O errors
          b         replok                    -> reply with status OK

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | access bits  |    0 | status       |
.  2 | path len     |    2 | file code    |
.  4 | path text    |      +--------------+
.  . |    ..        |
.    +--------------+

jmount    mov       fmrqst(r8),r3             r3 = access bits
          mov       fmrqst+2(r8),r6           r6 = text len
          mov       r8,r7
          ai        r7,fmrqst+4               r7 = text ptr
          bl        domount                   mount the volume
          data      e$dkio                      -> catch I/O error
          data      enmfmt                      -> catch bad name
          data      e$busy                      -> catch device busy
          data      emount                      -> catch volume name error
          data      e$perm                      -> catch permission error
          b         replok                    return OK

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | path len     |    0 | status       |
.  2 | path text    |      +--------------+
.  x |    ..        |
.    +--------------+

jdmount   mov       msgptr,r7                 fetch parameters
          ai        r7,fmrqst                 r7 = text ptr
          mov       *r7+,r6                   r6 = text len
          bl        getsu                     parse volume name
          data      enmfmt                      -> no SU name/number found
          data      enmfmt                      -> volume not mounted
          bl        dismnt                    dismount volume
          data      e$dkio                      -> catch I/O errors
          data      e$busy                      -> catch volume in use
          data      e$perm                      [??] vector not used
          b         replok                    -> reply with status OK

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | file code    |    0 | status       |
.  2 | alloc size H |      +--------------+
.  4 | alloc size L |
.    +--------------+

jalloc    mov       fmrqst(r8),r1             fetch file inode buf ptr
          mov       fmrqst+2(r8),r3           fetch new size
          mov       fmrqst+4(r8),r4

          mov       isuptr(r1),r2             round new size up to full block
          mov       sublkl(r2),r0
          dec       r0
          a         r0,r4
          jnc       jlb015  
          inc       r3
jlb015    div       sublkl(r2),r3
          jno       jlb016                    total size < 65K blocks?
          b         edkful                      -> no, error

jlb016    mov       r3,r0                     allocate blks as contiguous file
          bl        doaloc                      (erases existing data!)
          data      e$dkio                      -> catch disk error
          data      efltyp                      -> catch improper file type
          data      edkful                      -> catch disk full
          b         replok                    -> reply with status OK

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | path len     |    0 | status       |
.  2 | path text    |    2 | SU number    |
.  x |    ..        |    4 | inode no.    |
.    +--------------+    6 | disk         |
.                        | |    inode     |
.                       44 |       struct |
.                          +--------------+

jfstat    clr       r0                        OPEN PATH
          bl        opnpath                   parse path and open inode buffer
          data      err$r0                      -> catch any errors
          bl        filino                    close directory, open file

lbl05B    mov       r1,temp3                  ALLOCATE REPLY MSG
          li        r1,56                     reply is 28 words
          blwp      BGETA$                    allocate new message
          data      MEMFUL                      (is larger than inbound msg)
          mov       msgptr,r7
          mov       mbrpl(r7),mbrpl(r1)       copy reply queue
          mov       r1,msgptr                 swap msg pointers
          mov       r1,r3
          mov       r7,r1
          blwp      BREL$                     release inbound message
          ai        r3,frtext                 r3 = start of reply text

          clr       *r3+                      BUILD REPLY, start with status OK
          mov       temp3,r1                  look up SU# from SU ptr
          mov       isuptr(r1),r2
          clr       r0
          li        r4,SUITL
          li        r5,SUIT
jlb018    inc       r0
          c         r2,*r5+
          jeq       jlb017  
          dec       r4
          jne       jlb018
jlb017    mov       r0,*r3+                   store SU# in response

          mov       inonum(r1),*r3+           store inode# in response

          li        r0,19                     copy disk inode data
jlb019    mov       *r1+,*r3+
          dec       r0
          jne       jlb019

          mov       temp3,r1                  CLEANUP
          bl        clsino                    close file inode
          data      e$dkio                      -> catch I/O errors
          b         replok                    -> reply with status OK

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | file code    |    0 | status       |
.    +--------------+    2 | SU number    |
.                        4 | inode no.    |
.                        6 | disk         |
.                        | |    inode     |
.                       44 |       struct |
.                          +--------------+

jfosta    mov       fmrqst(r8),r1             get inode ptr
          mov       isuptr(r1),r2             get SU ptr
          mov       inonum(r1),r0             get inode#
          bl        opnino                    open inode (i.e. dup)
          data      e$dkio                      -> catch I/O errors
          data      einful                      -> catch too many files open
          b         lbl05B                    handle as fstat (closes inode)

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | path len     |    0 | status       |
.  2 | path text    |    2 | SU number    |
.  x |  ..          |    4 | SU           |
.    +--------------+    | |   control    |
.                       56 |        block |
.                          +--------------+

jvstat    mov       msgptr,r7                 FIND SU FROM PATH
          ai        r7,fmrqst                 get text
          mov       *r7+,r6                   get text length
          bl        basedir                   find base SU+dir
          data      enmfmt                      -> bad volume name

          li        r1,68                     ALLOCATE REPLY MSG
          blwp      BGETA$                    allocate new message (34 words,
          data      MEMFUL                      is larger than inbound msg)
          mov       msgptr,r7
          mov       mbrpl(r7),mbrpl(r1)       copy reply queue
          mov       r1,msgptr                 swap msg pointers
          mov       r1,r3
          mov       r7,r1
          blwp      BREL$                     release inbound message
          ai        r3,frtext                 r3 = start of reply text
          clr       *r3+                      first word is dummy zero?

          clr       r0                        STORE SU NUMBER
          li        r4,SUITL                  find SU number by scanning SU
          li        r5,SUIT                     table for matching ptr
jlb01B    inc       r0
          c         r2,*r5+
          jeq       jlb01A  
          dec       r4
          jne       jlb01B
jlb01A    mov       r0,*r3+                   store number in reply

          li        r0,26                     STORE COPY OF SU TABLE
jlb01C    mov       *r2+,*r3+
          dec       r0
          jne       jlb01C

          mov       msgptr,r8                 STORE FREE SPACE INFO
          ai        r8,sustat+4               repurpose sustat & surefc
          clr       *r8+                      clear fields for nothing mounted
          clr       *r8
          ai        r2,-52                    back to start of SU data
          mov       sustat(r2),r0             file system mounted?
          ci        r0,1
          jne       jlb01D                      -> no
          bl        clcfre                    calculate free space info
          data      e$dkio                      -> catch I/O errors
          mov       msgptr,r8                 
          mov       r0,suaccb(r8)             suaccb = total free space
          mov       r1,surplm(r8)             surplm = largest free range
jlb01D    b         replok

. -----------------------------------------------------------------------------

.  Request:              Reply:
.    +--------------+      +--------------+
.    | std req hdr  |      | std rpl hdr  |
.  0 | block size   |    0 | status       |
.  2 | disk size    |    2 | actual len   |
.  4 | chk blks flg |      +--------------+
.  6 | path len     |
.  8 | path text    |
.  . |  ..          |
.    +--------------+

jprep     mov       msgptr,r7                 FIND SU+DIR FROM PATH
          ai        r7,fmrqst+6               r6 = path len
          mov       *r7+,r6                   r7 = path ptr
          bl        basedir                   find base SU+dir
          data      enmfmt                      -> bad volume name

          mov       sustat(r2),r0             CHECK MOUNT STATUS
          ci        r0,2                      is status 'mounted raw'?
          jne       jlb01E                      -> no, refuse prep

          mov       r2,r8                     FETCH NEW VOLUME NAME
          ai        r8,suvolid
          bl        getnam                    copy name from path to SU block
          data      enmfmt                      -> catch malformed name error
.
          mov       msgptr,r4                 GET PREP PARAMETERS
          mov       fmrqst+4(r4),r0           - fetch check data blocks flag
          mov       fmrqst(r4),sublkl(r2)     - set volume block size in bytes
          mov       fmrqst+2(r4),sunblk(r2)   - set volume disk size in blocks
          
          bl        doprep                    WRITE EMPTY FILE SYSTEM
          data      e$dkio                      -> catch & report I/O errors
          b         replok                    -> reply with status OK

jlb01E    b         e$perm                    -> report permission error

jioctl    b         efltyp                    -> report bad file type error

. =============================================================================
. ERROR HANDLING VECTORS & UTILITIES
. =============================================================================

e$dkio    bl        errstd    unrecoverable I/O error during request
          data      2
e$nfnd    bl        errstd    file not found in directory
          data      3
enmfmt    bl        errstd    bad file name syntax
          data      5
ebadsb    bl        errstd    bad subfunction on request
          data      6
einful    bl        errstd    memory inode table full
          data      9
enodir    bl        errstd    file path name specifies a non-directory
          data      0A
e$perm    bl        errstd    would violate system security
          data      0B
edkful    bl        errstd    storage exhausted on unit
          data      0C
emaxfl    bl        errstd    maximum files already allocated on volume
          data      0D
efltyp    bl        errstd    improper file type for requested function
          data      0E
e$2dir    bl        errstd    would result in two names for directory file
          data      0F
e$void    bl        errstd    file must be void for this function
          data      010
e$span    bl        errstd    attempt to create link from one volume to another
          data      011
eexist    bl        errstd    file already exists
          data      012
e$busy    bl        errstd    file / device busy
          data      013
emount    bl        errstd    wrong volume mounted on device
          data      014
efsfmt    bl        errstd    invalid vol / not file system format
          data      015

c$dkio    bl        errcls    unrecoverable I/O error during request
          data      2
cinful    bl        errcls    memory inode table full
          data      9
c$perm    bl        errcls    would violate system security
          data      0B
cdkful    bl        errcls    storage exhausted on unit
          data      0C
cfltyp    bl        errcls    improper file type for requested function
          data      0E
c$2dir    bl        errcls    would result in two names for directory file
          data      0F
c$void    bl        errcls    file must be void for this function
          data      010
.
errstd    mov       *r11,r0                   put error number in r0 
          jmp       err$r0

errcls    mov       *r11,temp3                fetch error number
          bl        clsino                    close inode buffer
          data      e$dkio                      -> report I/O error
          mov       temp3,r0                  put error number in r0

err$r0    mov       msgptr,r8                 return with r0 as status code
          mov       r0,frstat(r8)
          b         sndrep

. =============================================================================
.         SU AND PATH NAME PARSING + FILE CREATE, DELETE AND LINK
. =============================================================================

. Parse file name for open (and link)
.   input:  r0 = number of words to skip before SU/path string
.   output: r0 = file inode#, r1 = inode buf ptr of enclosing directory,
.           r2 = SU block ptr for this path
.
.   one error vector, when used r0 = error number
.
opnpath   pshr      r11
          mov       msgptr,r7                 FETCH SU/PATH STRING PTR
          ai        r7,fmrqst                 get text pointer in r7
          a         r0,r7                     r6 = path len
          mov       *r7+,r6                   r7 = path ptr

          bl        basedir                   GET BASE SU+DIR
          data      lbl062                      -> catch bad volume name

          bl        rdpath                    PARSE PATH FOR OPEN
          data      lbl063                      -> catch I/O error
          data      lbl064                      -> catch too many files open
          data      lbl062                      -> catch malformed name
          data      lbl065                      -> catch file not found 
          data      lbl066                      -> catch non-dir in path
          data      lbl067                      -> catch permission violation
          data      lbl068                      -> catch device full
          data      lbl069                      -> catch maximum files on dev
          data      lbl06A                      -> catch bad volume
          popr      r11                       NORMAL RETURN
          b         2(r11)

lbl062    li        r0,5                      5 = malformed name

jlb01F    popr      r11                       ERROR RETURN
          mov       *r11,r11
          rt

lbl063    li        r0,2                       2 = I/O error
          jmp       jlb01F  
lbl064    li        r0,9                       9 = too many files open
          jmp       jlb01F  
lbl065    li        r0,3                       3 = file not found
          jmp       jlb01F  
lbl066    li        r0,0A                     10 = non-directory in path
          jmp       jlb01F  
lbl067    li        r0,0B                     11 = permission violation
          jmp       jlb01F  
lbl068    li        r0,0C                     12 = device full
          jmp       jlb01F  
lbl069    li        r0,0D                     13 = maximum files on device
          jmp       jlb01F  
lbl06A    li        r0,015                    21 = bad volume / file system
          jmp       jlb01F

. -----------------------------------------------------------------------------

. Test if the path refers to a disk device special name
.   input:  r0 = number of words to skip before SU/path string
.   output: none
.
.   one error vector, taken when the name is special
.
testsp    pshr      r11                       TEST SPECIAL NAME "vol:DISC$.DEV"
          mov       msgptr,r7
          ai        r7,fmrqst
          a         r0,r7
          mov       *r7+,r6

          bl        basedir                   GET SU FROM PATH
          data      isntsp                      -> bad volume name, not special

          li        r8,tmpnam
          bl        getnam                    GET NAME FROM PATH
          data      isntsp                      -> no file name

          li        r0,7                      test for name DISC$.DEV
          li        r8,tmpnam
          li        r9,lbl06D
jlb020    c         *r8+,*r9+                 still matching?
          jne       isntsp                      -> no
          dec       r0                        more chars to go?
          jne       jlb020                      -> yes
          bl        getchr                    reached input eol?
          data      isdvsp                      -> yes

isntsp    popr      r11                       normal file name return
          b         2(r11)                      -> take normal return

isdvsp    popr      r11                       found "DISC$.DEV" file name
          mov       *r11,r11                    -> take alternate return
          rt

lbl06D    text      'DISC$.DEV     '

. -----------------------------------------------------------------------------

. Find the starting directory for a path search. If a volume is given, the
. search starts at the root of that volume. Otherwise it starts in the default
. assumed directory. If that is not set, report an error.
.
.   input:  r6,r7 = len,ptr of path string to scan
.   output: r0 = start directory inode#, r1 = start directory inode buf ptr,
.           r2 = SU block ptr of volume
.
.   one error vector, taken when the start point is undefined
.
basedir   pshr      r11                       GET BASE DIRECTORY FROM PATH
          bl        getsu                     parse SU string to SU ptr in r2
          data      lbl070                      -> catch no SU string found
          data      lbl071                      -> catch volume not mounted
          li        r0,1                      use root dir of volume
jlb021    popr      r11                       NORMAL RETURN
          b         2(r11)

lbl070    mov       msgptr,r1                 IF NO SU GIVEN, USE DEFAULT DIR.
          mov       fmdfdi(r1),r1             do we have a default one?
          jeq       lbl071                      -> no
          mov       isuptr(r1),r2
          mov       inonum(r1),r0
          jmp       jlb021

lbl071    popr      r11                       REPORT BAD PATH / NOT FOUND
          mov       *r11,r11
          rt
          
. -----------------------------------------------------------------------------

. After scanning a path, close the enclosing directory and open the file
.
.   input: r0 = file inode#, r1 = inode buffer ptr of directory
.   output: none
.
filino    mov       r11,lbl030                [??] why not pshr r11?
          mov       r0,temp3                  save inode#
          bl        clsino                    close inode buffer for dir
          data      e$dkio                      -> report I/O errors
          mov       temp3,r0                  refetch inode#
          bl        opnino                    open inode buffer for file
          data      e$dkio                      -> report I/O error
          data      einful                      -> report no free buffer found
          mov       lbl030,r11
          rt

. -----------------------------------------------------------------------------

. Parse a string for a valid volume number or valid volume name
.
.   input:  r6,r7 = len,ptr of path string to scan
.
.   output: r2 = SU block ptr of volume
.           r6,r7 = len,ptr of path string remainder
.           tempnam = volume label (if found)
.
.   two error vectors:
.     1. no SU number and/or volume name found in path
.     2. SU number or volume name found, but not valid
.
getsu     pshr      r11                       PARSE SU STRING INTO SU PTR
          pshr      r6                        pshr scan len,ptr
          pshr      r7

          bl        NUMBER                    TRY "num:" FORMAT
          mov       r3,r3                     no digits found?
          jeq       jlb022                      -> no, try label
          bl        getchr                    scan next non-printable
          data      jlb022                      -> none, try label
          ci        r0,':'                    next character is a colon?
          jne       jlb022                      -> no, try label
          dec       r1                        SU number > 0?
          jlt       jlb023                      -> no, bad SU number
          ci        r1,SUITL                  SU number <= last SU?
          jhe       jlb023                      -> no, bad SU number

          a         r1,r1                     set r2 = SU block ptr
          mov       SUIT(r1),r2

jlb029    popr      r0                        FOUND: RETURN WITH SU PTR
          popr      r0
          popr      r11
          b         4(r11)

jlb022    popr      r7                        RESET TEXT SCAN TO START
          popr      r6
          pshr      r6
          pshr      r7

          li        r3,tmpnam                 SCAN VOLUME NAME
jlb025    bl        getchr                    next character available?
          data      lbl072                      -> no, not a volume name
          ci        r0,':'                    found a colon?
          jeq       jlb024                      -> yes, check if mounted
          ci        r0,'/'                    found a slash?
          jeq       lbl072                      -> yes, not a volume name
          swpb      r0                        add character to buffer
          ci        r3,tmpnam+14
          jeq       jlb025                    up to 14 characters
          movb      r0,*r3+
          jmp       jlb025                    -> scan next character

jlb024    ci        r3,tmpnam+14              FILL OUT BUFFER WITH SPACES
          jeq       jlb026                    up to 14 characters
          movb      spaces,*r3+
          jmp       jlb024

jlb026    li        r1,SUIT                   CHECK IF MOUNTED
          li        r4,SUITL                  by checking each SU block
jlb02A    dec       r4                        past last block?
          jlt       jlb023                      -> yes, name not mounted
          mov       *r1,r2                    compare volume names
          ai        r2,suvolid
          li        r3,tmpnam
          li        r0,7                      14 bytes = 7 words
jlb028    c         *r2+,*r3+                 names still match?
          jne       jlb027                      -> no, try next SU
          dec       r0                        last character done?
          jne       jlb028                      -> no, try next
          mov       *r1,r2                    found, put SU block ptr in r2
          jmp       jlb029                    -> return w/ SU ptr in r2

jlb027    inct      r1                        next SU block
          jmp       jlb02A                    -> see if names match

lbl072    popr      r7                        REPORT NO SU/VOLUME FOUND
          popr      r6                        reset text scan pointer
          popr      r11                       and take first alternate return
          mov       *r11,r11
          rt

jlb023    popr      r7                        REPORT VOLUME NOT MOUNTED
          popr      r6                        reset text scan pointer
          popr      r11                       and take second alternate return
          mov       2(r11),r11
          rt
          
. -----------------------------------------------------------------------------

. Parse file name for open
.
.  input:  r0 = current directory inode#, r2 = volume of path
.          r6,r7 = len,ptr of path string to scan (past volume, if any)
.  output: see 'dopath' below
.
rdpath    pshr      r11
          clr       r1                        set op to 0 = search for open
          pshr      r1
          . <drops into dopath>

. -----------------------------------------------------------------------------

. Parse file name for open, create or delete. The operation is on the top of
. the stack  (0 = open, 1 = delete, 2 = create).
.
.  input:  r0 = start dir inode#, r2 = SU block ptr of path
.          r6,r7 = len,ptr of path string to scan (past volume, if any)
.          tos = operation, nos = return address 
.  output: r0 = file inode#, r1 = dir inode buf ptr
.          file name is left in 'tmpnam' buffer
.
.  nine error vectors:
.     1. throw I/O error
.     2. throw too many files open
.     3. throw malformed name
.     4. throw file not found 
.     5. throw non-dir in path
.     6. throw permission violation
.     7. throw device full
.     8. throw maximum files on dev
.     9. throw bad volume (not a NOS file system)           
.
dopath    mov       r0,r8                     SETUP
          bl        chkmtd                    check if SU is mounted
          data      lbl076                      -> not mounted as NOS FS
          bl        getchr                    get first non-space character
          data      lbl077                      -> catch none found, bad name
          ci        r0,'/'                    path has leading '/'?
          jne       jlb02B                      -> no, start in current dir
          li        r8,1                      start at root dir of volume
          jmp       jlb02C  
jlb02B    inc       r6                        push back character                     
          dec       r7

jlb02C    pshr      r8                        READ NEXT NAME
          li        r8,tmpnam                 
          bl        getnam                    read into buffer until '/' or eol
          data      lbl078                      -> catch empty name,
          popr      r8                                rethrow as malformed name

          pshr      r6                        OPEN & SEARCH CURRENT DIRECTORY
          pshr      r7
          mov       r8,r0
          bl        opnino                    open inode
          data      lbl079                      -> catch I/O error
          data      lbl07A                      -> catch too many files open
          mov       iflags(r1),r0             is it a directory?
          andi      r0,ifft
          ci        r0,ifftd
          jne       jlb02E                      -> no, throw non-dir in path

          bl        getperm                   get access bits for current user
          andi      r5,ifexec                 user has search permission?
          jeq       jlb02F                      -> no, report error

          li        r3,tmpnam
          bl        sk$dir                    search name in directory
          data      lbl07C                      -> catch I/O error
          data      lbl07D                      -> catch not found error

          mov       r0,r8                     SWITCH CURRENT DIRECTORY TO NEW                          
          popr      r7                        set cur. dir. to new name inode#
          popr      r6
          bl        getchr                    scan next non-blank character
          data      lbl07E                      -> none found, exit path search
          pshr      r8
          bl        clsino                    close current inode
          data      lbl07F                      -> catch I/O error
          popr      r8
          jmp       jlb02C                    process next name in path

lbl07E    mov       r8,r0                     HANDLE OPERATION
          popr      r11                       pop creation flag
          ci        r11,1                     op = search for create?
          jeq       creat2  
          ci        r11,2                     op = search for delete?
          jne       jlb031                      -> no, just return file inode
          b         delet1                    -> yes, continue with delete

jlb031    popr      r11                       r0 = file ino#, r1 = dir ino ptr
          b         18(r11)                   NORMAL RETURN

lbl07D    popr      r7                        HANDLE NOT FOUND CONDITION
          popr      r6                        reset path string
          popr      r11
          ci        r11,1                     operation = create?
          jne       jlb032                      -> no, report file not found
          b         creat3                    -> continue with create

jlb032    bl        clsino                    close inode
          data      lbl082                      -> catch I/O error
          popr      r11
          mov       6(r11),r11                THROW 'FILE NOT FOUND' ERROR
          rt

lbl07C    bl        clsino                    close inode
          data      lbl079                      -> catch I/O error
lbl079    popr      r7                        reset path ptr
          popr      r6
jlb033    popr      r11                       pop operation code
lbl082    popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

lbl07F    popr      r8                        pop current dir inode#
          jmp       jlb033                    throw I/O error

lbl078    popr      r8                        pop current dir inode#
lbl077    popr      r11                       pop operation code
          popr      r11
          mov       4(r11),r11                THROW 'MALFORMED' NAME ERROR
          rt

lbl07A    popr      r7                        reset path ptr
          popr      r6
          popr      r11                       pop operation code
          popr      r11
          mov       2(r11),r11                THROW 'TOO MANY FILES OPEN' ERROR
          rt

jlb02E    bl        clsino                    close inode
          data      lbl07C                      -> cath I/O error
          popr      r7                        reset path ptr
          popr      r6
          popr      r11                       pop operation code
          popr      r11
          mov       8(r11),r11                THROW 'NON DIR. IN PATH' ERROR
          rt

jlb02F    bl        clsino                    close inode
          data      lbl07C                      -> catch I/O error
          popr      r7                        reset path ptr
          popr      r6
          popr      r11                       pop operation code
          popr      r11
          mov       10(r11),r11               THROW 'SECURITY VIOLATION' ERROR
          rt

lbl076    popr      r11                       pop operation code
          popr      r11
          mov       16(r11),r11               THROW 'BAD VOLUME' ERROR
          rt

. -----------------------------------------------------------------------------

. Parse file name for create and create file or alias (link)
. 'mkpath'  is the entry point for create
. 'mkalias' is the entry point for link
.
.  input:  r0 = current directory inode#, r2 = SU blk ptr for path,
.          r3 = access bits
.          r6,r7 = len,ptr of path string to scan (past volume, if any)
.          temp2 = flag (0 = create file, -1 = make alias)
.
.  output: see 'dopath' above
.
mkpath    clr       temp2                     CREATE FILE AT PATH

creat1    pshr      r11                       (mkalias jumps here)
          mov       r3,temp1                  save access bits
          li        r1,1                      dopath operation 1 = create
          pshr      r1
          b         dopath                    parse path & continue at creat2/3

. creat2 = dopath found the file to exist already
.
creat2    pshr      r0                        save file inode#
          bl        clsino                    close enclosing directory
          data      lbl085                      -> catch I/O error
          popr      r0
          mov       temp2,r11                 is the operation create?
          jeq       jlb034                      -> yes, truncate file
          b         lbl086                    -> throw error

jlb034    bl        opnino                    open file
          data      lbl087                      -> catch I/O error
          data      lbl088                      -> catch inode table full
          mov       iflags(r1),r0             get file flags
          andi      r0,ifft
          ci        r0,ifftn                  is it a normal file?
          jne       jlb035                      -> no, cannot truncate

          bl        getperm                   get permissions for current user
          andi      r5,ifwrite                user has write permission?
          jeq       jlb035                      -> no
          mov       iflags(r1),r0             get file flags again
          andi      r0,ifcont                 is it a contiguous file?
          jeq       jlb036                      -> no
          clr       isizeh(r1)                for a contiguous file,
          clr       isizel(r1)                  truncate = set size to zero
          bl        updtim                    update modified time
          jmp       jlb037                    -> return

jlb036    bl        truncf                    truncate file
          data      lbl08A                      -> catch I/O errors
jlb037    popr      r11
          b         18(r11)                   NORMAL RETURN

jlb035    b         lbl08B                    -> throw permission error

. creat3 = dopath did not find the file to exist yet
.
creat3    bl        getchr                    at end of path?
          data      lbl08C                      -> yes, go create
          bl        clsino                    close the file
          data      lbl087                      -> catch I/O errors
          popr      r11
          mov       6(r11),r11                THROW NON-DIR IN PATH
          rt

lbl08C    mov       temp2,r11                 OPERATION = CREATE?
          jeq       jlb038                      -> yes, go create file
          b         creat4                    -> go make alias (link)

jlb038    bl        getperm                   check permissions on encl. dir             
          andi      r5,ifwrite                user has write permission?
          jeq       lbl08B                      -> no, throw permission error

          pshr      r1                        GET INODE FOR NEW FILE
          mov       isuptr(r1),r2             set up SU block ptr
          bl        newino                    find a free inode
          data      lbl08F                      -> catch I/O error
          data      lbl090                      -> catch disk inodes exhausted
          popr      r1
          
          pshr      r0                        ADD INODE/NAME TO DIRECTORY
          li        r3,tmpnam                 use given name
          bl        ad$dir                    add the entry
          data      lbl092                      -> catch I/O errors
          data      lbl093                      -> catch device full
          bl        clsino                    close directory
          data      lbl085                      -> catch I/O errors
          popr      r0

          bl        opnino                    LOAD & CLEAR NEW INODE
          data      lbl087                      -> catch I/O error
          data      lbl088                      -> catch inode buffers full
          mov       r1,r4                     erase the inode data
          li        r0,19                     19 words = 38 bytes
jlb039    clr       *r4+
          dec       r0
          jne       jlb039

          inc       irefc(r1)                 ref count is 1
          mov       temp1,r0                  get access bits
          andi      r0,003FF                  limit to access bits only
          ori       r0,08000                  set normal file flag
          mov       r0,iflags(r1)             set inode flags
          mov       msgptr,r4
          mov       fmgid(r4),igroup(r1)      set file gid = user gid
          mov       fmuid(r4),iuser(r1)       set file uid = user uid
          
          li        r4,UCLOCK                 set creation time
          limi      0                         prevent accidental rollover
          mov       *r4+,idcre(r1)
          mov       *r4,idcre+2(r1)
          limi      15
          bl        updtim                    set modified time

          bl        wr$ino                    write back inode to disk
          data      lbl087                      -> catch I/O errors
          popr      r11
          b         18(r11)                   NORMAL RETURN

lbl085    popr      r0                        pop file inode#
lbl087    popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

lbl08F    popr      r1
lbl08A    bl        clsino                    close directory
          data      lbl087                      -> catch I/O error
          jmp       lbl087                    -> throw I/O error

lbl092    popr      r0
          jmp       lbl08A                    -> throw I/O error

lbl08B    bl        clsino                    close directory
          data      lbl087                      -> catch I/O errors
          popr      r11
          mov       10(r11),r11               THROW PERMISSION ERROR
          rt

lbl088    popr      r11
          mov       2(r11),r11                THROW TOO MANY FILES OPEN
          rt

lbl090    popr      r1
          bl        clsino
          data      lbl087                    -> throw I/O error

lbl086    popr      r11
          mov       14(r11),r11               THROW DISK INODE TABLE FULL
          rt

lbl093    popr      r0
          bl        clsino
          data      lbl087  
          popr      r11
          mov       12(r11),r11               THROW DEVICE FULL
          rt
.
. Second entry point: mkalias
.
mkalias   seto      temp2                     set flag for 'make alias'
          b         creat1                    do checks, continue with creat4

creat4    bl        getperm                   check directory permissions
          andi      r5,ifwrite                user has write permission?
          jeq       jlb03A                      -> no, throw permission error

          mov       temp1,r0                  ADD THE DIRECTORY ENTRY
          pshr      r0                        get access bits
          li        r3,tmpnam                 set up name/inode of alias
          bl        ad$dir                    add the entry
          data      lbl092                      -> catch I/O errors
          data      lbl093                      -> catch device full
          bl        clsino                    close the directory
          data      lbl085                      -> catch I/O errors
          popr      r0

          bl        opnino                    LINK THE GIVEN FILE
          data      lbl087                      -> catch I/O errors
          data      lbl088                      -> catch inode buffers full
          inc       irefc(r1)                 ref count +1
          seto      idirty(r1)                inode is dirty
          bl        clsino                    close the file
          data      lbl087                      -> catch I/O errors
          popr      r11
          b         18(r11)                   NORMAL RETURN

jlb03A    b         lbl08B                    -> throw permission error

. -----------------------------------------------------------------------------

. Parse path and file name for deletion
.
.  input:  r0 = current directory inode#, r2 = SU blk ptr for path,
.          r6,r7 = len,ptr of path string to scan (past volume, if any)
.
.  output: see 'dopath' above
.
rmpath    pshr      r11                       SEARCH PATH
          li        r3,2                      dopath operation 2 = delete
          pshr      r3
          b         dopath                    parse path & continue at delet1

delet1    mov       r1,lbl096                 save current dir inode buf ptr
          mov       r3,lbl097                 save operation
          mov       r4,lbl098                 save r4 [?? why]
          mov       r0,temp1                  save current dir inode#

          bl        opnino                    OPEN FILE INODE
          data      lbl099                      -> catch I/O error
          data      lbl09A                      -> catch inode table full

          mov       r1,temp2                  CHECK FILE PERMISSIONS
          bl        getperm                   check permission bits
          andi      r5,ifwrite                user has write permission?
          jeq       jlb03B                      -> no, abort delete

          mov       lbl096,r1                 CHECK DIRECTORY PERMISSIONS
          bl        getperm                   check permission bits
          andi      r5,ifwrite                user has write permission?
          jeq       jlb03B                      -> no abort delete

          mov       temp2,r1                 CHECK FILE TYPE
          mov       iflags(r1),r0             get flags
          andi      r0,ifft                   mask out type bits
          ci        r0,ifftd                  is it a directory?
          jeq       jlb03D                      -> yes, check it's empty

          mov       lbl096,r1                 select enclosing dir again
jlb042    mov       lbl097,r3                 restore r3,r4
          mov       lbl098,r4
.                                             ERASE NAME ENTRY IN ENCL. DIR
          clr       dirent                    set inode# to zero
          li        r5,16                     r5 = len = 16 bytes
          li        r6,dirent                 r6 = src = dirent
          clr       umode                     system src
          bl        wrfile                    rewrite dir entry
          data      lbl09C                      -> catch I/O error
          data      lbl09C                      -> ??
          bl        clsino                    close current directory
          data      lbl09C                      -> catch I/O error

          mov       temp2,r1                  RELEASE FILE
          dec       irefc(r1)                 reduce ref count
          jne       jlb03E                    no more references left?
          seto      inolnk(r1)                  -> yes, flag for deletion
jlb03E    seto      idirty(r1)                mark dirty
          bl        clsino                    close inode
          data      lbl099                      -> catch I/O error

          popr      r11
          b         18(r11)                   NORMAL RETURN

jlb03D    clr       r3                        CHECK DELETION DIR IS EMPTY
          li        r4,32                     r3,r4 = offs = 32 (past . and ..)
jlb041    li        r5,16                     r5 = len = 16 bytes
          li        r6,dirent                 r6 = src = dirent
          clr       umode                     system src
          bl        rdfile                    read dirent         
          data      lbl09C                      -> catch I/O error
          ci        r0,16                     succeeded?
          jne       jlb03F                      -> end of dir reached, empty
          mov       dirent,r11                zero dirent inode#?
          jne       jlb040                      -> no, dir not empty
          jmp       jlb041                    -> check next dirent

jlb03F    dec       irefc(r1)                 reduce refcount of self
          mov       lbl096,r1
          dec       irefc(r1)                 reduce refcount of enclosing dir
          bl        updtim                    update its modified time too
          jmp       jlb042                    -> otherwise as normal file

lbl09C    mov       temp2,r1                  select target file (dir)
          bl        clsino                    close it
          data      lbl099                      -> catch I/O errors
lbl099    mov       lbl096,r1                 select encl. directory
          bl        clsino                    close it too
          data      lbl09D                      -> catch I/O errors
lbl09D    popr      r11
          mov       *r11,r11                  TROW I/O ERROR
          rt

lbl09A    mov       lbl096,r1                 select encl. directory
          bl        clsino                    close it
          data      lbl09D                      -> catch I/O errors
          popr      r11
          mov       2(r11),r11                THROW TOO MANY FILES OPEN ERROR
          rt 

jlb03B    mov       temp2,r1                  select target file (dir)
          bl        clsino                    close it
          data      lbl099                      -> catch I/O errors 
          mov       lbl096,r1                 select encl. directory
          bl        clsino                    close it too
          data      lbl09D                      -> catch I/O errors 
          popr      r11
          mov       10(r11),r11               THROW PERMISSION ERROR
          rt     

jlb040    mov       temp2,r1                  select target file (dir)
          bl        clsino                    close it
          data      lbl099                      -> catch I/O errors
          mov       lbl096,r1                 select encl. directory
          bl        clsino                    close it too
          data      lbl09D                      -> catch I/O errors
          popr      r11
          mov       12(r11),r11               THROW DEVICE FULL ERROR
          rt

. -----------------------------------------------------------------------------

. Convert an empty regular file into a directory file
.
.  input:  r1 = inode buf ptr for file, r3 is inode# of parent (for '..')
.
.  output: none
.
.  Seven error returns:
.    1. throw I/O error
.    2. throw inode table full error
.    3. throw volume full error
.    4. throw bad file type error
.    5. throw double name for dir error
.    6. throw file not empty error
.    7. throw permission violation error
.
mk$dir    pshr      r11
          mov       r3,temp1          

          mov       iflags(r1),r0             CHECK FILE CONVERTIBILITY
          andi      r0,ifft                   is it a normal file?
          ci        r0,ifftn
          jne       jlb043                      -> no, bad file type error
          mov       irefc(r1),r0              is ref count = 1?
          dec       r0
          jne       jlb044                      -> no, two names for dir error
          mov       isizeh(r1),r0             is file size zero?
          soc       isizel(r1),r0
          jne       jlb045                      -> no, file non-void error
          bl        getperm
          andi      r5,ifwrite                caller has write permission?
          jeq       jlb046                      -> no, security error

          mov       inonum(r1),r0             ADD "." AS SELF REFERENCE
          li        r3,dotdir
          bl        ad$dir                    add new dir entry
          data      lbl09F                      -> rethrow I/O error
          data      lbl0A0                      -> rethrow disk full error

          mov       temp1,r0                  ADD ".." AS REFERENCE TO PARENT
          li        r3,dotdot
          bl        ad$dir                    add new dir entry
          data      lbl09F                      -> rethrow I/O error
          data      lbl0A0                      -> rethrow disk full error

          mov       r1,temp2                  UPDATE INODE OF PARENT
          mov       temp1,r0                  switch to parent inode#
          bl        opnino                    load inode from inode#
          data      lbl09F                      -> catch I/O error
          data      lbl0A2                      -> catch inode table full error
          inc       irefc(r1)                 increase ref count
          bl        updtim                    update last modified time
          bl        clsino                    flush inode
          data      lbl09F                      -> rethrow I/O error

          mov       temp2,r1                  UPDATE INODE OF SELF
          li        r0,ifftd                  switch back to file, get flags
          soc       r0,iflags(r1)             change from normal to dir type
          inc       irefc(r1)                 increase ref count
          bl        updtim                    update last modified time

          popr      r11                       NORMAL RETURN
          b         14(r11)

lbl09F    popr      r11                       throw I/O error
          mov       *r11,r11
          rt
lbl0A2    popr      r11                       throw inode table full error
          mov       2(r11),r11
          rt        
lbl0A0    popr      r11                       throw disk full error
          mov       4(r11),r11
          rt        
jlb043    popr      r11                       throw bad file type error
          mov       6(r11),r11
          rt        
jlb044    popr      r11                       throw 2 links to dir error
          mov       8(r11),r11
          rt        
jlb045    popr      r11                       throw file non-void error
          mov       10(r11),r11
          rt
jlb046    popr      r11                       throw security error
          mov       12(r11),r11
          rt

. -----------------------------------------------------------------------------

. Read name from path into name buffer
.   Scanning breaks at '/' and EOL. The path len/ptr are left pointing past
.   the name. Names may be long, but only first 14 are copied to the buffer.
.   The buffer is padded with spaces for names shorter than 14 chars.
.
.  input: r6 = path len, r7 = path ptr,
.         r8 = name buffer ptr (buffer must be dinl =  14 chars long)
.
.  output: none
.
.  One error return: no name found
.
getnam    pshr      r11
          li        r0,'  '                   BLANK OUT BUFFER
          li        r11,dinl/2
          mov       r8,r9
jlb048    mov       r0,*r9+
          dec       r11
          jne       jlb048

          mov       r8,r9                     PARSE & COPY NAME
          ai        r8,dinl                   set r8 to end of volume name
jlb049    bl        getchr                    scan next label character
          data      lbl0A3                      -> break on eol
          ci        r0,'/'                    '/' character?
          jeq       lbl0A3                      -> break on '/' too
          c         r8,r9                     already dinl characters copied?
          jeq       jlb049                      -> yes, just read, skip copy
          swpb      r0                        store character in buffer
          movb      r0,*r9+
          jmp       jlb049                    scan next

lbl0A3    inc       r6                        put back last char read
          dec       r7
          popr      r11
          ai        r8,-dinl                  name empty?
          c         r8,r9
          jeq       jlb04A                      -> yes, throw  
          b         2(r11)                    NORMAL RETURN

jlb04A    mov       *r11,r11                  THROW 'NO LABEL FOUND'
          rt
          
. -----------------------------------------------------------------------------

. Read a name character from the path.
.   All characters except space and ctrl characters are valid. Spaces are
.   skipped, ctrl characters are considered to be EOL characters.
.
.  input:  r6 = path len, r7 = path ptr
.
.  output: r0 = next character
.
getchr    pshr      r11                      READ NEXT NAME CHARACTER
jlb04C    bl        SCAN
          jlt       jlb04B                      -> reached eol
          ci        r0,' '                    character is blank or ctrl?
          jeq       jlb04C                      -> blank, read next
          jl        jlb04D                      -> control, treat as eol        
          popr      r11
          mov       r0,r0                     set EQ flag [??]
          b         2(r11)                    NORMAL RETURN

jlb04B    inc       r7                        move past <cr> [??]
jlb04D    popr      r11
          mov       *r11,r11                  'REACHED EOL' RETURN
          rt

. =============================================================================
.         INODE CACHE OPERATIONS ("OPEN/CLOSE/(UN)LOCK INODE")
. =============================================================================

. The FS process caches inodes in memory for easy access. These cached copies
. are extended with some extra admin info and with locking info. As a inode is
. cached when the system or a user accesses a file, it is convenient of to
. think of caching as "opening" the inode. Note that an open inode has no
. concept of a current file pointer: this info is held in each user's FCB.
.
. Cached inodes are shared between all users of the file. When the last user
. "closes" the inode, the inode is written back to disk (if modified) and the
. cache slot is released. Cache slots are kept on a "free" or "in use" list.
. There is fixed number of cache slots, which can be exhausted if too many
. unique files are open at the same time system-wide.

. -----------------------------------------------------------------------------

. Open an inode, i.e. load it into a cache slot and init locking data
.
.   input:  r0 = inode#, r2 = SU block ptr
.   output: r1 = inode buffer ptr
.
.   Two error returns:
.     1. throw I/O error
.     2. throw inode cache full error
.
opnino    mov       ino$hd,r8                 SEARCH CACHED INODES FOR MATCH
jlb051    ci        r8,ino$q                  end of in-mem list?
          jeq       jlb04E                      -> yes, use fresh cache slot
          mov       r8,r1                     set ptr to start of cache slot
          ai        r1,-inodmq
          c         r0,inonum(r1)             slot has same inode#?
          jne       jlb04F                      -> no
          c         r2,isuptr(r1)             slot same SU block?
          jeq       jlb050                      -> yes, already cached
jlb04F    mov       qfl(r8),r8                try next cache slot
          jmp       jlb051

jlb050    inc       imrefc(r1)                increase cache slot ref count
          inc       surefc(r2)                increase SU ref count
          b         4(r11)                    NORMAL RETURN

jlb04E    li        r9,ino$fq                 GET FREE MEMORY INODE
          blwp      REMOVE                    get one from free list
          c         r8,r9                     no more free cache slots?
          jeq       jlb052                      -> yes, too many open files
          li        r9,ino$q                  place on in-use list 
          blwp      PUSH$

          mov       r8,r1                     FILL OUT INODE DATA 
          ai        r1,-inodmq                set ptr to start of cache slot
          li        r9,1                      set cache slot ref count to 1
          mov       r9,imrefc(r1)
          pshr      r11
          bl        rd$ino                    read inode from disk
          data      lbl0A6                      -> catch I/O error
          popr      r11
          inc       surefc(r2)                increase SU ref count
          b         4(r11)                    NORMAL RETURN

jlb052    mov       2(r11),r11                throw too many open files error
          rt

lbl0A6    li        r9,ino$q                  FIX UP I/O ERROR ON INODE READ
          blwp      REMOVE                    remove slot from in-use list
          li        r9,ino$fq                 and put back on free list
          blwp      INSERT
          popr      r11
          mov       *r11,r11                  throw I/O error
          rt

. -----------------------------------------------------------------------------

. Close an inode, i.e. reduce the ref count and if zero release the cache
. slot. If the inode itself now has a zero ref count, release it as well
. (= reset on-disk flag field to zero).
.
.   input:  r1 = inode buffer ptr
.   output: none
.
.   One error return: throw I/O error
.
clsino    mov       inolnk(r1),r0             no more on-disk links left?
          jne       jlb053                      -> yes, write always
          mov       idirty(r1),r0             is cached inode modified?
          jeq       jlb054                      -> no, skip writeback
jlb053    mov       inonum(r1),r0             dummy inode with #0? (dev. file)
          jeq       jlb054                      -> yes, skip writeback

          pshr      r11                       CHECK REF COUNTS, FREE AS NEEDED
          mov       inolnk(r1),r0             still referenced on disk?
          jeq       jlb055                      -> yes
          mov       imrefc(r1),r0
          dec       r0                        releasing last cache reference?
          jne       jlb055                      -> no
          bl        truncf                    truncate file (free its blocks)
          data      lbl0A7                      -> catch I/O error
          clr       iflags(r1)                free on-disk inode
jlb055    bl        wr$ino                    write back cached inode to disk
          data      lbl0A7                      -> catch I/O error
          popr      r11

jlb054    mov       isuptr(r1),r9             FREE CACHE SLOT
          dec       surefc(r9)                reduce SU block ref count             
          dec       imrefc(r1)                reduce cache slot ref count
          jne       jlb056                    still other users? -> done
          mov       inodmq(r1),r9             remove slot from in-use list
          blwp      REMOVE
          li        r9,ino$fq                 add slot to free list
          blwp      INSERT
jlb056    b         2(r11)                    NORMAL RETURN

lbl0A7    popr      r11
          mov       *r11,r11                  set r11 to error exit, but still
          dect      r11                         free the cache slot first
          jmp       jlb054                    -> throw I/O error

. -----------------------------------------------------------------------------

. Update last modified time of cached inode to current system time.
.
.   input:  r1 = inode buffer ptr
.   output: none
.
updtim    seto      idirty(r1)                mark inode as modified
          mov       r1,r3
          li        r1,UCLOCK                 fetch current time
          limi      0                         prevent roll-over issues
          mov       *r1+,r0
          mov       *r1,r1
          limi      15
          mov       r0,idlref+0(r3)           update last modified time
          mov       r1,idlref+2(r3)
          mov       r3,r1                     return
          rt

. -----------------------------------------------------------------------------

. Add lock request to pending lock request list
.
.   input:  r1 = inode buffer ptr
.   output: none
.
dolock    mov       r1,r4                     get head of lock list
          ai        r4,ilck$q                 
jlb058    mov       *r4,r0                    reached last request?
          jne       jlb057                      -> no
          mov       r8,*r4                    append new request to end of list
          clr       *r8
          rt                                  done

jlb057    mov       r0,r4                     move to next request on the list
          jmp       jlb058                      -> try next

. -----------------------------------------------------------------------------

. Remove pending inode lock from list
. [??] The purpose of a lock request type IV is unclear to me.
.
.   input:  r1 = inode buffer ptr
.   output: none
.
dounlk    clr       ilckvl(r1)                release current lock

          mov       r1,r3                     SCAN LIST FOR TYPE 4 REQUESTS
          ai        r3,ilck$q                 get head of list
jlb05B    mov       *r3,r8                    no further requests on the list?
          jeq       jlb059                      -> yes
          mov       00012(r8),r0              request was '4'?
          ci        r0,4
          jne       jlb05A                      -> no
          mov       *r8,*r3                   unlink pending '4' request
          clr       frstat(r8)                reply with status OK
          mov       mbrpl(r8),r9              send reply back
          blwp      INSERT
          mov       r9,r0                     and signal reply available
          ai        r0,4
          blwp      V$
          jmp       jlb05B                    move to next pending request

jlb05A    mov       r8,r3                     move to next pending request
          jmp       jlb05B

jlb059    mov       ilck$q(r1),r8             MOVE TO NEXT LOCK
          jeq       jlb05C                      -> no, done
          mov       fmrqst+4(r8),ilckvl(r1)   lock file to requestor
          mov       *r8,ilck$q(r1)            turn request into reply msg
          clr       frstat(r8)                reply with status OK
          mov       mbrpl(r8),r9              send reply back
          blwp      INSERT
          mov       r9,r0                     and signal reply available
          ai        r0,4
          blwp      V$
jlb05C    rt                                  done

. =============================================================================
.         DIRECTORY OPERATIONS: SEEK, ADD
. =============================================================================

. Search a directory
.
.   input:  r1 = inode buffer ptr for directory, r3 = ptr to name to search for
.           
.   output: dirent contains inode number, r3+r4 contain offset of dirent
.
.   two error returns:
.     1. throw I/O error
.     2. throw file not found
.
sk$dir    pshr      r11
          pshr      r3                        save search name ptr

          clr       r3                        start search at offset 0
          clr       r4

jlb061    li        r5,dinl+2                 READ NEXT DIRENT SLOT
          li        r6,dirent                 read into dirent buffer
          clr       umode                       which is in system space
          bl        rdfile                    read the directory entry
          data      lbl0A8                      -> catch I/O error

          popr      r8                        fetch ptr to search name
          ci        r0,dinl+2                 read past dir eof?
          jl        jlb05D                      -> yes, name not found
          mov       dirent,r0                 deleted dirent slot?
          jeq       jlb05E                      -> yes, go to next slot

          mov       r8,r6                     RIGHT NAME FOUND?
          li        r9,dirnam                 dirnam = name part of dirent
          li        r5,dinl
jlb05F    cb        *r6+,*r9+                 name character matches?
          jne       jlb05E                      -> no, next entry
          dec       r5                        more characters to test?
          jne       jlb05F                      -> yes, check next

          li        r11,dinl+2                FOUND MATCHING ENTRY
          s         r11,r4                    back up offset to start of entry
          joc       jlb060
          dec       r3                        adjust high word as needed
jlb060    popr      r11
          b         4(r11)                    NORMAL RETURN

jlb05E    pshr      r8                        repush ptr to filename
          jmp       jlb061                    ->  process next slot

jlb05D    popr      r11
          mov       2(r11),r11                THROW NOT FOUND ERROR
          rt

lbl0A8    popr      r3                        cleanup of search name ptr
          popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt
          
. -----------------------------------------------------------------------------

. Store new directory entry. Does not check for duplicates.
.
.   input:  r0 = inode number of file, r1 = inode buffer ptr for directory,
.           r3 = ptr to name to add
.           
.   output: none (directory is updated)
.
.   two error returns:
.     1. throw I/O error
.     2. throw file not found
.
ad$dir    pshr      r11
          pshr      r0                        save inode#
          pshr      r3                        save name ptr

          clr       r3                        start search at offset 0
          clr       r4

jlb063    li        r5,dinl+2                 FIND EMPTY DIR SLOT
          li        r6,dirent                 dst = dirent buffer
          clr       umode                       which is in system memory
          bl        rdfile                    read next entry
          data      lbl0AA                      -> catch I/O error
          ci        r0,dinl+2                 reading past directory eof?
          jl        jlb062                      -> yes, place at end
          mov       dirent,r11                dirent slot empty?
          jne       jlb063                      -> no, try next slot

jlb062    s         r0,r4                     back up to start of slot
          joc       jlb064  
          dec       r3
.                                             BUILD DIRENT FOR NEW ENTRY
jlb064    popr      r5                        refetch name ptr
          li        r6,dinl                   copy name to dirent buffer
          li        r11,dirnam
jlb065    movb      *r5+,*r11+                copy character
          dec       r6                        all done?
          jne       jlb065                      -> no, copy next
          popr      r0                        refetch inode#
          mov       r0,dirent                 copy inode to dirent buffer

          li        r5,dinl+2                 WRITE TO DIRECTORY
          li        r6,dirent                 read from dirent buffer
          clr       umode                       which is in system space
          bl        wrfile                    write the entry
          data      lbl0AB                      -> catch I/O error
          data      lbl0AC                      -> catch disk full error
          popr      r11
          b         4(r11)                    NORMAL RETURN

lbl0AA    popr      r3                        cleanup name ptr
          popr      r0                        cleanup inode#
lbl0AB    popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

lbl0AC    popr      r11
          mov       2(r11),r11                THROW VOLUME FULL ERROR
          rt

. =============================================================================
.         STORAGE UNIT OPERATIONS
. =============================================================================

. Prepare a volume (write an empty file system)
.
.   input:  r0 = 'test blocks' flag, r2 = SU block ptr
.
.   output: none (volume is rewritten)
.
.   one error return: throw I/O error
.
doprep    mov       r11,*r10+                 pshr r11
          mov       r0,temp2                  save bad block test flag

          mov       sublkl(r2),r0             if current block length not set,
          jne       jlb066                       use default length
          mov       sudblkl(r2),sublkl(r2)
.
. PREPARE THE BOOT BLOCK (BLOCK# 0)
.
jlb066    clr       r0                        select block# 0
          bl        getbuf                    get zeroed buffer for it
          data      erprep                      -> catch I/O error
          li        r0,'MS'                   set magic value 'MS'
          mov       r0,dkmgic(r3)
          li        r0,1                      set format version number
          mov       r0,dkfmt(r3)

          blwp      get$dc                    CHECK FOR VARIABLE GEOMETRY
          a         r0,r0                     driver responds with zero?
          jeq       jlb067                      -> yes, use SU defaults
          mov       r0,r11                    use a variable geometry setting
          dect      r11                       
          mov       fvdpt(r11),r11            select line suggested by driver
          mov       *r11, sunblk(r2)            and fetch the geometry from
          mov       *r11+,sudnblk(r2)           the table in the config file
          mov       *r11+,suatln(r2)
          mov       *r11+,suitad(r2)  
          mov       *r11+,suitln(r2)  

jlb067    mov       sublkl(r2),dkblkl(r3)     COPY THE DISK LAYOUT
          mov       suatad(r2),dkatad(r3)       to the boot block buffer
          mov       suatln(r2),dkatln(r3)
          mov       suitad(r2),dkitad(r3)
          mov       suitln(r2),dkitln(r3)

          li        r0,dinl/2                 COPY VOLUME NAME
          mov       r2,r4                     copy SU block ptr
          mov       r3,r5                     copy block buffer ptr
          ai        r4,suvolid                offset of vol. ID in SU block
          ai        r5,dkvolid                offset of vol. ID in boot block
jlb068    mov       *r4+,*r5+                 copy volume name
          dec       r0
          jne       jlb068

          mov       sunblk(r2),dknblk(r3)     SET VOLUME SIZE
          jne       jlb069                    if given size=0 use default size
          mov       sudnblk(r2),dknblk(r3)
          mov       sudnblk(r2),sunblk(r2)
  
jlb069    bl        putblk                    MARK DIRTY + RELEASE BLOCK BUFFER
          data      erprep                      -> catch error
.
. PREPARE THE ON-DISK INODE TABLE
.
          mov       suitad(r2),r4             ZERO OUT ALL INODE BLOCKS
          mov       suitln(r2),r5
jlb06A    mov       r4,r0                     select next block
          bl        getbuf                    get zeroed buffer for it
          data      erprep                      -> catch I/O error
          bl        putblk                    mark dirty and release block
          data      erprep                      -> catch error
          inc       r4
          dec       r5
          jne       jlb06A                    -> prepare next block
.
. PREPARE THE ALLOCATION TABLE
.
          mov       suatad(r2),r4             ZERO OUT ALL ALLOCATION BLOCKS
          mov       suatln(r2),r5
jlb06B    mov       r4,r0                     select next block
          bl        getbuf                    get a zeroed buffer for it
          data      erprep                      -> catch I/O error
          bl        putblk                    mark dirty + release block
          data      erprep                      -> catch error
          inc       r4
          dec       r5
          jne       jlb06B                    -> prepare next block

          mov       sunblk(r2),r1             MARK ALL DISK BLOCKS FREE
          li        r0,1                      start = block# 1
          dec       r1                        end = last block#
          li        r3,1                      set 'mark free'
          bl        blkmrk                    mark the blocks
          data      erprep                      -> catch I/O error

          mov       suatad(r2),r0             MARK ALLOC. TABLE BLOCKS IN USE
          mov       suatln(r2),r1
          clr       r3                        set 'mark in use'
          bl        blkmrk                    mark the blocks
          data      erprep                      -> catch I/O error

          mov       suitad(r2),r0             MARK INODE TABLE BLOCKS IN USE
          mov       suitln(r2),r1
          clr       r3                        set 'mark in use'
          bl        blkmrk                    mark the blocks
          data      erprep                      -> catch I/O error
.
. TEST THE DATA BLOCKS, MARK BAD ONES AS IN USE (OPTIONAL)
.
          mov       temp2,r0                  SKIP DATA TEST?
          jeq       jlb06C                      -> yes

          mov       r2,lbl096                 save SU block ptr
          bl        dosync                    sync all work so far
          data      erprep                      -> catch I/O error
          mov       lbl096,r2

          mov       suitad(r2),r4             TEST ALL DATA BLOCKS
          a         suitln(r2),r4             blocks start after inode table
jlb06D    c         r4,sunblk(r2)             end of disk reached?
          jhe       jlb06C                      -> yes, done
          mov       r4,temp1
          mov       r4,r0                     select next data block
          bl        getbuf                    get a zeroed buffer
          data      erprep                      -> catch I/O error
          bl        tstblk                    write the block *now*
          data      lbl0B3                      -> error, mark as bad
jlb071    mov       temp1,r4
          inc       r4
          jmp       jlb06D                    -> test the next block

lbl0B3    clr       r3                        MARK THE BAD BLOCK AS USED
          mov       temp1,r0                  start at current block
          li        r1,1                      one block only
          bl        blkmrk                    mark the block
          data      erprep                      -> catch I/O errors
          bl        dosync                    sync allocation table
          data      erprep                      -> catch I/O errors

          mov       lbl096,r2                 REPORT THE BAD BLOCK
          clr       r0                        find the SU# from the SU blk ptr
          li        r3,SUIT                   scan the SU table
          li        r1,SUITL
jlb06F    inc       r0
          c         *r3+,r2                   found it?
          jeq       jlb06E                      -> yes
          dec       r1
          jne       jlb06F                    -> test next SU block

jlb06E    li        r1,2                      print SU# into error string
          li        r2,lbl0B4+1
          bl        bufprt
          mov       temp1,r0                  print block# into error string
          li        r1,5
          li        r2,lbl0B6
          bl        bufprt

          li        r1,83                     BUILD MSG FOR TERMINAL DRIVER
          blwp      BGETA$                    allocate msg + error string
          data      MEMFUL
          mov       r1,r8
          ai        r1,mbtext                 copy error string to msg
          li        r2,lbl0B7                 start of error text
          li        r0,73                     length of error text
          mov       r0,mblen(r8)
jlb070    movb      *r2+,*r1+                 do the copy
          dec       r0                        done?
          jne       jlb070                      -> no
          li        r0,mttext                 set msg type to 'text'
          mov       r0,mbtype(r8)
          
          mov       TRIT,r0                   SEND ERROR TO SYSTEM TERMINAL
          bl        TRMQMS                    queue message on output queue

          mov       lbl096,r2                 restore SU block ptr
          jmp       jlb071                    -> and resume test loop
.
. BUILD INODE #1 (ROOT DIRECTORY FOR VOLUME)
.
jlb06C    li        r1,inobuf                 ZERO OUT INODE BUFFER
          li        r0,19                     19 words = 38 bytes = inode len
jlb072    clr       *r1+                      clear next word
          dec       r0                        done?
          jne       jlb072                      -> no

          li        r0,1                      BUILD INODE
          mov       r0,inobuf+inonum          inode #1
          mov       r2,inobuf+isuptr          on this SU
          mov       r0,inobuf+irefc           initial ref count is one
          li        r0,0916F                  flags: ifall + ifftd + rs-rs-rws
          mov       r0,inobuf+iflags          set flags

          li        r1,inobuf                 BUILD ROOT DIR
          mov       inonum(r1),r0             one entry, '.' for self
          li        r3,dotdir
          bl        ad$dir                    add to directory file
          data      erprep                      -> catch I/O error
          data      erprep                      -> catch disk full error :^)

          li        r1,inobuf                 directory is inode# 1
          bl        wr$ino                    write inode buffer to disk
          data      erprep                      -> catch I/O error
          popr      r11
          b         2(r11)                    NORMAL RETURN (I.E. PREP DONE)
.
. SUPPORTING ROUTINES AND DATA
.
tstblk    pshr      r1                        WRITE BACK BLOCK *NOW*
          pshr      r2
          ai        r3,-dbbuf                 access block buffer header
          mov       dbsu(r3),r2               r1 = SU block ptr
          mov       dbbno(r3),r1              r2 = block number
          li        r0,w$                     r0 = do write
          ai        r3,dbbuf                  r3 = buffer addr
          blwp      devmsg                    send message to disk driver
          data      lbl0BD                      -> catch I/O error

jlb073    ai        r3,-dbbuf                 access block buffer header                
          clr       dbdrty(r3)                clear dirty flag
          clr       dbsu(r3)                  release buffer
          popr      r2
          popr      r1
          b         2(r11)                    NORMAL + ERROR RETURN

lbl0BD    mov       *r11,r11                  adjust r11 for error return
          dect      r11
          jmp       jlb073                    -> release buffer & report error

erprep    popr      r11                       THROW PREP I/O ERROR
          mov       *r11,r11
          rt

dotdir    text      '.             '
dotdot    text      '..            '
          
lbl0B7    byte      7                         <BEL>
          text      '** Storage unit'
lbl0B4    text      ' ??:  Block '
lbl0B6    text      '????? downed during PREP due to I/O error **'
          byte      0d, 00

. -----------------------------------------------------------------------------

. Mount a volume on a storage unit.
.
.   input:  r6 = path string len, r7 = path string ptr, r3 = access bits
.           
.   output: none (volume is mounted)
.
.   five error returns:
.     1. throw I/O error
.     2. throw bad volume name
.     3. throw device busy
.     4. throw volume name error
.     5. throw permission violation error
.
domount   pshr      r11
          mov       r3,temp1                  save access bits

          bl        getsu                     parse SU# / volume name
          data      lbl0BE                      -> catch no name/number found
          data      lbl0BE                      -> catch name/number not valid
          li        r8,tmpnam
          bl        getnam                    check mount name (after colon)                 
          data      lbl0BF                      -> name empty, clear name flag
          clr       dirent                    set 'has name' flag

jlb07E    mov       sustat(r2),r0             CHECK SU STATUS
          ci        r0,0                      nothing mounted?
          jne       jlb074                      -> no, throw 'unit busy'
          c         tmpnam,star               is mount name given as '*'? 
          jeq       jlb075                      -> yes, mount as 'raw'
.
. DO REGULAR MOUNT
.
          clr       r0                        CHECK VOLUME CONTENT
          bl        getblk                    get disk block #0
          data      lbl0C2                      -> catch I/O error
          c         dkmgic(r3),nosmgc         NOS magic okay?
          jne       jlb076                      -> no, bad volume
          c         dkfmt(r3),nosfmt          NOS disk format version okay?
          jne       jlb076                      -> no, bad volume

          mov       dirent,r11                disk volume name given?
          jne       jlb077                      -> no, skip test
          mov       r3,r6                     disk volume name matches?
          ai        r6,dkvolid
          li        r7,tmpnam
          li        r0,dinl/2                 compare by word
jlb078    c         *r6+,*r7+                 names still match?
          jne       jlb076                      -> no, bad volume
          dec       r0                        done?
          jne       jlb078                      -> no, compare next

jlb077    mov       r3,r6                     FETCH DISK PARAMETERS
          ai        r6,dkvolid                copy volume name to SU block
          mov       r2,r7
          ai        r7,suvolid
          li        r0,7
jlb079    mov       *r6+,*r7+
          dec       r0
          jne       jlb079
          mov       dkblkl(r3),sublkl(r2)     copy file system sizes
          mov       dkatad(r3),suatad(r2)       to SU block
          mov       dkatln(r3),suatln(r2)
          mov       dkitad(r3),suitad(r2)
          mov       dkitln(r3),suitln(r2)
          mov       dknblk(r3),sunblk(r2)

          li        r0,1                      FINALISE SU BLOCK INIT
jlb07D    mov       r0,sustat(r2)             status = 1 = 'mounted'
          inc       surefc(r2)                up SU ref count (always to 1?)
          mov       temp1,suaccb(r2)          set access bits
          popr      r11
          b         10(r11)                   NORMAL RETURN
.
. DO 'RAW' MOUNT
.
jlb075    clr       r0                        MOUNT SU:*
          bl        getblk                    get disk block #0
          data      lbl0C5                      -> catch I/O error
          c         dkmgic(r3),nosmgc         NOS magic found?
          jne       jlb07A                      -> no, okay
          c         dkfmt(r3),nosfmt          NOS format matches?
          jne       jlb07A                      -> no, okay
lbl0C5    mov       msgptr,r11
          mov       fmgid(r11),r11            user gid is zero (= super user)?
          jne       jlb07B                      -> no, throw permission error

jlb07A    mov       sudblkl(r2),sublkl(r2)    SET VOLUME BLOCK LENGTH & SIZE
          blwp      get$dc                    get drive characteristics
          mov       r0,r11                    fixed size?
          jeq       jlb07C                      -> yes
          a         r11,r11                   read from variable geometry table
          dect      r11
          mov       fvdpt(r11),r11
          mov       *r11,sudnblk(r2)
jlb07C    mov       sudnblk(r2),sunblk(r2)    set volume size in blocks
          li        r0,2                      status = 2 = 'mounted raw'
          jmp       jlb07D                    -> finalise mount

lbl0BE    popr      r11       
          mov       2(r11),r11                THROW NAME FORMAT ERROR
          rt

lbl0BF    seto      dirent                    set 'volume name not given' flag
          jmp       jlb07E                      -> continue

jlb074    popr      r11
          mov       4(r11),r11                THROW UNIT BUSY ERROR
          rt

lbl0C2    popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

jlb076    bl        syndsk                    invalidate all buffers
          data      lbl0C2                      -> catch I/O error
          data      jlb074                      -> catch unit busy error
          popr      r11
          mov       6(r11),r11                THROW BAD VOLUME ERROR
          rt

jlb07B    bl        syndsk                    invalidate all buffers   
          data      lbl0C2                      -> catch I/O error
          data      jlb074                      -> catch unit busy error
          popr      r11
          mov       8(r11),r11                THROW PERMISSION ERROR
          rt

star      data      '* '                      mount random name
nosmgc    data      'MS'                      NOS magic value 4D53
nosfmt    data      1                         NOS disk format 1

. -----------------------------------------------------------------------------

. Dismount a volume from a storage unit.
.
.   input:  r2 = SU block ptr
.           
.   output: none (volume is dismounted)
.
.   three error returns:
.     1. throw I/O error
.     2. throw device still busy error
.     3. <not used> [??]
.
dismnt    pshr      r11
          mov       surefc(r2),r0             SU not mounted?
          jeq       jlb07F                      -> yes, no-op
          dec       r0                        ref count is 1 (i.e. not in use)?         
          jne       jlb080                      -> no, in-use error
          bl        syndsk                    sync & invalidate all buffers
          data      lbl0C7                      -> catch I/O error
          data      jlb080                      -> catch in-use error
          dec       surefc(r2)                ref count to zero
jlb07F    clr       sustat(r2)                mark as dismounted
          popr      r11
          b         6(r11)                    NORMAL RETURN

jlb080    popr      r11       
          mov       2(r11),r11                THROW 'BUSY' ERROR
          rt

lbl0C7    popr      r11     
          mov       *r11,r11                  THROW I/O ERROR
          rt

. -----------------------------------------------------------------------------

. Make disk volume (un)bootable
.
.   input:  r1 = inode buf ptr of boot file, r2 = SU block ptr
.           if r1 is zero, erase the boot information
.           
.   output: none (volume made bootable)
.
.   two error returns:
.     1. throw I/O error
.     2. throw boot file not suitable error
.
doboot    pshr      r11

          pshr      r1
          clr       r0                        select boot block (= #0)
          bl        getblk                    fetch block
          data      lbl0C8                      -> catch I/O error
          popr      r1

          clr       r4                        set boot inode# to zero
          mov       r1,r0                     boot file specified?
          jeq       jlb081                      -> no, erase boot info

          mov       iflags(r1),r0             CHECK BOOT FILE GIVEN FOR SANITY
          coc       iscont,r0                 contiguous file?
          jne       jlb082                      -> no, reject
          andi      r0,ifft                   check directory/file bits
          ci        r0,ifftn                  is it a normal file?
          jne       jlb082                      -> no, reject
          mov       iflags(r1),r0             check 'x' mode bits
          andi      r0,049                    executable in some way?
          jeq       jlb082                      -> no, reject
          mov       ipgmap+2(r1),r0           length non-zero?
          jeq       jlb082                      -> no, reject
          mov       ipgmap(r1),r0             get number of first block
          mov       inonum(r1),r4             get inode number

.                                             (UN)SET BOOTFILE ENTRIES
jlb081    mov       r0,dkboot(r3)             set bootfile 1st block# (or zero)
          mov       r4,dkbino(r3)             set bootfile inode# (or zero)
          mov       r3,r4                     write MDEX directory entry at
          ai        r4,dkmdex                    offset 36 (3rd slot)
          seto      *r4                       provisionally mark entry as empty
          mov       r0,r0                     bootfile specified?
          jeq       jlb083                      -> no, leave MDEX dirent empty

          li        r5,lbl0CA                 set MDEX bootfile as 'BOOT$.SAV'
          li        r6,6                      MDEX name has 12 chars
jlb084    mov       *r5+,*r4+                 copy chars
          dec       r6                        done?
          jne       jlb084                      -> no
.
. The below doubling of the block# is a hack that only appears to work
. when the volume has 256 byte sectors (MDEX assumes 128 bytes). For 512
. byte sectors a quadrupling would be needed. [??]
.
          a         r0,r0                     double up block#
          mov       r0,*r4+                   set MDEX dirent bootfile location
          jmp       jlb083                    -> do write back

lbl0CA    text      'BOOT$.SAV   '

jlb083    pshr      r1    
          bl        putblk                    mark dirty + release block buffer
          data      lbl0C8                      -> catch I/O errors
          popr      r1
          popr      r11
          b         4(r11)                    NORMAL RETURN

lbl0C8    popr      r1                        cleanup saved inode ptr
          popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

jlb082    popr      r11
          mov       2(r11),r11                THROW BAD FILE TYPE ERROR
          rt
.
. =============================================================================
.         BASIC FILE READ AND FILE WRITE
. =============================================================================

. Read bytes from file to (user) buffer
.
.   input:  r1 = inode buf ptr, r2 = SU block ptr, r3,r4 = start offset,
.           r5 = read length, *r6 = caller's buffer
.
.   output: r0 = bytes read
.
.   one error return: throw I/O error (r0 = no. of bytes read before error)
.
rdfile    pshr      r11

          mov       r3,r7                     CHECK THAT READ IS WITHIN RANGE
          mov       r4,r8                     set r7,r8 to offset end-point
          a         r5,r8
          jnc       jlb085  
          inc       r7

jlb085    c         r7,isizeh(r1)             end-point < file size?
          jl        jlb086                      -> yes, full read
          jh        jlb087                      -> no, test partial read
          c         r8,isizel(r1)             equal, low byte end-point < size?
          jle       jlb086                      -> yes, full read

jlb087    c         r3,isizeh(r1)             start point < file size?
          jh        jlb088                      -> no, past eof
          jl        jlb089                      -> yes, do short read
          c         r4,isizel(r1)             equal, low byte start < size?
          jhe       jlb088                      -> no, past eof

jlb089    mov       isizel(r1),r5             partial read, truncate read len
          s         r4,r5                     (cannot overflow)

jlb086    mov       r5,r8                     r8 = remaining length
          mov       r6,r9                     r9 = current user buf ptr
          pshr      r5                        save original len for error exit

jlb091    pshr      r3                        FIND AND FETCH (NEXT) DATA BLOCK
          pshr      r4                        save offset
          bl        fdatbk                    find block # and offset in blk
          data      lbl0CC                      -> catch block not allocated
          data      lbl0CC                      -> catch I/O error

          mov       umode,r11                 CHECK FULL BLOCK READ
          jeq       jlb08A                      -> skip if called from kernel
          mov       r4,r4                     read starts at start of block?
          jne       jlb08A                      -> no, normal fetch
          c         r8,sublkl(r2)             size at least one full block?
          jhe       jlb08B                      -> try driver-direct read

jlb08A    bl        getblk                    fetch the block into a buffer
          data      lbl0CC                      -> catch I/O errors

jlb097    mov       sublkl(r2),r0             CALCULATE COPY CHUNK LENGTH
          s         r4,r0                     chunk length = min of remaining
          c         r0,r8                       block length and remaining
          jle       jlb08C                      read length
          mov       r8,r0

jlb08C    popr      r6                        ADJUST OFFSET AND LENGTH
          popr      r5                        pop offset
          a         r0,r6                     add chunk length
          jnc       jlb08D                    handle carry
          inc       r5
jlb08D    pshr      r5                        push adjusted offset back
          pshr      r6
          s         r0,r8                     remaining len -= chunk len

          mov       umode,r6                  kernel internal read?
          jeq       jlb08E                      -> yes, do simple copy

          pshr      r1                        COPY CHUNK TO USER SPACE
          mov       r9,r2                     r2 = dst = caller's buffer
          a         r0,r9                     destination += length
          mov       r3,r1                     r1 = src = ptr into block buffer
          a         r4,r1                     r0 = len
          mov       usrbnk,r3                 r3 = user memory bank
          bl        MTU                       move data to user space
          popr      r1                        restore inode ptr
          jmp       jlb08F                    -> do next chunk

jlb08E    a         r3,r4                     SIMPLE KERNEL SPACE COPY
jlb090    dec       r0                        all bytes moved?
          jlt       jlb08F                      -> yes
          movb      *r4+,*r9+                 copy a byte
          jmp       jlb090                    -> do next

jlb08F    popr      r4                        PREPARE FOR NEXT BLOCK, IF ANY                   
          popr      r3
          mov       r8,r8                     remaining length is zero?
          jne       jlb091                      -> no, continue with next chunk

          popr      r0                        set r0 to number of bytes read
jlb092    popr      r11
          b         2(r11)                    NORMAL RETURN

jlb088    clr       r0                        reading past end, return with
          jmp       jlb092                       zero bytes read

. If a full block can be read, and the block is not in memory yet,
. ask the driver to copy the block directly to user space and avoid
. and extra copy operation (and possibly buffer trashing).
.
jlb08B    mov       lru$hd,r3                 CHECK IF ALREADY BUFFERED
jlb096    ci        r3,lru$q                  last buffer checked?
          jeq       jlb093                      -> yes, do direct load
          c         r0,dbbno(r3)              right block number?
          jne       jlb094                      -> no, go to next buffer
          c         r2,dbsu(r3)               right SU?
          jeq       jlb095                      -> yes, block already in memory
jlb094    mov       qfl(r3),r3                check next buffer
          jmp       jlb096

jlb095    ai        r3,dbbuf                  if already in memory, use normal
          jmp       jlb097                      copy and don't refetch

jlb093    pshr      r1                        DO DRIVER DIRECT LOAD
          mov       r0,r1                     r1 = block number
          li        r0,ld$                    r0 = op = direct to user load
          mov       r9,r3                     r3 = user buffer address
          blwp      devmsg                    send command msg to driver
          data      lbl0CE                      -> catch I/O errors
          popr      r1                        restore inode ptr

          a         sublkl(r2),r9             PREPARE FOR NEXT BLOCK
          popr      r6                        move buffer pointer (r9)
          popr      r5                        pop offset
          a         sublkl(r2),r6             move offset
          jnc       jlb098  
          inc       r5
jlb098    pshr      r5                        push offset back
          pshr      r6
          s         sublkl(r2),r8             reduce remainling length
          jmp       jlb08F                    -> check for next block

lbl0CE    popr      r1                        clean up inode ptr
lbl0CC    popr      r4                        clean up offset
          popr      r3
          popr      r0                        fetch original read len
          s         r8,r0                     r0 = bytes actually read
          popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

. -----------------------------------------------------------------------------

. Write bytes from (user) buffer to file
.
.   input:  r1 = inode buf ptr, r2 = SU block ptr, r3,r4 = start offset,
.           r5 = write length, *r6 = caller's buffer
.
.   output: r0 = bytes read
.
.   two error returns:
.     1. throw I/O error (r0 = no. of bytes read before error)
.     2. throw disk full error (r0 = no. of bytes read before error)
.
wrfile    pshr      r11

          mov       r3,r7                     CHECK SIZE
          mov       r4,r8                     set r7,r8 to offset end-point
          a         r5,r8
          jnc       jlb099  
          inc       r7

jlb099    c         r7,isizeh(r1)             end-point < current length?
          jl        jlb09A                      -> yes, do the write
          jh        jlb09B                      -> no, grow file first
          c         r8,isizel(r1)             equal, low byte end-point < len?
          jle       jlb09A                      -> yes, do the write

jlb09B    pshr      r6                        GROW FILE TO NEW SIZE
          pshr      r5                        save parameters
          pshr      r4
          pshr      r3
          mov       r8,r4                     r3,r4 = new size
          mov       r7,r3
          bl        growit                    grow the file to new size
          data      lbl0D0                      -> catch I/O error
          data      lbl0D1                      -> catch device full error
          popr      r3                        restore parameters
          popr      r4
          popr      r5
          popr      r6

jlb09A    mov       r5,r8                     r8 = remaining length
          mov       r6,r9                     r9 = current (user) buffer ptr
          pshr      r5                        save original len for error exit

jlb0A7    pshr      r3                        push offset
          pshr      r4
          bl        fdatbk                    find block # and offset in block
          data      lbl0D2                      -> catch block not allocated
          data      lbl0D2                      -> catch I/O error
          mov       r4,r4                     write starts at block start?
          jne       jlb09C                      -> no, read block
          c         r8,sublkl(r2)             remaing len at least one block?
          jl        jlb09C                      -> no, read block

          mov       lru$hd,r3                 READY A DISK BUFFER W/O READING
jlb0A0    ci        r3,lru$q                  end of list reached?
          jeq       jlb09D                      -> yes, flush a block
          c         r0,dbbno(r3)              block# matches?
          jne       jlb09E                      -> no, try next
          c         r2,dbsu(r3)               SU block matches?
          jeq       jlb09F                      -> yes, found buffer
jlb09E    mov       qfl(r3),r3                move to next buffer
          jmp       jlb0A0                    -> try again

jlb09D    bl        bflush                    flush LRU buffer
          data      lbl0D2                      -> catch I/O errors
          mov       r0,dbbno(r3)              re-use for this block
          mov       r2,dbsu(r3)
jlb09F    ai        r3,dbbuf                  r3 = buffer pointer
          clr       r4                        set block offset back to zero
          jmp       jlb0A1

jlb09C    bl        getblk                    READ BLOCK FROM DISK
          data      lbl0D2                      -> catch I/O errors

jlb0A1    mov       sublkl(r2),r0             CALCULATE COPY CHUNK LENGTH
          s         r4,r0                     chunk length = min of remaining
          c         r0,r8                       block length and remaining
          jle       jlb0A2                      read length
          mov       r8,r0
            
jlb0A2    popr      r6                        ADJUST OFFSET AND LENGTH
          popr      r5                        pop offset
          a         r0,r6                     add chunck length
          jnc       jlb0A3                    handle carry
          inc       r5
jlb0A3    pshr      r5                        push offset back
          pshr      r6
          s         r0,r8                     adjust remaining lenght
          
          mov       umode,r6                  kernel internal write?
          jeq       jlb0A4                      -> yes, do simple copy

          pshr      r1                        COPY CHUNK FROM USER SPACE
          mov       r9,r1                     r1 = src = caller's buffer
          a         r0,r9                     destination += length
          mov       r4,r2                     r2 = dst = ptr into block buffer
          a         r3,r2                     r0 = len
          pshr      r3
          mov       usrbnk,r3                 r3 = user's memory bank
          bl        MFU                       move data from user space
          popr      r3                        restore buffer ptr
          popr      r1                        restore inode ptr
          jmp       jlb0A5                    -> do next chunk

jlb0A4    a         r3,r4                     SIMPLE KERNEL SPACE COPY
jlb0A6    dec       r0                        all bytes moved?
          jlt       jlb0A5                      -> yes
          movb      *r9+,*r4+                 copy byte
          jmp       jlb0A6                    -> do next
          
jlb0A5    bl        putblk                    MARK BLOCK DIRTY + RELEASE BUFFER
          data      lbl0D2                      -> catch I/O error
          bl        updtim                    update last modified time
          popr      r4                        pop offset
          popr      r3

          mov       r8,r8                     more bytes to write?
          jne       jlb0A7                      -> process next chunk

          popr      r0                        r0 = number of bytes written
          popr      r11
          b         4(r11)                    NORMAL RETURN

lbl0D2    popr      r4                        clean up offset
          popr      r3
          popr      r0                        set r0 to bytes actually written
          s         r8,r0
jlb0A8    popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

lbl0D0    popr      r3                        clean up parameters
          popr      r4
          popr      r5
          popr      r6
          clr       r0                        set r0 to zero bytes written
          jmp       jlb0A8                    -> throw I/O error

lbl0D1    popr      r3
          popr      r4
          popr      r5
          popr      r6
          clr       r0                        set r0 to zero bytes written
          popr      r11
          mov       2(r11),r11                THROW DEVICE FULL ERROR
          rt
          
. -----------------------------------------------------------------------------

. Calculate permission bits for requesting user. Select any, group or self
. bits based on uid and gid. Never give more permission than the mount mask
. (e.g. no write access on a read-only volume). Group zero users get RWX
. permission, but still limited to the mount mask.
.
.   input:  r1 = inode buffer ptr
.
.   output: r5 = rwx permission in low 3 bits
.
getperm   mov       iflags(r1),r5             get file's permission bits
          mov       msgptr,r3                 get user's group id
          mov       fmgid(r3),r4              is group id zero?
          jne       jlb0A9                      -> no
          li        r5,7                      group zero has all permissions
          jmp       jlb0AA

jlb0A9    c         r4,igroup(r1)             user gid matches file gid?
          jne       jlb0AB                      -> no, use world bits
          c         fmuid(r3),iuser(r1)       user uid matches file uid?
          jeq       jlb0AA                      -> yes, use 'self' bits
          srl       r5,3                      use 'group' access bits
          jmp       jlb0AA
          
jlb0AB    srl       r5,6                      use 'any' access bits

jlb0AA    mov       isuptr(r1),r4             get SU ptr
          andi      r5,7                      select access file bits
          mov       suaccb(r4),r4             at most SU-wide permissions      
          inv       r4
          szc       r4,r5
          rt                                  return permissions in r5
          
. -----------------------------------------------------------------------------
          
. Check that the device has a NOS volume mounted.
.
.  input:  r2 = SU block ptr
.
.  output: none
.
.  One error return: device not mounted with NOS volume
.
chkmtd    mov       sustat(r2),r1             get mount status
          ci        r1,1                      status is mounted normal?
          jne       jlb0AC                      -> no
          b         2(r11)                    normal return
jlb0AC    mov       *r11,r11                  take error vector
          rt
          
. -----------------------------------------------------------------------------
          
. Grow file to new size (assumes current size is less!)
.
.   input: r1 = inode buffer ptr, r3+r4 = desired size
.
.   output: none (file has requested blocks allocated)
.
.   two error returns:
.     1. throw I/O error
.     2. throw device full error
.
growit    pshr      r11
          mov       isuptr(r1),r2             get SU block ptr
          mov       iflags(r1),r0             get file flags
          coc       iscont,r0                 is file contiguous? 
          jne       jlb0AD                      -> no
.
. Case 1: file is contiguous, can only grow within allocated blocks
.
          pshr      r3                        HANDLE CONTIGUOUS FILE
          pshr      r4                        cannot grow, just check size
          mov       sublkl(r2),r0             round up new size to  full block
          dec       r0
          a         r0,r4
          jnc       jlb0AE  
          inc       r3
jlb0AE    div       sublkl(r2),r3
          c         r3,ipgmap+2(r1)           fits still within allocated size?
          jle       jlb0AF                      -> yes, update inode
          b         lbl0D4                    -> error return

jlb0AD    mov       sublkl(r2),r5             CHECK FOR SMALL MODEL SIZE
          mpy       eight,r5
          c         r3,r5                     new size fits in 8 blocks?
          jh        jlb0B0                      -> no
          jl        jlb0B1                      -> yes (must be small now too)
          c         r4,r6                       id.
          jh        jlb0B0                      id.
.
. Case 2: file is small (implies it is small now as well)
.
jlb0B1    pshr      r3                        HANDLE SMALL FILE
          pshr      r4                          i.e grow within small model
          mov       sublkl(r2),r0             round up new size to full block
          dec       r0
          a         r0,r4
          jnc       jlb0B2  
          inc       r3
jlb0B2    div       sublkl(r2),r3             calculate new size in blocks

          mov       r1,r4                     GROW SMALL MODEL FILE
          ai        r4,ipgmap
jlb0B3    dec       r3                        all 8 map entries done?
          jlt       jlb0AF                      -> yes
          mov       *r4+,r0                   map entry already filled?
          jne       jlb0B3                      -> yes
          pshr      r1
          pshr      r3
          pshr      r4
          li        r1,1
          bl        newblk                    allocate 1 new data block
          data      lbl0D7                      -> catch disk I/O error
          data      lbl0D8                      -> catch device full error
          popr      r4
          popr      r3
          popr      r1
          mov       r0,-2(r4)                 place new block # in page map
          jmp       jlb0B3

jlb0AF    popr      r4                        pop back requested size
          popr      r3

lbl0DD    mov       r3,isizeh(r1)             UPDATE INODE AND NORMAL RETURN
          mov       r4,isizel(r1)             update inode size to requested size
          pshr      r3
          pshr      r4
          bl        updtim                    update last modified time
          bl        wr$ino                    write back inode to disk
          data      lbl0D9                      -> catch I/O error
          popr      r4                        clean up stack
          popr      r3
          popr      r11
          b         4(r11)                    NORMAL RETURN

lbl0D7    popr      r4                        clean up stack
          popr      r3
          popr      r1
          popr      r4
          popr      r3
jlb0B4    popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt                

lbl0D9    popr      r4                        clean up stack
          popr      r3
          jmp       jlb0B4                    -> throw I/O error

lbl0DB    popr      r4                        clean up stack
          popr      r3
          popr      r1
          jmp       jlb0B4                    -> throw I/O error

lbl0D8    popr      r4                        HANDLE DEVICE FULL
          popr      r3                        clean up stack
          popr      r1
          bl        updtim                    leave partial allocation in place
          bl        wr$ino                      and save inode
          data      lbl0D9                      -> catch I/O error
          popr      r4                        clean up stack
          popr      r3
jlb0B5    popr      r11       
          mov       2(r11),r11                THROW DEVICE FULL ERROR
          rt

lbl0DC    popr      r4                        clean up stack
          popr      r3
          popr      r1
          bl        updtim                    leave partial allocation in place
          bl        wr$ino                      and save inode
          data      jlb0B4                      -> catch I/O error
          jmp       jlb0B5                    -> throw device full error
.
. Case 3: convert small file to large file
.
jlb0B0    mov       iflags(r1),r0             HANDLE (SHIFT TO) LARGE MODEL
          coc       islrge,r0                 is file already 'large' ?
          jeq       jlb0B6                      -> yes, no need to convert

          pshr      r1                        CONVERT SMALL MODEL TO LARGE MODEL
          pshr      r3
          pshr      r4
          li        r1,1                      find one free block
          bl        newblk  
          data      lbl0DB                      -> catch I/O  error
          data      lbl0DC                      -> catch device full error
          bl        getbuf                    get a zeroed buffer for it
          data      lbl0DB                      -> catch I/O error
          mov       r3,r5
          popr      r4
          popr      r3
          popr      r1
          mov       r1,r6                     copy pgmap to new indirect block
          ai        r6,ipgmap
          mov       r5,r7
          li        r8,8
jlb0B7    mov       *r6,*r7+
          clr       *r6+
          dec       r8
          jne       jlb0B7  
          mov       r0,ipgmap(r1)             indirect block# in pgmap slot 0
          soc       islrge,iflags(r1)         adjust flags to 'large'
.
. Case 5: grow a large model file
.
jlb0B6    mov       r3,r5                     SIZE IN BLOCKS STILL THE SAME?
          mov       r4,r6                     round up new size to full blocks
          mov       sublkl(r2),r9
          dec       r9
          a         r9,r6
          jnc       jlb0B8  
          inc       r5
jlb0B8    div       sublkl(r2),r5             r5 = new size in blocks

          mov       isizeh(r1),r6             round up current size to
          mov       isizel(r1),r7               full blocks
          a         r9,r7
          jnc       jlb0B9  
          inc       r6
jlb0B9    div       sublkl(r2),r6             r6 = current size in blocks

          c         r5,r6                     size in blocks did not change?
          jne       jlb0BA                      -> it did
          b         lbl0DD                    -> simply update inode & return

jlb0BA    pshr      r3                        NEW SIZE WITHIN RANGE?
          pshr      r4
  
jlb0BE    pshr      r5                        ALLOCATE BLOCKS FROM R5 TO R6
          mov       r6,r4
          clr       r3                        r3,r4 = new end in blocks
          mov       sublkl(r2),r0
          srl       r0,1                      r0 = ptrs per block
          div       r0,r3                     r3 = indirect block #
          a         r4,r4                     r4 = offset in indir. block
          ci        r3,8                      bigger than max size?
          jhe       jlb0BB                      -> yes, report device full

          a         r3,r3                     INDIR BLOCK ALLOCATED?
          a         r1,r3                     fetch indir block # from map
          mov       ipgmap(r3),r0             slot is empty?
          jeq       jlb0BC                      -> yes, first allocate one

jlb0BF    pshr      r0                        DATA BLOCK ALLOCATED?
          bl        getblk                    fetch the indirect block
          data      lbl0DE                      -> catch I/O error
          a         r4,r3                     fetch the data block no.
          mov       *r3,r11                   no block allocated?
          jne       jlb0BD                      -> no, there is one

          pshr      r6                        ALLOCATE DATA BLOCK
          pshr      r1
          pshr      r4
          li        r1,1                      find 1 free block
          bl        newblk
          data      lbl0DF                      -> catch I/O error
          data      lbl0E0                      -> catch device full error
          popr      r4
          popr      r1
          popr      r6
          mov       r0,r7
          popr      r0
          pshr      r0
          bl        getblk                    get zeroed buffer for it
          data      lbl0DE                      -> catch I/O error
          a         r3,r4                     place new block # in indir. block
          mov       r7,*r4
          bl        putblk                    write back indir. block
          data      lbl0DE                      -> catch I/O error

jlb0BD    popr      r0                        MOVE TO NEXT NEW BLOCK
          popr      r5
          inc       r6                        increase current size by 1 block
          c         r5,r6                     reached final new size?
          jne       jlb0BE                      -> no, allocate more blocks
          b         jlb0AF                    -> update inode & normal return
.
. Step 5b: allocate a new indirect block
.
jlb0BC    pshr      r6                        ALLOCATE INDIR. BLOCK
          pshr      r3
          pshr      r1
          li        r1,1                      find 1 empty block
          bl        newblk
          data      lbl0E1                      -> catch I/O error
          data      lbl0E2                      -> catch device full error
          bl        getbuf                    get empty buffer for it
          data      lbl0E1                      -> catch I/O error
          popr      r1
          popr      r3
          popr      r6
          mov       r0,ipgmap(r3)             store indir. block # in pgmap
          jmp       jlb0BF                    -> continue with new data block

jlb0BB    popr      r5                        clean up stack
lbl0D4    popr      r4
          popr      r3
          popr      r11
          mov       2(r11),r11                TROW DEVICE FULL ERROR
          rt

lbl0DE    popr      r0                        clean up stack
jlb0C0    popr      r5
          popr      r4
          popr      r3
          b         jlb0B4                    -> throw I/O error

lbl0DF    popr      r4
          popr      r1
lbl0E3    popr      r6
          jmp       lbl0DE                    -> throw I/O error

lbl0E1    popr      r1
lbl0E4    popr      r3
          popr      r6
          jmp       jlb0C0                    -> throw I/O error

lbl0E0    popr      r4                        clean up stack, keep work so far
          popr      r1
          bl        updtim                    update modified time
          bl        wr$ino                    write inode back to disk
          data      lbl0E3                      -> catch I/O error
          popr      r6
          popr      r0
          jmp       jlb0BB                    -> report disk full error

lbl0E2    popr      r1                        clean up stack, keep work so far
          bl        updtim                    update modified time
          bl        wr$ino                    write inode back to disk
          data      lbl0E4                      -> catch I/O error
          popr      r3
          popr      r6
          jmp       jlb0BB                    -> report device full error

eight    data      8                          eight block ptrs in ipgmap

. -----------------------------------------------------------------------------

. Allocate a contiguous file (erases its current data!).
.
.   input: r1 = inode ptr, r0 = length in number of blocks
.
doaloc    pshr      r11

          mov       iflags(r1),r4             CHECK FILE TYPE
          andi      r4,ifft                   get type bits
          ci        r4,ifftn                  normal file?
          jne       jlb0C1                      -> no

          pshr      r0                        save len
          bl        truncf                    truncate the file
          data      lbl0E5                      -> catch I/O error
          popr      r0                        restore len
          pshr      r0                        and save again
          mov       r0,r0                     length is zero?
          jeq       jlb0C2                      -> yes, done
          pshr      r1                        save inode ptr
          mov       isuptr(r1),r2             get SU block ptr
          mov       r0,r1                     req. length
          bl        newblk                    find area of right size
          data      lbl0E6                      -> catch I/O error
          data      lbl0E7                      -> catch disk full
          popr      r1                        restore inode ptr

jlb0C2    popr      r4                        UPDATE INODE AND NORMAL RETURN
          mov       r0,ipgmap(r1)             pgmap[0] = first block#
          mov       r4,ipgmap+2(r1)           pgmap[1] = length in blocks
          soc       iscont,iflags(r1)         set 'contiguous' flag
          bl        updtim                    update last modified time
          bl        wr$ino                    write back inode to disk
          data      lbl0E8                      -> throw disk error
          popr      r11   
          b         6(r11)                    NORMAL RETURN

jlb0C1    popr      r11
          mov       2(r11),r11                THROW BAD FILE TYPE ERROR
          rt

lbl0E6    popr      r1                        clean up inode ptr
lbl0E5    popr      r0                        clean up length
lbl0E8    popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

lbl0E7    popr      r1                        clean up inode ptr
          popr      r0                        clean up length
          popr      r11
          mov       4(r11),r11                THROW DISK FULL ERROR
          rt
          
. -----------------------------------------------------------------------------

. Prepare disk buffer and zero it out. Do not read from disk if not buffered
. already.
.
.   input: r0 = block#, r2 = SU block ptr
.
.   output: r3 = data buf ptr
.
.   one error return: throw I/O error
.
getbuf    mov       lru$hd,r3                 FIND BUFFER ON LIST
jlb0C6    ci        r3,lru$q                  end of list reached?
          jeq       jlb0C3                      -> yes, make space
          c         r0,dbbno(r3)              matching block#?
          jne       jlb0C4                      -> no, skip
          c         r2,dbsu(r3)               matching SU?
          jeq       jlb0C5                      -> yes, use existing buffer
jlb0C4    mov       qfl(r3),r3                try next block
          jmp       jlb0C6

jlb0C5    mov       qhl(r3),r9                MAKE IT MRU
          blwp      REMOVE                    remove from end of queue
          li        r9,lru$q                    and add to the front
          blwp      INSERT
  
jlb0C8    ai        r8,dbbuf                  ZERO OUT BUFFER
          mov       sublkl(r2),r9             get block length
jlb0C7    clr       *r8+                      clear word
          dect      r9                        all words done?
          jne       jlb0C7                      -> no, do next

          seto      dbdrty(r3)                set dirty flag
          ai        r3,dbbuf                  set r3 to start of data
          b         2(r11)                    NORMAL RETURN

jlb0C3    pshr      r11
          bl        bflush                    flush LRU buffer
          data      lbl0E9                      -> catch I/O error
          mov       r0,dbbno(r3)              reallocate buffer to
          mov       r2,dbsu(r3)                 requested block
          mov       r3,r8                     prepare to zero out
          popr      r11
          jmp       jlb0C8                    -> zero buffer & return

lbl0E9    popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

. -----------------------------------------------------------------------------

. Truncate file to size zero
.
.   input:  r1 = inode buffer ptr
.
.   one error return: throw I/O error
.
truncf    pshr      r11

          mov       isuptr(r1),r2             SET UP AND CHECKS
          mov       r1,r4
          ai        r4,ipgmap                 r4  = page map
          li        r12,8                     r12 = page map size
          mov       iflags(r1),r0             figure out file type
          pshr      r1                        save inode buffer ptr
          coc       iscont,r0
          jeq       jlb0C9                      -> contiguous
          coc       islrge,r0
          jeq       jlb0CA                      -> large

jlb0CC    mov       *r4+,r0                   FREE SMALL MODEL BLOCKS
          jeq       jlb0CB                    no more block? -> done
          li        r1,1                      r1 = 1 = block count
          li        r3,1                      r3 = 1 = mark free
          bl        blkmrk                    return block to free list
          data      lbl0EA                      -> catch I/O error
          dec       r12                       more page map entries?
          jne       jlb0CC                      -> yes, process next slot

jlb0CB    popr      r1                        UPDATE INODE & NORMAL RETURN
          clr       isizeh(r1)                set size to zero
          clr       isizel(r1)
          li        r3,8                      zero out page map
          mov       r1,r4
          ai        r4,ipgmap
jlb0CD    clr       *r4+
          dec       r3
          jne       jlb0CD
          szc       islrge,iflags(r1)         reset to default 'small' model
          szc       iscont,iflags(r1)
          bl        wr$ino                    write inode to disk
          data      lbl0EB                       -> catch I/O error
          popr      r11
          b         2(r11)                    NORMAL RETURN

jlb0CA    mov       *r4+,r0                   FREE LARGE MODEL BLOCKS
          jeq       jlb0CB                    no more blocks? -> done
          pshr      r4                        save pgmap ptr & count
          pshr      r12
          clr       r4                        r4 offsets into indirect block
          mov       sublkl(r2),r12            block size to r12 = counter
jlb0CF    pshr      r0                        save indir block#
          bl        getblk                    (re)fetch indirect block
          data      lbl0EC                      -> catch I/O error
          a         r4,r3                     build ptr to next block#
          mov       *r3,r0                    fetch block#, test for zero = eof
          jeq       jlb0CE                    past eof? -> done
          li        r1,1                      r1 = 1 = block count
          li        r3,1                      r3 = 1 = mark free
          bl        blkmrk                    return block to free list
          data      lbl0EC                      -> catch I/O error
          popr      r0                        restore indir block#
          inct      r4                        next index within indir block
          dect      r12                       reached end of indirect block?
          jne       jlb0CF                      -> no, free next data block
          jmp       jlb0D0                      -> yes, done

jlb0CE    popr      r0                        clean up indir block#
jlb0D0    li        r1,1                      free indirect block
          li        r3,1
          bl        blkmrk
          data      lbl0ED                      -> catch I/O error
          popr      r12                       restore pgmap index & count
          popr      r4
          dec       r12                       more indirect blocks to process?
          jne       jlb0CA                      -> yes, process next indir blk
          jmp       jlb0CB                    update inode and normal return

jlb0C9    mov       2(r4),r1                  FREE CONTIGUOUS MODEL BLOCKS
          jeq       jlb0CB                    r1 = block count = 0? -> done
          mov       *r4,r0                    r0 = first block#
          li        r3,1                      r3 = 1 = mark free
          bl        blkmrk                    return blocks to free list
          data      lbl0EA                      -> catch I/O error
          jmp       jlb0CB                    update inode and normal return

lbl0EC    popr      r0                        clean up indir block#
lbl0ED    popr      r12                       clean up pgmap index & count
          popr      r4
lbl0EA    popr      r1                        clean up inode buffer ptr
lbl0EB    popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

. -----------------------------------------------------------------------------

. Seek data block in file
.
.    input:  r1 = inode buffer ptr, r3:r4 = file offset
.
.    output: r3 = block#, r4 = offset in block
.
.    two error returns:
.      1. throw I/O error
.      2. throw block not allocated
.
fdatbk    pshr      r11
          mov       isuptr(r1),r2             CALC BLOCK INDEX AND OFFSET
          div       sublkl(r2),r3             r3 = idx, r4 = offset

          mov       iflags(r1),r0             CHECK FILE TYPE
          coc       iscont,r0                 contiguous file?
          jeq       jlb0D1                      -> handle contiguous case
          coc       islrge,r0                 large model file?
          jeq       jlb0D2                      -> handle large model case
          ci        r3,8                      Data block must be 0-7
          jhe       jlb0D3                      -> otherwise out of range

          a         r3,r3                     SMALL MODEL FILE
          a         r1,r3                     look up block# in page map itself
          mov       ipgmap(r3),r0
jlb0D4    jeq       jlb0D3                      -> throw not allocated

jlb0D5    popr      r11
          b         4(r11)                    NORMAL RETURN

jlb0D2    pshr      r1                        save inode buf ptr
          mov       r3,r1                     calculate index of indirect block
          clr       r0                          r0 = index of indirect block
          mov       sublkl(r2),r3               r5 = offset in indirect block
          srl       r3,1                      
          div       r3,r0
          mov       r1,r5
          popr      r1
          ci        r0,8                      indirect block index < pgmap len?
          jhe       jlb0D3                      -> no, error
          pshr      r1
          a         r0,r0                     find indirect block# in page map
          a         r0,r1
          mov       ipgmap(r1),r0             r0 = indirect block#
          jeq       jlb0D3                      -> if zero, not allocated
          bl        getblk                    fetch indirect block
          data      lbl0EE                      -> catch I/O error
          popr      r1
          a         r5,r5                     fetch data block# from buffer
          a         r3,r5
          mov       *r5,r0                    data block # in r0
          jmp       jlb0D4                    -> normal return

.                                             HANDLE CONTIGUOUS FILE CASE
jlb0D1    c         r3,ipgmap+2(r1)           index <= allocated length?
          jhe       jlb0D3                      -> throw not allocated error
          mov       ipgmap(r1),r0             add index to no. of first block
          a         r3,r0
          jmp       jlb0D5                    -> and return

jlb0D3    popr      r11
          mov       2(r11),r11                THROW BLOCK NOT ALLOCATED ERROR
          rt 

lbl0EE    popr      r1                        clean up inode buffer ptr
          popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt        

islrge    data      iflarge                   large file flag
iscont    data      ifcont                    contiguaus file flag

. =============================================================================
.         DISK INODE OPERATIONS
. =============================================================================

. Read inode data from disk
.
.   input: r0 = inode#, r1 = inode buffer ptr (empty buffer)
.
.   output: none (inode buffer is filled with disk inode data)
.
.   one error return: throw I/O error
.
rd$ino    pshr      r11
          pshr      r1
          bl        dskino                    get disk inode ptr
          data      lbl0F0                      -> catch I/O error
          mov       r1,r11
          popr      r1

          mov       r1,r4                     COPY DISK INODE TO MEMORY INODE
          li        r5,19                     19 words = 38 bytes
jlb0D6    mov       *r11+,*r4+
          dec       r5
          jne       jlb0D6

          mov       r0,inonum(r1)             FILL IN EXTENDED INODE INFO
          mov       r2,isuptr(r1)
          clr       idirty(r1)                not dirty
          clr       inolnk(r1)                has no links
          clr       ilckvl(r1)                not locked by any user
          clr       ilck$q(r1)                no pending lock requests
          popr      r11
          b         2(r11)                    NORMAL RETURN

lbl0F0    popr      r1                        clean up inode buffer ptr
          popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

. -----------------------------------------------------------------------------

. Write i-node back to disk
.
.   input:  r1 = inode buffer ptr
.
.   output: none (inode data gets written back to disk)
.
.   one error return: throw I/O error
.
wr$ino    pshr      r11

          pshr      r1                        save inode buffer ptr
          mov       inonum(r1),r0             get inode# and SU block ptr
          mov       isuptr(r1),r2
          bl        dskino                    fetch inode block from disk
          data      lbl0F1                      -> catch I/O error

          popr      r11                       fetch inode buffer ptr
          pshr      r11
          li        r4,19                     copy inode data to disk buffer
jlb0D7    mov       *r11+,*r1+
          dec       r4
          jne       jlb0D7

          bl        putblk                    mark buffer dirty
          data      lbl0F1                      -> catch I/O error
          popr      r1                        restore inode buffer ptr
          clr       idirty(r1)                reset dirty flag
          popr      r11
          b         2(r11)                    NORMAL RETURN

lbl0F1    popr      r1                        clean up inode buffer ptr
          popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

. -----------------------------------------------------------------------------

. Get inode data from disk
.
.   input:  r0 = inode number
.
.   output: r1 = pointer to inode data
.
.   one error return: throw I/O error
.
dskino    mov       r11,*r10+
          mov       r0,*r10+
          dec       r0                        make inode number zero based
          mov       sublkl(r2),r4             Calculate inodes per block
          clr       r3
          div       inosiz,r3
          mov       r0,r5                     calc. block idx in inode table
          clr       r4
          div       r3,r4                     r3 = offset, r4 = index
          mov       suitad(r2),r0             add base of inode table
          a         r4,r0                     r0 = block# with inode
          mov       r5,r4                     r5 = offset in block to inode
          mpy       inosiz,r4
          bl        getblk                    fetch block with inode
          data      lbl0F3                      -> catch I/O error
          mov       r3,r1                     r1 = ptr to buffer
          a         r5,r1                     r1 = ptr to inode

          popr      r0                        restore inode#
          popr      r11
          b         2(r11)                    NORMAL RETURN

lbl0F3    popr      r0                        clean up inode#
          popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

inosiz    data      38                        inode size

. -----------------------------------------------------------------------------

. Find free inode
.
.    input:  r2 = SU block ptr
.
.    output: r0 = inode#
.
.    two error returns:
.      1. throw I/O error
.      2. throw no more free inodes error
.
newino    pshr      r11

          mov       suitad(r2),r4             SCAN FULL INODE TABLE
          mov       suitln(r2),r5
          clr       r6                        start at inode 0

jlb0DA    mov       r4,r0                     select next block
          bl        getblk                    fetch next block
          data      lbl0F4                      -> catch I/O error
          mov       sublkl(r2),r1             init r1 to block length
jlb0D9    inc       r6                        next inode#
          mov       *r3,r11                   not allocated?
          jeq       jlb0D8                      -> found free inode
          ai        r3,38                     move to next inode data slot
          ai        r1,-38
          ci        r1,38                     reached end of this block?
          jhe       jlb0D9                      -> no
          inc       r4                        move to next block in ino table
          dec       r5                        past last block?
          jne       jlb0DA                      -> no

          popr      r11
          mov       2(r11),r11                THROW INODE TABEL FULL
          rt

jlb0D8    mov       r6,r0                     move inode# to r0
          popr      r11
          b         4(r11)                    NORMAL RETURN

lbl0F4    popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

. =============================================================================
.         BLOCK ALLOCATION TABLE MANAGEMENT
. =============================================================================

. Find and allocate free blocks. Allocated range is contiguous. If no such
. range found, report disk full.
.
.   input:  r1 = required number of contiguous blocks
.           r2 = SU block ptr
.
.   output: r0 = first block of area
.
.   two error returns:
.     1. throw I/O error
.     2. throw disk full error
.
newblk    pshr      r11

          mov       r1,r4                     save required length
          mov       suatad(r2),r5             fetch allocation table location
          mov       suatln(r2),r6
          clr       r7                        start of range, start at 0

jlb0E0    mov       r5,r0                     FIND START POINT CANDIDATE
          bl        getblk                    get next block
          data      lbl0F5                      -> catch I/O error
          mov       r3,r8                     save buffer ptr [??]
          mov       sublkl(r2),r1             reset block len counter

jlb0DF    mov       *r3+,r0                   CHECK NEXT WORD, fully allocated?
          jeq       jlb0DB                      -> yes

          li        r11,16                    CHECK BITS IN WORD
jlb0DD    sla       r0,1                      next bit allocated?
          joc       jlb0DC                      -> no, test range
jlb0E4    inc       r7                        start point += 1 block
          dec       r11                       more bits to check?
          jne       jlb0DD                      -> yes
          jmp       jlb0DE                    -> move to next word

jlb0DB    ai        r7,16                     start point += 16 blocks

jlb0DE    dect      r1                        more words in this alloc. block?
          jne       jlb0DF                      -> yes, check next word
          inc       r5                        next block
          dec       r6                        past last block?
          jne       jlb0E0                      -> check next block

jlb0E7    popr      r11                       no suitable range found
          mov       2(r11),r11                THROW DISK FULL ERROR
          rt

jlb0DC    mov       r4,r9                     r9 = remaining length to find
          mov       r7,r12                    save start point candidate

jlb0E3    dec       r9                        range long enough?
          jeq       jlb0E1                      -> yes, found suitable range
          inc       r7
          dec       r11                       more bits to check in word?
          jeq       jlb0E2                      -> no, fetch next word
jlb0E6    sla       r0,1                      CHECK BITS IN WORD, next bit free?
          joc       jlb0E3                      -> yes, extend range
          jmp       jlb0E4                    -> seek next start candidate

jlb0E2    dect      r1                        more words in this alloc. block?
          jeq       jlb0E5                      -> no, fetch next block
jlb0E8    mov       *r3+,r0                   CHECK NEXT WORD, any bits free?
          jeq       jlb0DB                      -> seek next start candidate
          li        r11,16                    
          jmp       jlb0E6

jlb0E5    inc       r5                        FETCH NEXT BLOCK
          dec       r6                        past last block?
          jeq       jlb0E7                      -> yes, no suitable range found
          mov       r5,r0
          bl        getblk                    get next block
          data      lbl0F5                      -> catch I/O error
          mov       r3,r8                     save buffer ptr [??]
          mov       sublkl(r2),r1             reset block len counter
          jmp       jlb0E8

jlb0E1    mov       r12,r0                    r0 = first allocated block
          mov       r4,r1                     r1 = allocation length
          clr       r3                        r3 = 'set allocated' flag
          bl        blkmrk                    mark range as allocated
          data      lbl0F5                      -> catch I/O errors
          mov       r12,r0                    r0 = first allocated block
          mov       r4,r1                     r1 = allocation length
          popr      r11
          b         4(r11)                    NORMAL RETURN

lbl0F5    popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

. -----------------------------------------------------------------------------

. Mark or release block(s) in allocation table
.
.   input: r0 = starting block#, r1 = block count, 
.          r3 = mark (zero) or free (non zero)
.
.   one error return: throw I/O error
.
blkmrk    pshr      r11

          mov       r0,r6                     CALCULATE STARTING POINT
          clr       r5                        r5:r6 = bn/16 as dword
          srl       r6,4
          mov       sublkl(r2),r11            r11 = blklen/2
          srl       r11,1
          div       r11,r5                    r5 =     (bn/16) / (blklen/2)
          a         r6,r6                     r6 = 2 * (bn/16) % (blklen/2)
          mov       r0,r7                     save bn in r7
          mov       r1,r8                     save block count
          mov       r3,r9                     save mark/free flag
          a         suatad(r2),r5             r5 = (bn/16)/(blklen/2) + suatad

          mov       r5,r0                     PREPARE FOR BIT RANGE UPDATE             
          bl        getblk                    fetch block with range start bit
          data      lbl0F6                      -> catch I/O error
          mov       r3,r1
          a         r6,r1                     r1 = ptr to word with start bit
          neg       r6
          a         sublkl(r2),r6             r6 = remaing words in block           
          andi      r7,0F                     r7 = bn mod 16                    
          mov       r7,r0
          li        r11,08000                 init mask
          src       r11,r0                    r11 = mask for start bit

jlb0EC    mov       r9,r9                     UPDATE A BIT RANGE
          jne       jlb0E9                    test allocate vs. free
          szc       r11,*r1                   mark as allocated
          jmp       jlb0EA  
jlb0E9    soc       r11,*r1                   mark as free

jlb0EA    dec       r8                        full range marked?
          jeq       jlb0EB                      -> yes, done
          srl       r11,1                     pick next bit, more in this word?
          jnc       jlb0EC                      -> yes, go update next bit
          inct      r1                        else, move to next word
          dect      r6                        past end of disk buffer?
          jeq       jlb0ED                      -> yes, load next block
jlb0EE    li        r11,08000                 reset mask to top bit
          jmp       jlb0EC                    -> update next bit
.
jlb0ED    bl        putblk                    mark buffer dirty
          data      lbl0F6                      -> catch I/O error
          inc       r5                        select next block in
          mov       r5,r0                       allocation table
          bl        getblk                    fetch this block
          data      lbl0F6                      -> catch I/O error
          mov       r3,r1                     reset r1 to first word in block
          mov       sublkl(r2),r6             reset r6 to block length
          jmp       jlb0EE                    -> continue updating bits

jlb0EB    bl        putblk                    mark buffer dirty
          data      lbl0F6                      -> catch I/O error
          popr      r11
          b         2(r11)                    NORMAL RETURN

lbl0F6    popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

. -----------------------------------------------------------------------------

. Calculate free blocks and largest contiguous block
.
.   input:  r2 = SU block ptr
.
.   output: r0 = total free blocks, r1 = largest contiguous range
.
.   one error return: throw I/O error
.
clcfre    pshr      r11                       SETUP
          clr       r9                        r9  = total free blocks
          clr       r12                       r12 = free contiguous
          clr       r7                        r7  = current range length
          mov       suatad(r2),r5
          mov       suatln(r2),r6

jlb0F5    mov       r5,r0                     SCAN ALLOCATION TABLE
          bl        getblk                    get next block
          data      lbl0F7                      -> catch I/O error
          mov       r3,r8
          mov       sublkl(r2),r1             calc block len in words
          srl       r1,1
jlb0F4    mov       *r3+,r0                   word fully allocated?
          jeq       jlb0EF                      -> yes, ends current free range
          ci        r0,0FFFF                  word fully free?
          jeq       jlb0F0                      -> skip bit counting

          li        r11,16                    COUNT FREE BITS
jlb0F3    sla       r0,1                      check next bit - is it free?
          joc       jlb0F1                      -> yes, count

          c         r7,r12                    HANDLE END OF FREE RANGE (BIT)
          jle       jlb0F2                    larger range? -> no
          mov       r7,r12                    update largest so far count
jlb0F2    clr       r7                        reset current counter
          dec       r11                       more bits in word?
          jne       jlb0F3                      -> yes, check next bit

jlb0F7    dec       r1                        MORE WORDS IN ALLOCATION BLOCK?
          jne       jlb0F4                    last word? -> no, do next word      
          inc       r5                        move to next allocation block
          dec       r6                        past last one?
          jne       jlb0F5                      -> no, process next block

          popr      r11                       NORMAL RETURN
          mov       r9,r0                     r0 = total free blocks
          mov       r12,r1                    r1 = largest cont. free range
          b         2(r11)

jlb0EF    c         r7,r12                    LARGET THAN LARGEST SO FAR?
          jle       jlb0F6                      -> no
          mov       r7,r12                    update largest so far
jlb0F6    clr       r7                        restart range length counter
          jmp       jlb0F7                    -> resume search

jlb0F1    inc       r9                        FOUND FREE BIT
          inc       r7                        increase free counters
          dec       r11                       last bit in word?
          jne       jlb0F3                      -> no, check next bit
          jmp       jlb0F7                      -> yes, check next word

jlb0F0    ai        r9,16                     FOUND FULLY FREE WORD
          ai        r7,16                     increase counters by 16 blocks
          jmp       jlb0F7                      -> continue with next word

lbl0F7    popr      r11                       THROW I/O ERROR
          mov       *r11,r11
          rt
          
. =============================================================================
.        INODE AND DISK BUFFER MANAGEMENT
. =============================================================================

. Sync and all inode and disk buffers for SU. Check that no inodes remain
. 'open' for this volume. Check that all data blocks have been written.
.
.   input:  r2 = SU block ptr
.
.   output: none (volume sync'ed & buffers invalidated)
.
.   two error returns:
.     1. throw I/O error
.     2. throw unit busy error
.
syndsk    pshr      r11

          pshr      r2                        save SU block ptr
          bl        dosync                    sync inode and data buffers
          data      lbl0F8                      -> catch I/O errors
          popr      r2

          mov       ino$hd,r1                 INVALIDATE CACHED INODES
jlb0FA    ci        r1,ino$q                  reached end of list?
          jeq       jlb0F8                      -> yes, move on to buffers
          ai        r1,-inodmq
          c         r2,isuptr(r1)             still open inodes on this volume?
          jeq       jlb0F9                      -> yes, throw busy error
          mov       inodmq+qfl(r1),r1         move to next chached inode
          jmp       jlb0FA                    -> process next one

jlb0F8    mov       lru$hd,r1                 INVALIDATE DISK BUFFERS
jlb0FE    ci        r1,lru$q                  reached end of list?
          jeq       jlb0FB                      -> yes, done
          c         r2,dbsu(r1)               holds data for this SU?
          jne       jlb0FC                      -> no, move to next
          mov       dbdrty(r1),r0             still dirty?
          jeq       jlb0FD                      -> no, is okay
          lrex                                ** INTERNAL ERROR ** [??]

jlb0FD    clr       dbsu(r1)                  invalidate buffer
jlb0FC    mov       qfl(r1),r1                move to next disk buffer
          jmp       jlb0FE                    -> process next one

jlb0FB    popr      r11
          b         4(r11)                    NORMAL RETURN

lbl0F8    popr      r2                        clean up saved SU ptr
          popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt

jlb0F9    popr      r11
          mov       2(r11),r11                THROW UNIT BUSY ERROR
          rt

. -----------------------------------------------------------------------------

. Flush all dirty inode and block buffers to disk
.
.   input:  none
.
.   output: none (volume sync'ed)
.
.   one error return: throw I/O error
.
dosync    pshr      r11

          mov       ino$hd,r1                 FLUSH ALL DIRTY INODES TO DISK
jlb101    ci        r1,ino$q                  last cached inode?
          jeq       jlb0FF                      -> yes, do block buffers next
          ai        r1,-inodmq                get cached inode ptr
          mov       idirty(r1),r0             not dirty?
          jeq       jlb100                      -> yes, skip
          mov       inonum(r1),r0             not used?
          jeq       jlb100                      -> yes, skip
          bl        wr$ino                    write back to disk
          data      lbl0F9                      -> catch I/O error
jlb100    mov       inodmq+2(r1),r1           move to next cached inode
          jmp       jlb101

jlb0FF    mov       lru$hd,r8                 FLUSH ALL DIRTY BLOCK BUFFERS
jlb104    ci        r8,lru$q                  last disk buffer?
          jeq       jlb102                      -> yes, done
          mov       dbdrty(r8),r0             not dirty?
          jeq       jlb103                      -> yes, skip

          mov       dbbno(r8),r1              write back to disk
          mov       dbsu(r8),r2
          li        r0,w$                     command = write
          mov       r8,r3
          ai        r3,dbbuf
          mov       suhior(r2),r4             [??] superfluous?
          blwp      devmsg                    send command to driver
          data      lbl0FA                      -> catch I/O error
          clr       dbdrty(r8)                reset dirty flag

jlb103    mov       qfl(r8),r8                move to next block
          jmp       jlb104

jlb102    popr      r11
          b         2(r11)                    NORMAL RETURN

lbl0FA    pshr      r8                        REPORT SYNC FAILURE BUT CONTINUE
          mov       dbsu(r8),r2               convert SU block ptr into SU#
          clr       r0
          li        r3,SUIT                   compare SU ptr with list
          li        r1,SUITL
jlb106    inc       r0
          c         *r3+,r2
          jeq       jlb105                    until found, report SU# in r0
          dec       r1
          jne       jlb106

jlb105    li        r1,2                      BUILD ERROR TEXT
          li        r2,lbl0FB+1               print SU# in error message
          bl        bufprt
          mov       dbbno(r8),r0              print block# in error message
          li        r1,5
          li        r2,lbl0FC+1
          bl        bufprt
          
          li        r1,76                     BUILD TERMINAL MESSAGE BLOCK
          blwp      BGETA$                    allocate message buffer
          data      MEMFUL  
          mov       r1,r8
          ai        r1,mbtext                 copy error text into message
          li        r2,lbl0FD
          li        r0,66                     message length = 66
          mov       r0,mblen(r8)
jlb107    movb      *r2+,*r1+
          dec       r0
          jne       jlb107

          li        r0,1                      SEND MESSAGE TO SYSTEM TERMINAL
          mov       r0,mbtype(r8)
          mov       TRIT,r0
          bl        TRMQMS

          popr      r8                        PREPARE TO CONTINUE
          clr       dbdrty(r8)                clear dirty flag anyway
          jmp       jlb103                    try next buffer

lbl0F9    popr      r11
          mov       *r11,r11                  THROW I/O ERROR
          rt
.
. Print number in r0 to buffer at r2, size at r1
.
bufprt    a         r2,r1                     make r3 point at end of buffer
          mov       r1,r3
jlb108    dec       r1                        blank out the buffer with spaces
          movb      spaces,*r1
          c         r1,r2
          jne       jlb108
jlb10A    dec       r3                        'previous' digit
          mov       r0,r1                     calc. digit and place in buffer
          clr       r0
          div       ten,r0
          ai        r1,'0'
          swpb      r1
          movb      r1,*r3
          mov       r0,r0                     skip leading zeroes
          jeq       jlb109  
          c         r2,r3
          jne       jlb10A  
jlb109    rt

lbl0FD    byte      7                         <BEL>
          text      '** Storage unit'
lbl0FB    text      ' ??:  Unrecoverable write error on block'
lbl0FC    text      ' ????? **'
          byte      0d

. -----------------------------------------------------------------------------

. Get a buffer with disk block data. Preserves registers.
.
.   input:  r0 = block#, r2 = SU block ptr
.
.   output: r3 = data buffer ptr
.
getblk    mov       lru$hd,r3                 IS BLOCK ALREADY LOADED?
jlb10E    ci        r3,lru$q                  reached end of LRU list?
          jeq       jlb10B                      -> free block & load new
          c         r0,dbbno(r3)              buffer has matching block no?
          jne       jlb10C                      -> no, try next buffer
          c         r2,dbsu(r3)               buffer has matching SU?
          jeq       jlb10D                      -> yes, found in memory
jlb10C    mov       qfl(r3),r3                try next buffer in list
          jmp       jlb10E

jlb10D    pshr      r8                        MAKE IT MOST RECENTLY USED BUFFER
          pshr      r9                        save r8, r9
          mov       qhl(r3),r9                remove from tail of LRU queue
          blwp      REMOVE
          li        r9,lru$q                  insert at head of LRU queue
          blwp      INSERT
          ai        r3,dbbuf                  set r3 to data part
          popr      r9                        restore r9
          popr      r8                        restore r8
          b         2(r11)                    NORMAL RETURN

jlb10B    pshr      r11                       FREE BUFFER FOR DISK BLOCK
          bl        bflush                    flush LRU buffer to disk
          data      lbl0FF                      -> catch I/O error
          pshr      r1                        save r1
          pshr      r8                        save r8
          mov       r0,dbbno(r3)              set SU and block# for buffer
          mov       r2,dbsu(r3)
          mov       r0,r1                     ask driver to read the block
          li        r0,r$                     command = read
          ai        r3,dbbuf
          mov       suhior(r2),r8             [??] superfluous?
          blwp      devmsg                    send command to driver
          data      lbl100                      -> catch I/O error, rethrow
          popr      r8                        restore r8
          popr      r1                        restore r1
          popr      r11
          b         2(r11)                    NORMAL RETURN

lbl100    popr      r8                        clean up saved r8
          popr      r1                        clean up saved r1
          ai        r3,-dbbuf
          clr       dbsu(r3)                  invalidate buffer
lbl0FF    popr      r11     
          mov       *r11,r11                  THROW I/O ERROR
          rt

. -----------------------------------------------------------------------------

. Place buffer on head of LRU queue and mark dirty. Preserves registers.
.
.   input: r3 = disk buffer pointer
.
.   note: has unused error vector [??]
.
putblk    pshr      r8                        save registers                     
          pshr      r9
          pshr      r1
          pshr      r2
          ai        r3,-dbbuf                 r3 = buffer slot ptr
          mov       qhl(r3),r9                remove from queue
          blwp      REMOVE
          li        r9,lru$q                  and reinsert at head
          blwp      INSERT                      (i.e. make MRU)
          seto      dbdrty(r3)                set dirty flag
          popr      r2                        restore registers
          popr      r1
          popr      r9
          popr      r8
          b         2(r11)                    NORMAL RETURN

. -----------------------------------------------------------------------------

. Pick LRU buffer, write back if dirty and return as fresh buffer. Preserves
. regsiters.
.
.   input:  -
.
.   output: r3 = buffer ptr
.
.   one error vector: throw I/O error
.
bflush    pshr      r8                        save registers
          pshr      r9
          li        r9,lru$q                  remove last (=LRU) buffer
          blwp      REMOVE                      and insert at front
          blwp      INSERT
          mov       r8,r3                     save buffer ptr in r3
          mov       dbdrty(r8),r9             is it dirty?
          jeq       jlb10F                      -> no, we're done

          pshr      r2                        WRITE BACK DIRTY BUFFER
          pshr      r1                        save registers
          pshr      r0
          mov       dbbno(r8),r1              set disk location
          mov       dbsu(r8),r2
          li        r0,w$                     command = write
          ai        r3,dbbuf                  r3 = buffer data ptr
          mov       suhior(r2),r8             [??] superfluous
          blwp      devmsg                    send write command
          data      lbl101                      -> catch I/O error
          ai        r3,-dbbuf                 r3 = buffer slot ptr
          clr       dbdrty(r3)                reset dirty flag

          popr      r0                        restore registers
          popr      r1
          popr      r2
jlb10F    popr      r9
          popr      r8
          b         2(r11)                    NORMAL RETURN

lbl101    popr      r0                        restore registers  
          popr      r1
          popr      r2
          popr      r9
          popr      r8
          mov       *r11,r11                  THROW I/O ERROR
          rt

. =============================================================================
.        DRIVER INTERFACE ROUTINES
. =============================================================================

. Send command message to disk driver and wait for its status reply
.
.   input: r0 = command (r$, w$, ld$, dc$)
.          r1 = block#
.          r2 = SU block ptr
.          r3 = disk buffer ptr
.          usrbank = ultimate caller's memory bank
.
.   output: command is executed
.
devmsg    data      fs$ws2                    use fresh WS
          data      lbl103

lbl103    li        r1,bdml                   BUILD MESSAGE BLOCK
          blwp      BGETA$                    allocate message block
          data      MEMFUL
          mov       *r13,bdfunc(r1)           caller r0 has requested function
          mov       4(r13),r2                 caller r2 has SU ptr
          mov       suhiou(r2),bdunit(r1)       -> set device number
          clr       bdsad1(r1)                set bdsad to byte index
          mov       2(r13),r3                 - caller r1 has block#
          mpy       sublkl(r2),r3             - multiply by block length
          mov       r3,bdsad2(r1)             - and store
          mov       r4,bdsad3(r1)
          mov       6(r13),bdmad(r1)          caller r3 has buffer address
          mov       sublkl(r2),bdmln(r1)      length is one full block (sector)
          mov       r2,r0                     set reply to queue for response
          ai        r0,surplm
          mov       r0,bdrpl(r1)
          mov       usrbnk,bdmbk(r1)          set user memory bank (for ld$)

          mov       r1,r8                     QUEUE MESSAGE IN DEVICE DRIVER
          mov       suhior(r2),r1             driver entry vector to r1
          mov       suhiop(r2),r9             device control table to r9
          mov       bvqmsg(r1),r1             read qmsg entry point
          bl        *r1                       make call with msg ptr in r8

          mov       r2,r0                     WAIT FOR REPLY
          ai        r0,surpld
          blwp      P$

          mov       r2,r9                     DEQUEUE REPLY & CHECK STATUS
          ai        r9,surplm
          blwp      REMOVE
          mov       bdstat(r8),r0             fetch status
          mov       r8,r1                     free message block
          blwp      BREL$
          mov       r0,r0                     status OK?
          jne       jlb110                      -> no, throw error
          inct      r14                       NORMAL RETURN
          rtwp

jlb110    mov       *r14,r14                  THROW I/O ERROR
          rtwp

. -----------------------------------------------------------------------------

. Send device characteristics message to disk driver
.
.   input:  r2 = SU blk ptr
.
.   output: r0 = device characteristics from device driver
.
get$dc    data      fs$ws2                    use fresh WS
          data      lbl104

lbl104    mov       2*r2(r13),r2              BUILD MESSAGE BLOCK
          li        r1,bdml                   allocate command message
          blwp      BGETA$
          data      MEMFUL  
          li        r0,dc$                    set command dc$ = get dev. char.
          mov       r0,bdfunc(r1)
          mov       suhiou(r2),bdunit(r1)     set device unit number
          mov       r2,r0                     set device reply queue address
          ai        r0,surplm
          mov       r0,00012(r1)
.
          mov       r1,r8                     QUEUE MESSAGE IN DEVICE DRIVER
          mov       suhior(r2),r1             device entry vector
          mov       suhiop(r2),r9             device control table
          mov       bvqmsg(r1),r1             device queue message routine
          bl        *r1                       queue the command msg
.
          mov       r2,r0                     WAIT FOR REPLY
          ai        r0,surpld
          blwp      P$

          mov       r2,r9                     DEQUEUE REPLY & REPORT STATUS
          ai        r9,surplm
          blwp      REMOVE
          mov       bdstat(r8),*r13           reply status to caller r0
          mov       r8,r1                     release message block
          blwp      BREL$
          rtwp

. =============================================================================
.        SUPPORT ROUTINES
. =============================================================================

. Scan text string, return next char as upercase. Sets LT flag if end-of-string
. has been reached. Returns 7-bit ascii, i.e. high bit is dropped
.
.   input:  r6 = string leng, r7 = string ptr (both adjusted by routine)
.
.   output: r0 = next char (uppercased), LT flag set if string empty
.
SCAN*     dec       r6                        still characters in buffer?
          jlt       jlb111                      -> no, done
          movb      *r7+,r0                   fetch character
          srl       r0,8                      move to low byte
          ci        r0,060                    already uppercase?
          jlt       jlb112                      -> ready
          andi      r0,05F                    make uppercase + drop msb
jlb111    rt

jlb112    andi      r0,07F                    drop msb
          rt
          
. -----------------------------------------------------------------------------

. Parse a number in a text string.
.
.   input:  r6 = string len, r7 = string ptr (both adjusted by routine)
.
.   output: r1 = number value, r3 = number of digits read
.
NUMBER*   pshr      r11

          clr       r1                        init value and count
          clr       r3

jlb114    bl        SCAN                      CHECK LEADING CHARS
          jlt       jlb113                    eol reached? -> done
          ci        r0,' '                    is it white space?
          jeq       jlb114                      -> yes, skip
          ci        r0,'*'                    is it an asterix?
          jeq       jlb115                      -> yes, return wildcard value
          ci        r0,'0'                    leading '0'?
          jeq       jlb116                      -> do hex number

jlb117    ci        r0,'0'                    is char < '0'?
          jlt       jlb113                      -> yes, end of number
          ci        r0,'9'                    is char > '9'?
          jgt       jlb113                      -> yes, end of number
          andi      r0,0F                     get digit value
          mpy       ten,r1                    value x 10
          mov       r2,r1
          a         r0,r1                     value += digit
          inc       r3                        increase digit counter
          bl        SCAN                      get next char
          jlt       jlb113                    eol reached? -> done
          jmp       jlb117                    -> process next char

jlb113    inc       r6                        'push back' last character
          dec       r7
jlb118    popr      r11                       NORMAL RETURN
          rt

jlb115    li        r1,07FFF                  07FFF used as wildcard '*' value
          inc       r3                        still only 1 digit
          jmp       jlb118                    -> normal return

jlb116    ci        r0,'0'                    is char < '0'
          jlt       jlb113                      -> yes, end of number
          ci        r0,'9'                    is char > '9'?
          jgt       jlb119                      -> yes, check A-F
          andi      r0,0F                     get digit value
jlb11A    sla       r1,4                      value x 16
          a         r0,r1                     value += digit
          inc       r3                        increase digit counter
          bl        SCAN                      get next char
          jlt       jlb113                    eol reached? -> done
          jmp       jlb116                    -> process next char

jlb119    ci        r0,'A'                    is char < 'A'?
          jlt       jlb113                      -> yes, end of number
          ci        r0,'F'                    is char > 'F'?
          jgt       jlb113                      -> yes, end of number
          ai        r0,10-'A'                 calc digit value         
          jmp       jlb11A                    -> continue with number

ten       data      10
spaces    text      '  '

. =============================================================================
.        DATA FIELDS
. =============================================================================


inobuf    bss       56                        tmp inode buffer for prep
dirent    bss       2                         buffer for directory entry
dirnam    bss       14                        id, name part
tmpnam    bss       14                        buffer for file/volume name
temp1     bss       2                         temp var
temp2     bss       2                         temp var
lbl096    bss       2                         temp var
lbl097    bss       2                         temp var
lbl098    bss       2                         temp var
lru$q     bss       4                         LRU queue of disk block buffers
ino$fq    bss       4                         queue of free inode cache slots
ino$q     bss       4                         queue of in-use inode cache slots
fs$ws2    bss       32                        extra FS workspace
msgptr    bss       2                         copy of message pointer
usrbnk    bss       2                         memory bank of user
umode     bss       2                         kernel / user flag for read/write
temp3     bss       2                         temp var
lbl030    bss       2                         temp var
lbl031    bss       2                         temp var
.
          end        
.