.
. Reconstructed source code of NOS/MT
.
.   Original code by John Walker / Dan Drake, ca. 1980
.   Disassembly tool by Peter Buro, 1986
.
          idt       "JSYSF"
.
          copy      "../systemdef/sysdef"
          copy      "../systemdef/specialdef"
          copy      "../source/jsys$"
.
. =============================================================================
. FILE RELATED JSYS WORKER ROUTINES
. =============================================================================

.    +----------+----------+
.  0 | JOPEN    | (stat)   |
.  2 | path len | (fileno) |
.  4 |      path addr      |
.  6 |     access mode     |
.    +----------+----------+

jopen*    bl        chklen                    check name length > 0
          data      2
          clr       r0                        allocate FS msg + path
          bl        afsmsg
          bl        FSBHEA                    fill out std FS header
          clr       r0
          bl        SPECFT                    path = special file ?
          data      lbl002                      -> yes
          bl        FSEND                     no, open normal file

lbl009    movb      frstat+1(r8),ujpkt+1(r7)  HANDLE FS REPLY MSG
          jne       jlb000                      error? -> done
          bl        newfcb                    find free file handle
          data      lbl004                      -> no free handle found

          mov       frtext(r8),officode(r2)   copy file code to FCB
          clr       ofcpos(r2)                set FCB file offset to 0
          clr       ofcpos+2(r2)
          mov       ujpkt+6(r7),ofpermit(r2)  copy file perm. to FCB

jlb000    mov       r8,r1                     RELEASE FS MSG AND RETURN
          blwp      BREL$
          b         JSYSE

lbl004    movb      KSMXOF,ujpkt+1(r7)        REPORT TOO MANY FILES OPEN
          mov       frtext(r8),fmrqst(r8)     move file code
          bl        FSBHEA                    fill out std FS header
          li        r0,close$                 set type to 'close'
          mov       r0,mbtype(r8)
          bl        FSEND                     send to FS and wait for reply
          jmp       jlb000                      -> release msg & return

lbl002    swpb      r0                        FREE FS MESSAGE
          movb      r0,ujpkt+3(r7)            save dev file handle in reply
          mov       r8,r1                     free FS message
          blwp      BREL$

          mov       spnvec(r2),r1             CHECK DEVICE EXIT NEEDS
          mov       spvexit(r1),r1            device needs exit$ routine call?
          jeq       jlb001                      -> no
          li        r1,umbspfx                set special dev exit$ flag
          soc       r1,usmodeb(r7)

jlb001    bl        calspv                    CALL DEVICE OPEN ROUTINE
          data      spvopen

.    +----------+----------+
.  0 | JCLOSE   | (stat)   |
.  2 |          | fileno   |
.    +----------+----------+

jclose*   bl        SPECIX                    is it a device file?
          data      lbl006                      -> yes
          bl        getfcb                    look up file code
          data      notopn                      -> file not open

          li        r1,18                     BUILD AND SEND FS MESSAGE
          blwp      BGETA$
          data      MEMFUL  
          mov       officode(r2),fmrqst(r1)   set param 0 = file code
          clr       officode(r2)              free FCB
          mov       r1,r8
          bl        FSBHEA                    fill out std FS request header
          bl        FSEND                     send msg to FS, wait for reply

fsretn    movb      frstat+1(r8),ujpkt+1(r7)  copy FS status to reply jpkt
          mov       r8,r1                     free FS message
          blwp      BREL$
          b         JSYSE                     return/relay FS status

notopn    movb      KSBADF,ujpkt+1(r7)        report bad file handle
          b         JSYSE

lbl006    bl        calspv                    call special dev 'close'
          data      spvclose

.    +----------+----------+
.  0 | JCREAT   | (stat)   |
.  2 | path len | (fileno) |
.  4 |      path addr      |
.  6 |     access mode     |
.    +----------+----------+

jcreat*   bl        chklen                    check path len >0
          data      2                         len offset in packet
          li        r0,2                      one extra FS msg word (2 bytes)
          bl        afsmsg                    allocate FS msg + 2 + path 
          bl        FSBHEA                    fill out std FS request header
          li        r0,2                      one extra word
          bl        SPECFT                    check path, special file?
          data      lbl002                      -> yes, treat as open
          mov       ujpkt+8(r7),fmrqst(r8)    copy access flags to FS msg
          jne       jlb002                      given? -> yes
          mov       usdefpr(r7),fmrqst(r8)    use default bits
jlb002    bl        FSEND                     send msg to FS & wait for reply
          b         lbl009                    -> handle reply as for open

.    +----------+----------+
.  0 | JLINK    | (stat)   |
.  2 | path len | (fileno) |  note: file path
.  4 |      path addr      |
.  6 | path len |          |  note: alias path
.  8 |      path addr      |
.    +----------+----------+

jlink*    bl        chklen                    check file path len > 0
          data      2                         offset of len byte
          bl        chklen                    check alias path len > 0
          data      6                         offset of len byte

          mov       ujpkt+2(r7),r1            ALLOCATE FS MESSAGE
          srl       r1,8                        (header + 4 + 2 * path len)
          mov       r1,r4
          mov       ujpkt+6(r7),r3
          srl       r3,8
          a         r3,r1                     file path len + alias path len
          ai        r1,fmrqst+4               add header len + 4
          blwp      BGETA$                    allocate message
          data      MEMFUL  
          mov       r1,r8
          bl        FSBHEA                    fill out std FS request header
          mov       r3,fmrqst(r8)             set par 0 = alias path len
          mov       r4,fmrqst+2(r8)           set par 1 = file path len

          mov       r8,r2                     COPY ALIAS PATH TO MESSAGE
          ai        r2,fmrqst+4               r2 = dst = par 3 addr          
          mov       ujpkt+8(r7),r1            r1 = src = alias path addr
          mov       fmrqst(r8),r0             r0 = alias path len
          mov       usmb(r7),r3               r3 = user mem bank
          bl        MFU                       copy from user memory

          mov       r8,r2                     COPY FILE PATH TO MESSAGE
          ai        r2,fmrqst+4 
          a         fmrqst(r8),r2             r2 = dst = addr after alias path
          mov       ujpkt+4(r7),r1            r1 = src = file path addr
          mov       fmrqst+2(r8),r0           r0 = file path len
          mov       usmb(r7),r3               r3 = user mem bank
          bl        MFU                       copy from user memory

          bl        FSEND                     send to FS, wait for reply
          b         fsretn                    -> finish request

.    +----------+----------+
.  0 | JDELET   | (stat)   | also JDMOUN, JMKDIR, JSBOOT
.  2 | path len |          |
.  4 |      path addr      |
.    +----------+----------+

jdmoun*   equ       $
jmkdir*   equ       $
jsboot*   equ       $
jdelet*   bl        chklen                    check path len > 0
          data      2
          clr       r0                        zero extra params
          bl        afsmsg                    allocate FS message
          bl        FSBHEA                    fill out std FS request header
          bl        FSEND                     send to FS, wait for reply
          b         fsretn                    -> finish sys call

.    +----------+----------+
.  0 | JREAD    | (stat)   | also JWRITE
.  2 |          | fileno   |
.  4 |     buffer addr     |
.  6 |     buffer len      |
.  8 |   (bytes xferred)   |
.    +----------+----------+

jwrite*   equ       $
jread*    bl        SPECIX                    IS DEVICE FILE HANDLE?
          data      lbl00B                      -> yes

          bl        getfcb                    FIND FILE HANDLE
          data      notopn                      -> not found

          mov       ofpermit(r2),r0           CHECK PERMISSIONS 
          cb        ujpkt(r7),lbl00C          operation is 'read'?
          jne       jlb003                      -> no, check 'w' bit
          andi      r0,1                      check 'r' bit
          jne       jlb004                      -> no, protection error
          jmp       jlb005                    -> permissions OK
jlb003    andi      r0,2                      check 'w' bit
          jne       jlb004                      -> no, protection error

jlb005    mov       ujpkt+6(r7),r1            EMPTY READ/WRITE?
          jeq       jlb006                      -> yes, done

          li        r1,fmrqst+12              BUILD AND SEND FS MESSAGE
          blwp      BGETA$
          data      MEMFUL  
          mov       r1,r8
          bl        FSBHEA                    fill out std FS request header
          mov       officode(r2),fmrqst(r8)   set file code
          mov       ofcpos(r2),fmrqst+2(r8)   set file offset (32 bit)
          mov       ofcpos+2(r2),fmrqst+4(r8)
          mov       ujpkt+4(r7),fmrqst+6(r8)  set buffer address
          mov       usmb(r7),fmrqst+8(r8)     set user memory bank
          mov       ujpkt+6(r7),fmrqst+10(r8) set buffer length
          bl        FSEND                     send msg to FS, wait for reply

          movb      frstat+1(r8),ujpkt+1(r7)  HANDLE FS REPLY, status OK?
          jne       jlb007                      -> no
          mov       frstat+2(r8),r0           zero bytes transferred?
          jne       jlb007                      -> no
          movb      KSEOF,ujpkt+1(r7)         set EOF status
jlb007    mov       frstat+2(r8),r0           copy no. bytes transferred
          mov       r0,ujpkt+8(r7)
          a         r0,ofcpos+2(r2)           adjust file offset
          jnc       jlb008  
          inc       ofcpos(r2)
jlb008    mov       r8,r1                     release FS reply msg
          blwp      BREL$
          b         JSYSE                     -> return with status

jlb004    movb      KSPROT,ujpkt+1(r7)        protection violation
          clr       ujpkt+8(r7)               zero bytes transferred
          b         JSYSE                     -> return with status

jlb006    clr       ujpkt+8(r7)               zero bytes transferred
          b         JSYSEN                    -> return with status OK

lbl00B    cb        ujpkt(r7),lbl00C          CALL DEVICE READ/WRITE ROUTINE
          jeq       jlb009                      -> is 'read'
          bl        calspv                    call write routine
          data      spvwrite
jlb009    bl        calspv                    call read routine
          data      spvread

lbl00C    data      read$*256

.    +----------+----------+
.  0 | JSEEK    | (stat)   |
.  2 | whence   | fileno   |
.  4 |     seek len H      |
.  6 |     seek len L      |
.  8 |   (new offset H)    |
. 10 |   (new offset L)    |
.    +----------+----------+

jseek*    bl        SPECIX                    is it a special file?
          data      lbl00D                      -> yes
          bl        getfcb                    get FCB ptr
          data      notopn                      -> catch not open

          mov       ujpkt+4(r7),r3            seek size to r3,r4
          mov       ujpkt+6(r7),r4
          mov       ujpkt+2(r7),r0            test 'whence'
          srl       r0,8                      is whence zero?
          jeq       jlb00A                      -> yes, do SEEK_SET
          dec       r0                        is whence one?
          jeq       jlb00B                      -> yes, do SEEK_CUR
          dec       r0                        is whence two or more?
          jne       jlb00C                      -> yes, error
          jmp       jlb00C

jlb00A    mov       r3,ofcpos(r2)             SET FILE OFFSET
          mov       r4,ofcpos+2(r2)
          mov       r3,ujpkt+8(r7)            and report same back
          mov       r4,ujpkt+10(r7)
          b         JSYSEN

jlb00B    a         ofcpos(r2),r3             ADD CURRENT OFFSET
          a         ofcpos+2(r2),r4
          jnc       jlb00A                    -> then handle as SEEK_SET
          inc       r3                        handle carry as needed
          jmp       jlb00A

jlb00C    movb      KSFUNC,00023(r7)          REPORT BAD SUB FUNCTION
          b         JSYSE                     -> return with status

lbl00D    clr       ujpkt+8(r7)               PASS ON TO DRIVER,
          clr       ujpkt+10(r7)                setting new offset to zero
          bl        calspv
          data      spvseek

.    +----------+----------+
.  0 | JIOCTL   | (stat)   |
.  2 | str len  | fileno   |
.  4 |     string addr     |
.    +----------+----------+

jioctl*   bl        SPECIX                    is it a special file?
          data      lbl00E                      -> yes
          b         JSYSEN                    ignore, just report status OK

lbl00E    bl        calspv                    PASS ON TO DRIVER
          data      spvioctl

.    +----------+----------+
.  0 | JFSTAT   | (stat)   | also JVSTAT
.  2 | path len |          |
.  4 |      path addr      |
.  6 |     buffer addr     |
.  8 |     buffer len      |
. 10 |   (bytes xferred)   |
.    +----------+----------+

jvstat*   equ       $
jfstat*   bl        chklen                    check path len > 0
          data      2                         offset to path len
          clr       r0                        no extra FS words
          bl        afsmsg                    allocate FS msg + path

jlb010    bl        FSBHEA                    fill out std FS request header
          bl        FSEND                     send msg to FS, wait for reply
          movb      frstat+1(r8),ujpkt+1(r7)  copy FS status, status is OK? 
          jne       jlb00D                      -> no, report back

          mov       ujpkt+6(r7),r2            COPY FS REPLY TO USER
          mov       r8,r1                     r2 = dst = user buffer address
          ai        r1,frtext                 r1 = src = FS reply text
          mov       ujpkt+8(r7),r0            user buffer len is zero?
          jeq       jlb00D                      -> yes, done
          li        r3,44                     len of JFSTAT data block
          cb        ujpkt(r7),vstat
          jne       jlb00E  
          li        r3,56                     len of JVSTAT data block
jlb00E    c         r0,r3                     len <= user buffer len?
          jle       jlb00F                      -> no, ok [??]
          mov       r3,r0                     truncate reply length
jlb00F    mov       r0,ujpkt+10(r7)           r0 = bytes transferred count
          mov       usmb(r7),r3               r3 = user mem bank
          bl        MTU                       copy FS reply to user buffer

jlb00D    mov       r8,r1                     RELEASE FS REPLY
          blwp      BREL$
          b         JSYSE                     -> return with status

.    +----------+----------+
.  0 | JFOSTA   | (stat)   |
.  2 |          | fileno   |
.  4 |       not used      |
.  6 |     buffer addr     |
.  8 |     buffer len      |
. 10 |   (bytes xferred)   |
.    +----------+----------+

jfosta*   bl        SPECIX                    is fileno a special file?
          data      notopn                      -> yes, report as not open [??]
          bl        getfcb                    get FCB for this fileno
          data      notopn                      -> catch file not open

          li        r1,fmrqst+2               BUILD FS REQUEST
          blwp      BGETA$
          data      MEMFUL  
          mov       officode(r2),fmrqst(r1)   add file code to FS request
          mov       r1,r8
          jmp       jlb010                    then handle as JFSTAT

vstat     data      VSTAT$*256

.    +----------+----------+
.  0 | JALLOC   | (stat)   |
.  2 |          | fileno   |
.  4 |     byte len H      |
.  6 |     byte len L      |
.    +----------+----------+

jalloc*   bl        getfcb                    get FCB for fileno
          data      notopn

          li        r1,fmrqst+6               ALLOCATE FS MESSAGE
          blwp      BGETA$                      (3 data words)
          data      MEMFUL  
          mov       r1,r8
          bl        FSBHEA                    fill out std FS request header
          mov       officode(r2),fmrqst(r8)   set file code
          mov       ujpkt+4(r7),fmrqst+2(r8)  set length, high word
          mov       ujpkt+6(r7),fmrqst+4(r8)  set length, low word
          bl        FSEND                     send to FS, wait for reply
          b         fsretn                    -> finish request

.    +----------+----------+
.  0 | JSYNC    | (stat)   |
.    +----------+----------+

jsync*    li        r1,fmrqst                 ALLOCATE FS MESSAGE
          blwp      BGETA$                      (no content, just jsys code)
          data      MEMFUL  
          mov       r1,r8
          bl        FSBHEA                    fill out std FS request header
          bl        FSEND                     send to FS, wait for reply
          b         fsretn                    -> finish request

.    +----------+----------+
.  0 | JCHACC   | (stat)   | also JMOUNT
.  2 | path len |          |
.  4 |      path addr      |
.  6 |    access bits      |  
.    +----------+----------+

jchacc*   equ       $
jmount*   bl        chklen                    is path len > 0 ?
          data      2                         offset of length byte
          li        r0,2                      ALLOCATE FS MESSAGE
          bl        afsmsg                      (header + 2 + path)
          bl        FSBHEA                    fill out std FS request header
          mov       ujpkt+6(r7),fmrqst(r8)    set par 0 = access bits
          bl        FSEND                     send to FS, wait for reply
          b         fsretn                    -> finish request

.    +----------+----------+
.  0 | JCHOWN   | (stat)   | 
.  2 | path len |          |
.  4 |      path addr      |
.  6 |       new gid       |
.  8 |       new uid       |
.    +----------+----------+

jchown*   bl        chklen                    is path len > 0?
          data      2                         offset of length byte
          li        r0,4                      ALLOCATE FS MESSAGE
          bl        afsmsg                      (header + 4 + path)
          bl        FSBHEA                    fill out std FS request header
          mov       ujpkt+6(r7),fmrqst(r8)    set par 0 = new gid
          mov       ujpkt+8(r7),fmrqst+2(r8)  set par 1 = new uid
          bl        FSEND                     send to FS, wait for reply
          b         fsretn                    -> finish request

.    +----------+----------+
.  0 | JASDIR   | (stat)   |
.  2 | path len |          |
.  4 |      path addr      |
.    +----------+----------+

jasdir*   mov       usdefdi(r7),ujpkt+6(r7)   save copy of user's working dir

          movb      ujpkt+2(r7),r0            empty path?
          jeq       jlb011                      -> clear working directory

          clr       r0                        OPEN NEW WORKING DIRECTORY
          bl        afsmsg                    build FS msg + path
          bl        FSBHEA                    fill out std FS request header
          li        r0,open$                  modify type to 'open'
          mov       r0,mbtype(r8)
          bl        FSEND                     send to FS, wait for reply
          clr       usdefdi(r7)               clear user's working directory
          movb      frstat+1(r8),ujpkt+1(r7)  copy FS status, status OK?
          jne       jlb012                      -> no
          mov       frtext(r8),usdefdi(r7)    set user's working directory
jlb012    mov       r8,r1                     release FS reply
          blwp      BREL$

jlb014    mov       ujpkt+6(r7),r2            CLOSE PREVIOUS WORKING DIRECTORY
          jeq       jlb013                    none set? -> done
          li        r1,fmrqst+2               allocate FS msg, one param
          blwp      BGETA$
          data      MEMFUL  
          mov       r2,fmrqst(r1)             file code of previous working dir
          mov       r1,r8
          bl        FSBHEA                    fill out std FS request header
          li        r0,close$                 modify type to 'close'
          mov       r0,mbtype(r8)
          bl        FSEND                     send to FS, wait for reply
          mov       r8,r1                     release reply, ignore FS status
          blwp      BREL$
jlb013    b         JSYSE                     report with status

jlb011    clr       usdefdi(r7)               clear user's working directory
          movb      KSNORM,ujpkt+1(r7)        set OK status
          jmp       jlb014                    -> close working dir (if any)

.    +----------+----------+
.  0 | JSCRIP   | (stat)   |
.  2 | path len |          |
.  4 |      path addr      |
.    +----------+----------+

jscrip*   mov       uscrac(r7),r0             TEST PRE-CONDITIONS
          ci        r0,NXSCRN                 nesting depth  maxed out?
          jhe       jlb015                      -> yes
          bl        chklen                    check name length > 0
          data      2

          clr       r0                        OPEN SCRIPT FILE
          bl        afsmsg                    alocate FS msg and copy path
          bl        FSBHEA                    fill out std FS request header
          li        r0,open$                  set request type to 'open'
          mov       r0,mbtype(r8)
          bl        FSEND                     send to FS, wait for reply       
          movb      frstat+1(r8),ujpkt+1(r7)  copy FS status to reply
          jne       jlb016                      -> catch FS error
          mov       r8,r1
          mov       frtext(r8),r8             save file code in r8
          blwp      BREL$                     release FS message
          
          li        r1,scrl                   ALLOCATE & LINK SCRIPT BLOCK
          blwp      BGETA$                    allocate script block
          data      MEMFUL  
          mov       uscrap(r7),scrlink(r1)    link into user block script list
          mov       r1,uscrap(r7)
          inc       uscrac(r7)                increase current nesting level

          mov       r8,scrficd(r1)            store file code
          clr       scrpos(r1)                start at offset 0 (dword)
          clr       scrpos+2(r1)
          b         JSYSE                     -> report status OK

jlb015    movb      KSMSNS,ujpkt+1(r7)        report script nesting too deep
          b         JSYSE                     -> report with status

jlb016    mov       r8,r1                     report/relay file system error
          blwp      BREL$                     release FS msg
          b         JSYSE                     -> report with status

.    +----------+----------+
.  0 | JPREP    | (stat)   |
.  2 | path len | test flg |
.  4 |      path addr      |
.  6 |  block len or zero  |
.  8 |  block cnt or zero  |
.    +----------+----------+

jprep*    mov       usogid(r7),r0             CHECK SUPER PERMISSIONS
          jne       jlb017                      -> no, not group 0
          mov       usouid(r7),r0
          ci        r0,666                    user id is 666?
          jne       jlb017                      -> no, not user 666
          
          bl        chklen                    path length > 0 ?
          data      2                           report error if not

          li        r0,6                      ALLOCATE FS MESSAGE
          bl        afsmsg                      allocate hdr + 6 + path
          bl        FSBHEA                    fill out std FS header
          movb      ujpkt+3(r7),r0            get 'test data blocks' flag
          srl       r0,8
          mov       r0,fmrqst+4(r8)           set par 2 = test flag
          mov       ujpkt+6(r7),fmrqst(r8)    set par 0 = block len
          mov       ujpkt+8(r7),fmrqst+2(r8)  set par 1 = block count

          bl        FSEND                     send to FS, wait for reply
          b         fsretn                    -> finish request

jlb017    movb      KSPROT,00023(r7)          status protection violation
          b         JSYSE                     -> return with status

.    +----------+----------+
.  0 | JFDUP    | (stat)   |
.  2 |          | (fileno) |  note: fileno is both in and out param
.  4 |     access mode     |
.    +----------+----------+

jfdup*    bl        SPECIX                    fileno is special file?
          data      JSYSEN                      -> yes, report OK
          bl        getfcb                    get FCB for this fileno
          data      notopn                      -> report not open

          li        r1,fmrqst+2               BUILD FS MESSAGE
          blwp      BGETA$                      (with one param)
          data      MEMFUL  
          mov       officode(r2),fmrqst(r1)   set par 0 = file code
          mov       r1,r8
          bl        FSBHEA                    fill out std FS request header
          bl        FSEND                     send to FS, wait for reply

          mov       ujpkt+4(r7),ujpkt+6(r7)   adjust jpkt to match 'open'
          b         lbl009                    -> handle FS reply as for open

.    +----------+----------+
.  0 | JFLOCK   | (stat)   |
.  2 | sub-op   | fileno   |
.    +----------+----------+

jflock*   bl        SPECIX                    is fileno a special file?
          data      JSYSEN                      -> report error
          bl        getfcb                    get FCB for fileno
          data      notopn                      -> report not open

          li        r1,fmrqst+6               ALLOCATE FS MESSAGE
          blwp      BGETA$                      (with 3 data words)
          data      MEMFUL  
          mov       r1,r8
          bl        FSBHEA                    fill out std FS request header
          mov       officode(r2),fmrqst(r8)   set par 0 = file code
          movb      ujpkt+2(r7),r0            set par 1 = sub-op
          srl       r0,8
          mov       r0,fmrqst+2(r8)
          mov       r7,fmrqst+4(r8)           set par 2 = user code
          bl        FSEND                     send to FS, wait for reply
          b         fsretn                    -> finish request

. =============================================================================
. UTILITY ROUTINES
. =============================================================================

. fsbhea: fill out the standard FS message header fields
.
fsbhea*   mov       ujpkt(r7),r0              FILL OUT STD FIELDS
          srl       r0,8
          mov       r0,mbtype(r8)             set msg type to JSYS operation
          mov       r7,r0
          ai        r0,usrplm                 set msg reply queue
          mov       r0,mbrpl(r8)
          mov       usegid(r7),fmgid(r8)      set effective gid
          mov       useuid(r7),fmuid(r8)      set effective uid
          mov       usdefdi(r7),fmdfdi(r8)    set working dir inode
          rt

. afsmsg: allocate FS message with space for path
.   input: r0 = extra bytes, r7 = user block ptr
.   output: r8 = FS msg ptr
.
afsmsg    mov       ujpkt+2(r7),r1            ALLOCATE FS MESSAGE
          srl       r1,8                      get length
          mov       r1,r3
          a         r0,r1                     add in extra bytes
          ai        r1,18                     add in msg header length + 2
          blwp      BGETA$                    allocate msg
          data      MEMFUL  
          mov       r1,r8
          ai        r0,fmrqst
          a         r0,r1                     r1 = length param ptr
          mov       r3,*r1+                   store path length in param 0
          mov       r3,r0                     r0 = len
          mov       r1,r2                     r2 = msg text ptr
          mov       usmb(r7),r3               r3 = user memory bank
          mov       ujpkt+4(r7),r1            r1 = path ptr in user space
          b         MFU                       copy path from user space to msg

. fsend: send the FS msg and wait for reply
.
fsend*    li        r9,FSMSGQ                 place msg on FS input queue
          blwp      INSERT
          li        r0,FSWORK                 signal new work added
          blwp      V$

          mov       r7,r0                     wait for reply to arrive
          ai        r0,usrpld
          blwp      P$

          mov       r7,r9                     fetch & unlink reply
          ai        r9,usrplm
          blwp      REMOVE
          rt

. getfcb: find the file control block for the handle
.
getfcb    movb      ujpkt+3(r7),r0            turn handle into index
          srl       r0,8
          ai        r0,-3                     handle < 3?
          jlt       jlb018                      -> yes, error
          ci        r0,MXOF                   index > MXOF?
          jhe       jlb018                      -> yes, error
          mpy       lbl010,r0                 turn index into offset
          mov       r7,r2                     and offset into ptr
          ai        r2,usoft
          a         r1,r2
          mov       officode(r2),r0           handle is open file?
          jeq       jlb018                      -> no, error
          b         2(r11)                    normal return, FCB ptr in r2
          
jlb018    mov       *r11,r11                  return via error path
          rt        

lbl010    data      ofl

. newfcb: find file handle for file
.
newfcb    mov       r7,r2                     SCAN OPEN FILE TABLE
          ai        r2,usoft
          li        r0,3                      handle # starts at 3!
          li        r1,MXOF
jlb01a    mov       officode(r2),r3           slot unused?
          jeq       jlb019                      -> yes
          inc       r0                        try next slot / handle #
          ai        r2,ofl
          dec       r1                        past last slot?
          jne       jlb01A                      -> no, try next
          mov       *r11,r11                  take error return
          rt

jlb019    swpb      r0                        store file handle in jpkt
          movb      r0,ujpkt+3(r7)
          b         2(r11)                    normal return

. calspv: call special device service routine
.
calspv    mov       spnvec(r2),r1             fetch special device vector
          a         *r11,r1                   add requested offset
          mov       *r1,r1                    dev routine ptr is no-op?
          jeq       jlb01B                      -> yes, ignore
          mov       spnfct(r2),r6             setup file control tab in r6
          b         *r1                       call service routine
  
jlb01b    b         JSYSEN

. chklen: check length byte in jpkt at given offset.
.   input: offset is in word following BL call
.
chklen    mov       *r11+,r0                  fetch offset
          a         r7,r0                     calc ptr to len byte
          ai        r0,ujpkt
          movb      *r0,r0                    length is zero?
          jeq       jlb01C                      -> yes, reject
          rt

jlb01c    movb      KSSYNT,00023(r7)          report name syntax error
          b         JSYSE

. =============================================================================
. SYNCINIT: RUN THE BACKGROUND FS AUTO-SYNC PROCESS
. =============================================================================

syncin*   li        r9,lbl011                 INIT MSG QUEUES
          blwp      INITQ$                    init reply mesg queue
          li        r9,lbl012
          blwp      INITQ$                    init reply semaphore
          clr       qn(r9)

jlb01d    li        r0,SYNCTM                 WAIT FOR NEXT SYNC
          blwp      D$ELAY

          li        r1,fmrqst                 ALLOCATE FS SYNC MESSAGE
          blwp      BGETA$
          data      MEMFUL  
          mov       r1,r8
          li        r0,sync$                  set type to 'sync'
          mov       r0,mbtype(r8)
          li        r0,lbl011                 set reply queue
          mov       r0,mbrpl(r8)
          clr       fmgid(r8)                 set gid/uid = (0,0)
          clr       fmuid(r8)
          clr       fmdfdi(r8)                set file code = 0

          li        r9,FSMSGQ                 SEND MSG TO FS
          blwp      INSERT
          li        r0,FSWORK
          blwp      V$

          li        r0,lbl012                 WAIT FOR AND DISCARD FS REPLY
          blwp      P$                        yield-wait for reply
          li        r9,lbl011                 unlink reply
          blwp      REMOVE
          mov       r8,r1                     release reply
          blwp      BREL$
          jmp       jlb01D                    and go wait for next sync
.
lbl011    bss       4                         reply queue
lbl012    bss       6                         reply queue semaphore
.
          end        
.