.
. Reconstructed source code of NOS/MT
.
.   Original code by John Walker / Dan Drake, ca. 1980
.   Disassembly tool by Peter Buro, 1986
.
          idt       "RTSCHED"
.
          copy      "../systemdef/sysdef"
.
          bss       2                         ??
          
initab    data      SINIT                     init routine in boot.asm
.
init*     limi      0                         <= NOS/MT KERNEL STARTS HERE
          lwpi      INTREG                    use intreg[0] as WP

          clr       wtlst1                    clear timeout lists and counter
          clr       wtlst2
          clr       tckctr
          clr       UCLOCK                    clear system clock
          clr       UCLOCK+2
          clr       secctr                    clear seconds counter
          clr       slcctr                    clear time slice counter

          li        r9,READYQ                 INIT ALL 6 READY QUEUES           
jlb000    blwp      INITQ$                    (one per priority level)
          ai        r9,ql
          ci        r9,RDYQE
          jl        jlb000  

          clr       r0                        SET UP INTERRUPT TABLE IN LOW MEM
          li        r1,INTREG                 start at first interrupt WP
          li        r2,INTRPT                 address of generic int routine
          li        r3,INTSVL                 number of interrupts to init
          li        r4,INTSVT                 start at first configured vector        
jlb001    mov       r1,*r0+                   set up WP word
          mov       r2,*r0+                   sec up PC word
          mov       *r4+,2*r12(r1)            preset r12 in WP to int vector
          ai        r1,32                     next interrupt WP
          dec       r3                        more int vectors to init?
          jne       jlb001                      -> yes

          li        r0,initab                 CALL INIT ROUTINES
          li        r1,1                      currently just 1 defined
          li        r2,INTREG                 save tab & cnt in intreg[1]
          mov       r0,32+2*r0(r2)
          mov       r1,32+2*r1(r2)
          seto      ACTPRI                    run at max priority
          clr       ACTIVE                    no active process
          seto      ininit                    set "in init" flag
          clr       ACTIVE                    no active process [?? duplicate]
jlb002    li        r2,INTREG
          mov       32+2*r0(r2),r0            get initab ptr
          mov       *r0+,r1                   get next init routine
          mov       r0,32+2*r0(r2)            put updated initab ptr back
          bl        *r1                       call the init routine
          li        r2,INTREG
          dec       32+2*r1(r2)               more init routines to call?
          jne       jlb002                      -> call next
          clr       ininit                    clear "in init" flag
          b         reschd                    -> START SCHEDULING

. SCHEDULER ALGORITHM
.
.   each process has an allocated process header,
.     created with FORK$, released with EXIT$
.   max one process is active, held in variable 'ACTIVE'
.   other runnable processes are held in a ready queue
.     (actually 6 queues, one for each priority level)
.   non-runnable processes are held on some other list:
.     a. the wait list of a semaphore (see P$, V$ operations)
.     b. the wait list for sleeping (see D$ELAY)
.   processes run round-robin within each priority
.   user processes have 'time slice affinity', with users
.     'owning' the slice in round-robin fashion


. FORK$: create new process
.   input: caller r0 = process initial PC
.                 r1 = process local space size
.                 r2 = process priority
.
rtsfork   limi      0
          mov       2*r1(r13),r1              ALLOCATE PROCESS HEADER
          ai        r1,phls                   proc header size + local space
          blwp      BGETA$
          data      MEMFUL

          mov       2*r2(r13),phprior(r1)     INITIALISE NEW HEADER
          mov       r15,phstat(r1)            copy status, but do limi 15
          soc       limi15,phstat(r1)
          mov       *r13,phpc(r1)             set process PC
          mov       r13,r0
          mov       r1,r2                     set default process WP
          ai        r2,phregs
          mov       r2,phws(r1)
          li        r3,8                      copy WS (unrolled once)
jlb003    mov       *r0+,*r2+
          mov       *r0+,*r2+
          dec       r3
          jne       jlb003

          mov       ininit,r0                 called from init routines?
          jeq       switch                      -> no, switch to new proc
          bl        mkrdy                     else just place it on its ready
          rtwp                                  queue and return

.
. SWITCH
.   Switch to a new process, if the new process is higher priority than
.   the current one. If not, place it on the ready queues.
.
switch    mov       ACTIVE,r9                 SWITCH TO PROCESS IN R1
          jeq       jlb005                    any active process? -> no

          mov       r14,phpc(r9)              SAVE ACTIVE PROC CPU STATE
          mov       r13,phws(r9)
          mov       r15,phstat(r9)
          c         ACTPRI,phprior(r1)        new process has higher prio?
          jhe       jlb006                      -> no, stay with current

jlb005    mov       r1,ACTIVE                 MAKE NEW PROC THE ACTIVE PROC
          mov       phprior(r1),ACTPRI
          mov       r9,r1                     previously any process active?
          jeq       jlb007                      -> no

jlb006    mov       phprior(r1),r9            PLACE PREVIOUS ACTIVE ON READY Q
          dec       r9                        find ready queue for this prio
          a         r9,r9
          a         r9,r9
          ai        r9,READYQ
          mov       r1,r8                     add process to back of queue
          blwp      INSERT

jlb007    mov       ACTIVE,r1                 LOAD NEW PROC'S CPU STATE
          mov       phpc(r1),r14
          mov       phstat(r1),r15
          mov       phws(r1),r13
          clr       USRACT                    clear user process flag
          c         phprior(r1),usrpri        is new active proc a user proc?
          jne       jlb008                      -> no, just use context switch
          b         ULAUNC                    else swap mem bank, then switch

jlb008    rtwp      

usrpri    data      pruser                    user priority level
limi15    data      0F                        bit pattern for interupt mask 15

.
. EXIT$
.   Exits a process started with FORK. Do not use on processes that
.   were created from static allocations (e.g. user handlers & processes)
.
rtsexit   limi      0                         RELEASE CURRENT PROC CTRL BLOCK
          mov       ACTIVE,r1                   and schedule another process
          blwp      BREL$


. RESCHEDULE: PICK A NEW PROCESS TO RUN
.   clear current process ptr/prio
.   find highest prio runnable ('ready') process
.   for user processes, prefer the user 'owning' the current time slice
.   if none found, enter an idle loop
.   otherwise, switch to the new process
.
reschd    clr       ACTIVE                    DO RESCHEDULE
          seto      ACTPRI                    no current process
          li        r9,RDYQE                  walk ready queue back to front
          ai        r9,-ql                      (highest priority first)
jlb00A    c         *r9,r9                    current prio ready queue empty?
          jne       jlb009                      -> no, go switch
          ai        r9,-ql                    move to next prio ready queue
          ci        r9,READYQ                 moved past lowest priority?
          jhe       jlb00A                      -> no, test this ready queue

          seto      idlflg                    set idle flag
          limi      15                        wait for interrupt to reschedule
jlb00B    idle      
          jmp       jlb00B                    no resched? -> idle some more

jlb009    mov       qfl(r9),r8                FETCH FIRST PROCESS ON QUEUE
          c         phprior(r8),usrpri        is this a user process?
          jne       jlb00C                      -> no, switch to process
          c         phuuct(r8),slcown         first belongs to 'slice owner'?
          jeq       jlb00C                      -> yes

          mov       r8,r1                     FIND A PROCESS OF SLICE OWNER
jlb00D    mov       qfl(r1),r1                look at next proc in this ready q
          c         r1,r9                     we're back to the first?
          jeq       jlb00C                     -> yes, use that one then
          c         slcown,phuuct(r1)         found one?
          jne       jlb00D                      -> no, try next
          mov       qhl(r1),r9                then take this one from the queue

jlb00C    blwp      REMOVE                    remove process from ready q
          mov       r8,r1
          jmp       switch                    -> run this process

.
. P$: test semaphore
.
rtsp      limi      0                         TEST SEMAPHORE
          mov       *r13,r9                   get semaphore  from caller WP               
          dec       qn(r9)                    test semaphore
          jlt       jlb00E                      -> negative, put on wait queue 
          rtwp                                pass: return (& leave critical)

jlb00E    mov       ACTIVE,r8                 PUT ON WAIT LIST
          mov       r14,phpc(r8)              save caller PC
          mov       r13,phws(r8)              save caller WP
          mov       r15,phstat(r8)            save caller ST
          blwp      INSERT                    put proc on semaphore wait list
          b         reschd                    -> schedule a ready process

.
. V$: increase semaphore
.
rtsv      limi      0                         INCREASE SEMAPHORE
          mov       *r13,r9                   get semaphore from caller WP
          inc       qn(r9)                    increase semaphore
          jlt       jlb00F                    any processes waiting?               
          jeq       jlb00F                      -> yes, switch to it
          rtwp                                return (& leave critical)

jlb00F    blwp      REMOVE                    unlink first waiting process
          mov       r8,r1
          b         switch                    -> and switch to it

.
. PMAY$: do non-blocking test of semaphore
.
rtspmay   limi      0                         TEST SEMAPHORE
          andi      r15,0DFFF                 clear caller EQ bit
          mov       *r13,r9
          mov       qn(r9),r0                 will semaphore block?
          jgt       jlb010                      -> no, complete P$ call
          ori       r15,02000                 set caller EQ bit = failure
          rtwp                                return, reporting failure
          
jlb010    dec       qn(r9)                    perform P$ operation
          rtwp                                return, reporting success

.
. D$ELAY: wait for r0 ticks before resuming
.
timout    equ       qfl                       store timeout time in qfl field          

rtsdel    limi      0                         WAIT PROCESS FOR R0 TICKS
          li        r2,wtlst1                 load head of waitlist
          mov       *r13,r0                   fetch wait time
          a         tckctr,r0                 calc timeout time
          jnc       jlb011                    after current time rollover?
          li        r2,wtlst2                   -> yes, use next waitlist

jlb011    mov       ACTIVE,r1                 FIND POSITION ON WAIT LIST
          mov       r0,timout(r1)             store timeout
jlb014    mov       *r2,r3                    link field using qhl field, in
          jeq       jlb012                      increasing timeout order
          c         r0,timout(r3)
          jh        jlb013

jlb012    mov       r3,*r1                    LINK PROCESS INTO WAIT CHAIN
          mov       r1,*r2                      using qhl field
          mov       r14,phpc(r1)              save CPU registers
          mov       r13,phws(r1)
          mov       r15,phstat(r1)
          b         reschd                    -> reschedule ready process

jlb013    mov       r3,r2                     MOVE TO NEXT ON CHAIN
          jmp       jlb014                    -> and test again

.
. TICK$: handle a clock tick
.
rtstic    inc       tckctr                    UPDATE TICK COUNTER
          jnc       jlb015                    rolling over?
          mov       wtlst2,wtlst1             switch next wait list to current
          clr       wtlst2                    and reset next rollover waitlist

jlb015    inc       TKTOT                     UPDATE TICK ACCOUNTING
          mov       ACTIVE,r8                 any process running? 
          jeq       jlb016                      -> no
          inc       TKSYSA                    increase system ticks
jlb016    mov       INTUSR,r8                 interrupted user process?
          jeq       jlb017                      -> no
          inc       TKUSER                    increase user ticks

jlb017    dec       secctr                    UPDATE UCLOCK
          jgt       jlb018                    one second has passed? -> no
          li        r0,TICKSE                 reset second counter
          mov       r0,secctr
          inc       UCLOCK+2                  move system clock to next second
          jnc       jlb018  
          inc       UCLOCK

jlb018    dec       slcctr                    CHECK TIME SLICE
          jgt       jlb019                    time slice expired? -> no
          li        r0,TICKSL                 reset time slice counter
          mov       r0,slcctr

          mov       slcown,r8                 GIVE NEW SLICE TO NEXT USER PROC
jlb01B    ai        r8,USL                    check users in round-robin way
          ci        r8,UCTE
          jl        jlb01A  
          li        r8,UCTS
jlb01A    c         r8,slcown                 checked all other users?
          jeq       jlb019                      -> yes, stay with current
          mov       usnactp(r8),r0            next user has active process?
          jeq       jlb01B                      -> no, check next one
          mov       r8,slcown                 set user as 'slice owner'

jlb019    mov       wtlst1,r1                 CHECK TIME-WAIT PROCESSES
          jeq       jlb01C                      -> no more, done
          c         tckctr,timout(r1)         timeout reached?
          jne       jlb01C                      -> no, done
          mov       *r1,wtlst1                make all timed out proc's
          bl        mkrdy                       ready to run
          jmp       jlb019

jlb01C    rtwp      

.
. VINT$: perform V$ operation from JSYS trap context
.   called at limi 0, with caller r0 = 'ushwork' semaphore
.
rtsvint   mov       *r13,r9                   fetch semaphore
          inc       qn(r9)                    do V$
          jlt       jlb01D                    any P$ pending?
          jeq       jlb01D                      -> yes, make ready
          rtwp                                no, just return

jlb01D    blwp      REMOVE                    unlink user handler process
          mov       r8,r1
          bl        mkrdy                     and make it ready
          rtwp                                return
.
. Make the process in r1 ready; switch with current if higher prio
.
mkrdy     mov       phprior(r1),r9            get priority
          dec       r9                        find ready q for this priority
          a         r9,r9
          a         r9,r9
          ai        r9,READYQ
          mov       r1,r8                     place on this ready q
          blwp      INSERT
          clr       idlflg                    clear idle flag
          c         phprior(r1),ACTPRI        priority higher than current?
          jle       jlb01E                      -> no, done

          mov       ACTIVE,r1                 SET CURRENT FROM ACTIVE TO READY
          clr       ACTIVE
          mov       2*r14(r13),phpc(r1)       save current CPU state
          mov       2*r13(r13),phws(r1)
          mov       2*r15(r13),phstat(r1)
          seto      ACTPRI                    forces return after queuing
          jmp       mkrdy                     put current proc on ready queue

jlb01E    rt

. ENDIN$: end interrupt
.   for a JSYS interrupt it will reschedule to the handler process
.
endin$*   mov       ACTIVE,r0                 any process running?                
          jne       jlb01F                      -> yes, return
          mov       idlflg,r0                 system was idle?
          jne       jlb01F                      -> yes, return
          b         reschd                    RESCHEDULE

jlb01F    rtwp

.
. SCHEDULER ENTRY VECTORS
.
FORK$*    data      schreg  
          data      rtsfork 
EXIT$*    data      schreg  
          data      rtsexit 
P$*       data      schreg  
          data      rtsp    
V$*       data      schreg  
          data      rtsv    
PMAY$*    data      schreg  
          data      rtspmay 
D$ELAY*   data      schreg  
          data      rtsdel  
TICK$*    data      schreg  
          data      rtstic  
VINT$*    data      schreg  
          data      rtsvint 
.
.
ACTIVE*   bss       2                         currently active process or NULL
ACTPRI*   bss       2                         current proc priority
ininit    bss       2                         non-zero when in init code
idlflg    bss       2                         non-zero when in idle loop
wtlst1    bss       2                         current wait list for sleep
wtlst2    bss       2                         wait list post roll-over
tckctr    bss       2                         tick counter for sleep
UCLOCK*   bss       4                         system time (32 bit unsigned)
secctr    bss       2                         tick counter for seconds
slcctr    bss       2                         tick counter for time slices
slcown    data      UCTS                      user 'owning' current time slice
TKTOT*    bss       2                         total ticks
TKSYSA*   bss       2                         system ticks
TKUSER*   bss       2                         user ticks
.
          end       init
.
