/*      cok.c
 *	keyboard driver part of co.c for 84 key keyboard
 *
 *	(c) Szigeti Szabolcs 1992
 */

#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\proc.h"
#include "h\machine.h"
#include "h\co.h"
#include "h\systm.h"

#include "h\tty.h"

extern	struct tty coat;
extern int video;
static byte km_next,km_flag; 	/* tobb bytos parancs tovabbi byte 	*/
static byte km_break;		/* a kovetkezo kod break		*/
static byte km_sh,km_ash,km_lsh;
static byte locks=0;
char *esctab[]={
	"[A",		/* up	*/
	"[B",           /* down	*/
	"[C",		/* right*/
	"[D",		/* left	*/
	"[0;0H"		/* home */
	};

byte	scantab[3][8*16]=
	{
	{
/* normal 0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f  */

/*  0 */  0, 27,'1','2','3','4','5','6','7','8','9','0','-','=',  8,  9,
/* 10 */'q','w','e','r','t','y','u','i','o','p','[',']', 13,  0,'a','s',
/* 20 */'d','f','g','h','j','k','l',';', 94,'`',  0, 92,'z','x','c','v',
/* 30 */'b','n','m',',','.','/',  0,  0,  0,' ',  0,  0,  0,  0,  0,  0,
/* 40 */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 50 */  0,  0,  0,127,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 60 */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 70 */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0

	},
	{
/* shift  0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f  */

/*  0 */  0, 27,'!','@','#','$','%','^','&','*','(',')','_','+',  8,  9,
/* 10 */'Q','W','E','R','T','Y','U','I','O','P','{','}', 13,  0,'A','S',
/* 20 */'D','F','G','H','J','K','L',':', 34,'~',  0, 92,'Z','X','C','V',
/* 30 */'B','N','M','<','>','?',  0,  0,  0,' ',  0,  0,  0,  0,  0,  0,
/* 40 */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 50 */  0,  0,  0,127,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 60 */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 70 */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0

	},
	{
/* caps   0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f  */

/*  0 */  0, 27,'1','2','3','4','5','6','7','8','9','0','-','=',  8,  9,
/* 10 */'Q','W','E','R','T','Y','U','I','O','P','[',']', 13,  0,'A','S',
/* 20 */'D','F','G','H','J','K','L',';', 94,'`',  0, 92,'Z','X','C','V',
/* 30 */'B','N','M',',','.','/',  0,  0,  0,' ',  0,  0,  0,  0,  0,  0,
/* 40 */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 50 */  0,  0,  0,127,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 60 */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 70 */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0

	}
	};
extern struct clist prob,cfreelist;
waitcon()
	{
	while(inbyte(KBCTL)&KR_IBF) asm {nop; nop; nop; nop;}
	}

/*	t_coint():
		billentyuzet interrupt 					*/
corint()
	{
	static byte sc,ks;		/* scan code,status	*/
	lock();
	intack1();

	ks=inbyte(KBCTL);

	if (!(ks&KR_OBF))
		goto OUT;

	sc=inbyte(KBDAT);

/************************************************************************/
/*		DEBUG	DEBUG	DEBUG	DEBUG	DEBUG			*/
/*									*/
	if (sc==1&& (km_sh&8))	/* shift-ESC ==> reboot ( no sync!!!!!)	*/
		{
		asm cli;
		closedevices();
		}
/*    		DEBUG	DEBUG	DEBUG	DEBUG	DEBUG			*/
/************************************************************************/
	km_break=sc>127;
	sc&=127;

	switch	(sc)
		{
		case 0xfa:	if(km_flag)
					{
					km_flag=0;
					outbyte(KBDAT,km_next);
					}
                                break;
		case 0x3a:
				if (km_break) locks &= ~4;
					else

				if (!(locks & 4))
					{
					locks |= 4;
					km_sh ^= 4;
					}
				break;
		case 0x45:
				if (km_break) locks &= ~2;
					else

				if (!(locks & 2))
					{
					locks |= 2;
					km_sh ^= 2;
					}
				break;

		case 0x46:
				if (km_break) locks &= ~8;
					else

				if (!(locks & 8))
					{
					locks |= 8;
					coat.t_state^=STOP;
					if ((coat.t_state&STOP)==0)
						wakeup((int)&coat.t_outq);
					}
				break;

		case 0x2a:      if (km_break)	{km_break=0;km_ash&=~1;}
				else            {km_ash|=1;}
				if (km_ash&9)	{km_sh|=8;}
                                else		{km_sh&=~8;}
				break;
		case 0x36:      if (km_break)	{km_break=0;km_ash&=~8;}
				else            {km_ash|=8;}
				if (km_ash&9)	{km_sh|=8;}
                                else		{km_sh&=~8;}
				break;

		case 0x1d:	if (km_break)	{km_break=0;km_ash&=~2;}
				else            {km_ash|=2;}
				if (km_ash&18)	{km_sh|=16;}
				else		{km_sh&=~16;}
				break;
	      /*case SC_RCTR:	if (km_break)	{km_break=0;km_ash&=~16;}
				else            {km_ash|=16;}
				if (km_ash&18)	{km_sh|=16;}
				else		{km_sh&=~16;}
				break;

		case SC_LALT:   if (km_break)	{km_break=0;km_ash&=~4;}
				else            {km_ash|=4;}
				if (km_ash&36)	{km_sh|=32;}
				else		{km_sh&=~32;}
				break;
		case SC_RALT:   if (km_break)	{km_break=0;km_ash&=~32;}
				else            {km_ash|=32;}
				if (km_ash&36)	{km_sh|=32;}
				else		{km_sh&=~32;}
				break;       */

		default:       /*
				if (sc>127)
					ttyinput('#',&coat);
				ttyinput(sc,&coat);
				*/
				if (km_break) break;
				if (!(km_sh&12)) 	/* normal */
					sc=scantab[0][sc];
				else
					if (km_sh&8) 	/* shift */
						sc=scantab[1][sc];
					else            /* caps lock */
						sc=scantab[2][sc];

				if (!sc) goto OUT; 	/* ervenytelen */
				if (sc==127) sc=0;
				if ((km_sh&16)&&(sc>63))
					{
					sc&=95;
					sc-=64;		/* controll */
					}
				ttyinput(sc,&coat);
		}

	if (coat.t_state&STOP)
		km_sh|=1;
	else
		km_sh&=~1;

	if (km_sh!=km_lsh)
		{
		km_flag=1; km_next=km_sh&7;
		outbyte (KBDAT,0xed);	/* set LEDS */
		km_lsh=km_sh;
		}
OUT:	enable();


	}


initcon()
	{
	initkeyb();
	initvid();

	}

initkeyb()
	{
	}
closecon()
	{
	closekeyb();
	closevid();
	}
closekeyb()
	{
	}
