COMMENT	@
	## COOMON.INC ##
	(c) Szigeti Szabolcs	1992 jan 28.

	Kulonbozo konstansok definicioja az alacsonyszintu
	assembly rutinok szamara.
	Figyelem: ha itt valtoztatunk, akkor altalaban a 
	megfelelo C .h file-ban is meg kell tenni a valtoztatast
	kulonben totalis kaosz lesz.
@

;***********************************************************
.286p
NPROC		EQU	50	;Processzek max szama


;***********************************************************

CDS_DESC	STRUC		;code data & system seg. descriptor
	
	CD_LENGTH	DW	?
	CD_BASE_LOW	DW	?
	CD_BASE_HIGH	DB	?
	CD_RIGHTS	DB	?
	CD_RESERVED	DW	0
		
	ENDS
	
GDT_DESC	STRUC		;global & intr. desc. table
	
	GL_LIMIT	DW	?
	GL_BASE_LOW	DW	?
	GL_BASE_HIGH	DB	?
	GL_RESERVED	DB	0
	
	ENDS
GAT_DESC	STRUC		;gate descriptor
	GD_OFFSET	DW	?
	GD_SELECT	DW	?
	GD_WCOUNT	DB	?
	GD_TYPE		DB	?
	GD_RESERVED	DW	0
	
	ENDS
TSS		STRUC		;task state segment
	TSS_BLINK	DW	?
	TSS_SP0		DW	?
	TSS_SS0		DW	?
	TSS_SP1		DW	?
	TSS_SS1		DW	?
	TSS_SP2		DW	?
	TSS_SS2		DW	?
	TSS_IP		DW	?
	TSS_FLAG	DW	?
	TSS_AX		DW	?
	TSS_CX		DW	?
	TSS_DX		DW	?
	TSS_BX		DW	?
	TSS_SP		DW	?
	TSS_BP		DW	?
	TSS_SI		DW	?
	TSS_DI		DW	?
	TSS_ES		DW	?
	TSS_CS		DW	?
	TSS_SS		DW	?
	TSS_DS		DW	?
	TSS_LDT		DW	?
	
	ENDS
cblock		struc
	c_next		DW      ?
	info		db 6 dup (?)
	ends
clist		struc
	c_cc		dw ?
	c_cf		dw ?
	c_cl		dw ?
	ends
;***************************************
;********symbolic constants*************
;***************************************

ACC_PRES	EQU	10000000B	;segment in memory
ACC_DPL0	EQU	00000000B	;DPL=0
ACC_DPL1	EQU	00100000B	;DPL=1
ACC_DPL2	EQU	01000000B	;DPL=2
ACC_DPL3	EQU	01100000B	;DPL=3
ACC_DATA	EQU	00010000B	;code or data segment
ACC_EXEC	EQU	00001000B	;executable
ACC_CONF	EQU	00000100B	;conforming
ACC_READ	EQU	00000010B	;may be read
ACC_ACC		EQU	00000001B	;accesed
ACC_DOWN	EQU	00000100B	;expand down
ACC_WRIT	EQU	00000010B	;writeable

SYS_ATSS	EQU	00000001B	;available task state segment
SYS_LDS		EQU	00000010B	;local desc. table
SYS_BTSS	EQU	00000011B	;busy task state segment
SYS_PRES	EQU	10000000B	;present
SYS_DPL0	EQU	00000000B
SYS_DPL1	EQU	00100000B
SYS_DPL2	EQU	01000000B
SYS_DPL3	EQU	01100000B

;***************************************
;*************macros********************
;***************************************

FJM		MACRO	SLCTR,OFFST     ;Far Jump masik szelektorba
		DB	0EAH		;Far Jmp kodja es a cim
		DW	OFFSET OFFST    ;directbe beirva
		DW	SLCTR
		ENDM

FCAL		MACRO	SLCTR           ;Far Call masik szelektorba
		DB	09AH		;Far Call
		DW	0;
		DW	SLCTR
		ENDM
		


FILL_DESC	MACRO	DESCR,SEG,OFFS  ;Deszkriptor kitolto makro
		MOV	BX,OFFSET DESCR ;feltetelezi hogy ES a deszkriptor
		MOV	AX,OFFSET OFFS  ;tabla szegmenset tartalmazza
		MOV	DX,SEG
		MOV	CX,DX           ;Alapveto mukodese:
		SHR	CX,12		;a REAL modu SEG:OFFSET cimbol
		SHL	DX,4		;valodi 24 bites cimet szamit
					;es azt beirja a megfelelo
		ADD	AX,DX		;deszkriptor tagba.
		ADC	CX,0
		MOV	ES:[BX].CD_BASE_LOW,AX
		MOV	ES:[BX].CD_BASE_HIGH,CL
		ENDM

FILL_GLOB	MACRO	DESCR,SEG,OFFS  ;Globalis Deszkriptor kitolto makro
		MOV	BX,OFFSET DESCR ;feltetelezi hogy ES a globalis
		MOV	AX,OFFSET OFFS  ;deszkriptorok (IDT,GDT) szegmenset
		MOV	DX,SEG		;tartalmazza
		MOV	CX,DX
		SHR	CX,12		;Mukodeset lasd feljebb
		SHL	DX,4
		ADD	AX,DX
		ADC	CX,0
		MOV	ES:[BX].GL_BASE_LOW,AX
		MOV	ES:[BX].GL_BASE_HIGH,CL
		ENDM
