/*
 *	file.h
 *
 *	definition of the file structure
 */

struct file
	{
	char 	f_flag;		/*	see below		*/
	char	f_count;	/*	use count of file	*/
	struct  inode *f_inode;	/*	corresponding inode 	*/
	offs_t	f_offset;	/*	current offset		*/
	};

#define FREAD	1
#define FWRITE	2
#define FPIPE	4

struct file *getf(int);
void closef (struct file*);

int ufalloc(void);
struct file *falloc(void);

void readp (struct file*);
void writep(struct file*);