/*
 *	systm.h
 */

extern time_t time,tout;	/* realtime and timeout	*/
extern int lbolt;

extern int runrun;		/* rescheduling needed	*/
extern int runin,runout;	/* swapin & swapout	*/
extern char curpri;
extern int lastmode;		/* kernel || user mode	*/

extern  int kcode,kdata;
extern	struct sys_desc	*gdt_beg;
extern 	struct sys_desc *idt_beg;
extern	struct tss *hint0_tss;	/* A 0. hard int tss 	*/

extern int nchrdev,nblkdev;	/* no of c and b devs	*/
extern dev_t rootdev,swapdev;	/* root & swap[ device	*/

extern word mpid;		/* next assignable pid	*/

extern char kstack[NPROC][KSSIZ]; /* kernel level stack	*/

byte inbyte (int port);
void outbyte (int port,byte data);
word inword (int port);
void outword (int port,word data);

int fubyte (word addr);
int subyte (word addr,byte data);
int fuword (word addr);
int suword (word addr,word data);

int cpass(void);
int passc(char data);

int copyin (void *from,void *to,word count);
int copyout(void *from,void *to,word count);

void bcopy (void* from,void* to ,word count);
int  estabur (word,word,word,struct proc*);
word clearseg (gaddr_t addr,word length);
word copyseg(dword from,dword to ,word length);

void ldtfil (int,dword,struct proc*);
void fill_desc (word number,word seg86,word offset);

void savu  (word*);
void aretu (word*);

int suser(void);

void psignal (struct proc* process,int signal);

void update (void);

void sleep (int chan,int priority);
void wakeup (int chan);
void setrun (struct proc* process);
void swtch (void);

void setpri (struct proc* process);

int issig (void);
void psig (int signal);

void printf (char * format, ...);
void prdev (char* message,dev_t device);
void deverr (struct buf* buffer,int data1,int data2);

void panic (char* message);
void reboot (void);

word lock1 (void);
void unlock (word);

void initdevices (void);
void closedevices(void);

void iinit(void);
void cinit(void);
void binit(void);
void sched(void);
