/*
 * user.h
 * definition of the user structure
 *	(c) Szigeti Szabolcs	1992 maj 21.
 *
 * Every process has a user struct, which stores process data
 * not needed when proc is not runnable
 * This should be swapped out with the process
 */

struct user
	{
	int	u_rv;
	int	u_aux[6];
	uid_t	u_uid;			/* effective user id	*/
	gid_t	u_gid;			/* effective group id	*/
	uid_t	u_ruid;			/* real user id		*/
	gid_t	u_rgid;			/* real group id	*/

	word	u_utime;		/* user time		*/
	word	u_stime;		/* system time		*/
	dword	u_cutime;		/* above for child proc */
	dword	u_cstime;

	word	u_umask;		/* creat mask		*/
	char	u_segflg;		/* kernel or user IO	*/
	char 	u_intflg;		/* inerrupted syscall	*/

	caddr_t	u_base;			/* IO base		*/
	word	u_count;		/* IO counter		*/
	offs_t	u_offset;		/* seek position		*/

	struct inode *u_cdir;		/* cwd inode		*/
	char	u_dbuf[DIRSIZ];		/* path	buffer		*/
	char	*u_dirp; 		/* current dir entry	*/
	struct  {
		int u_ino;
		char u_name[DIRSIZ];
		}
		u_dent;			/* dir entry for namei	*/
	struct inode *u_pdir;		/* 			*/
	struct file *u_ofile[NOFILE];	/* open files	 	*/

	char 	u_error;		/* syscall error code	*/
	word	u_signal[NSIG];		/* signal handlers	*/

	word	u_prof[4];		/* profiling regs	*/

	word	u_tsize;		/* text size		*/
	word	u_dsize;		/* data size		*/
	word	u_ssize;		/* stack siz		*/
	word	u_sep;			/* separate i & d mem	*/
	word	u_qsav[2];		/* interrupt return	*/
	word	u_ssav[2];
/*	struct {         */		/* 287 internal state	*/
/*		word   f_cr;
		word   f_sr;
		word   f_tr;
		dword  f_ip;
		dword  f_op;
		long double f_r[8];
	       } u_fpu;*/
	};

extern struct user user[];	/* the user struct table	*/
extern struct user *u;		/* ptr to the current u struct	*/

/* u_error codes */

#define EFAULT  106
#define EPERM   1
#define ENOENT  2
#define ESRCH   3
#define EINTR   4
#define EIO     5
#define ENXIO   6
#define E2BIG   7
#define ENOEXEC 8
#define EBADF   9
#define ECHILD  10
#define EAGAIN  11
#define ENOMEM  12
#define EACCES  13
#define ENOTBLK 15
#define EBUSY   16
#define EEXIST  17
#define EXDEV   18
#define ENODEV  19
#define ENOTDIR 20
#define EISDIR  21
#define EINVAL  22
#define ENFILE  23
#define EMFILE  24
#define ENOTTY  25
#define ETXTBSY 26
#define EFBIG   27
#define ENOSPC  28
#define ESPIPE  29
#define EROFS   30
#define EMLINK  31
#define EPIPE   32

