COMMENT @
	## DESC.ASM ##
	(c) Szigeti Szabolcs	1992 jan 28.

	Ez a file tartalmazza a protected modu mukodeshez
	szukseges globalis es interrupt deszkriptor tablat.

        @

INCLUDE	h\COMMON.INC

EXTRN	_int_0:FAR ,_int_1:FAR ,_int_2:FAR ,_int_3:FAR ,_int_4:FAR
EXTRN	_int_5:FAR ,_int_6:FAR ,_int_7:FAR ,_int_8:FAR ,_int_9:FAR
EXTRN	_int_10:FAR,_int_11:FAR,_int_12:FAR,_int_13:FAR,_int_16:FAR
EXTRN	_int_unexp:FAR,_int_hunxp:FAR,__swtch:far
EXTRN	_HINT0:FAR,t_clock:far,_sysc:far,t_coint:far,sysentry:far
EXTRN	t_clocka:far,t_fdc:far,t_lp1:far,t_lp2:far,t_hdc:far
EXTRN	t_asy1:far,t_asy2:far
extrn	_endofd:far,_endofc:far

K_DATA		SEGMENT	PARA	PUBLIC	'K_DATA'
;************************************************
;*					       	*
;*  Az Interrupt Deszkriptor Tabla		*
;*  Az elso 32 interrupt nem hasznalhato	*
;*  user celokra, ezek az exception-ok es	*
;*  Intel reserved interruptok.			*
;*  INT 32-tol talalhatoak a hardware		*
;*  interruptok, majd ezutan a szabadok 63-ig	*
;*						*
;************************************************
INT_DESC_TAB	LABEL	FAR
PUBLIC	INT_DESC_TAB

;************************************************************************
;			    EXCEPTIONS					*
;************************************************************************

INTR_DIV	GAT_DESC <	0,160H,0,10000101B>;divide error
INTR_STEP	GAT_DESC <      0,170H,0,10000101B>;single step
INTR_NMI	GAT_DESC <      0,180H,0,10000101B>;NMI
INTR_BREAK	GAT_DESC <      0,190H,0,10000101B>;breakpoint
INTR_intO	GAT_DESC <      0,1a0H,0,10000101B>;overflow
INTR_BOUND	GAT_DESC <      0,1b0H,0,10000101B>;BOUND exceeded
INTR_INVOP	GAT_DESC <      0,1c0H,0,10000101B>;invalid opcode
INTR_EXTNOT	GAT_DESC <      0,1d0H,0,10000101B>;proc extension not av.
INTR_DOUBLE	GAT_DESC <      0,1e0H,0,10000101B>;double fault
INTR_EXTSOVR	GAT_DESC <      0,1f0H,0,10000101B>;proc extesion overrun
INTR_INVTSS	GAT_DESC <      0,200H,0,10000101B>;invalid task state seg.
INTR_NOTPRES	GAT_DESC <      0,210H,0,10000101B>;segment not present
INTR_NOSTACK	GAT_DESC <      0,008H,0,10000101B>;stack overrun/stack not pres.
INTR_GENPROT	GAT_DESC <      0,230H,0,10000101B>;general prot.
INTR_14		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_15		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_EXTERR	GAT_DESC <	0,240H,0,10000101B>;proc extension error
INTR_17		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_18		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_19		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_20		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_21		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_22		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_23		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_24		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_25		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_26		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_27		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_28		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_29		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_30		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved
INTR_31		GAT_DESC <OFFSET   _int_unexp,18H,0,10000110B>;reserved

;************************************************************************
;*			HARDWARE INTERRUPTS				*
;************************************************************************

_INTR_32	GAT_DESC <		    0,040H,0,10000101B>;clock ticks
INTR_33		GAT_DESC <         	    0,050H,0,10000101B>;keyboard
INTR_34		GAT_DESC <OFFSET   _int_hunxp,018H,0,10000111B>;cascade
INTR_35		GAT_DESC <                  0,070H,0,10000101B>;com2
INTR_36		GAT_DESC <                  0,080H,0,10000101B>;com1
INTR_37		GAT_DESC <         	    0,090H,0,10000101B>;lp2
INTR_38		GAT_DESC <                  0,0a0H,0,10000101B>;fdc
INTR_39		GAT_DESC <                  0,0b0H,0,10000101B>;lp1
INTR_40		GAT_DESC <OFFSET   _int_hunxp,018H,0,10000111B>;cmos clock
INTR_41		GAT_DESC <OFFSET   _int_hunxp,018H,0,10000111B>;nothing
INTR_42		GAT_DESC <OFFSET   _int_hunxp,018H,0,10000111B>;nothing
INTR_43		GAT_DESC <OFFSET   _int_hunxp,018H,0,10000111B>;nothing
INTR_44		GAT_DESC <OFFSET   _int_hunxp,018H,0,10000111B>;nothing
INTR_45		GAT_DESC <OFFSET   _int_hunxp,018H,0,10000111B>;287 error
INTR_46		GAT_DESC <         	    0,120H,0,10000101B>;hdc
INTR_47		GAT_DESC <OFFSET   _int_hunxp,018H,0,10000111B>;nothing

public _intr_32
;************************************************************************
;*			USER  DEFINED INTERRUPTS			*
;************************************************************************

INTR_48		GAT_DESC <OFFSET _int_unexp,18H,0,11100111B>; rendszehivas

END_IDT 	LABEL FAR

;************************************************
;*						*
;*   Itt kezdodik a Globalis Deszkriptor	*
;*	Tabla					*
;*						*
;************************************************

GLOB_DESC_TAB LABEL FAR
PUBLIC GLOB_DESC_TAB

R_K_DATA   EQU	ACC_PRES OR ACC_DPL0 OR ACC_DATA OR ACC_WRIT
R_K_CODE   EQU	ACC_PRES OR ACC_DPL0 OR ACC_DATA OR ACC_EXEC OR ACC_READ
R_K_STACK  EQU	ACC_PRES OR ACC_DPL0 OR ACC_DATA OR ACC_WRIT OR ACC_DOWN
R_AV_TSS   EQU 	SYS_PRES OR SYS_DPL0 OR SYS_ATSS
R_U_LDT	   EQU  SYS_PRES OR SYS_LDS or sys_DPL3
R_U_TSS    EQU	SYS_PRES OR SYS_DPL0 OR SYS_ATSS
S_k_CODE   EQU	18H
S_K_DATA   EQU	28H
S_VIDEO    EQU	30H

HINT_FLAG  EQU	0000001000000000B  ;interrupt enabled

DUMMY		CDS_DESC	<0,0,0,0>	; A 0. deszkriptor mindig ez.
; A valodi deszkriptorok deklaracio. 	     A szelektor ertekek: \/
SF_TSK		CDS_DESC	<44,,,R_AV_TSS>			;008H
d_sw_code	CDS_DESC	<offset _endofc,,,R_K_CODE>	;010H
D_K_CODE	CDS_DESC	<offset _endofc,,,R_K_CODE>	;018H
D_K_STACK	CDS_DESC	<0,,,R_K_STACK>			;020H
D_K_DATA	CDS_DESC	<offset _endofd,,,R_K_DATA>	;028H
D_VIDEO		CDS_DESC	<9000h,08000H,0BH,R_K_DATA or 96>;030H
DUMMY_TSK	CDS_DESC	<44,,,R_AV_TSS>			;038H
HINT0_TSK	CDS_DESC	<44,,,R_AV_TSS>	;Clock ticks    ;040H
HINT0_S0	CDS_DESC	<ST_I0_E,,,R_K_STACK>		;048H
HINT1_TSK	CDS_DESC	<44,,,R_AV_TSS>	;Billentyuzet	;050H
HINT1_S0	CDS_DESC	<ST_I1_E,,,R_K_STACK>		;058H
HINT2_TSK	CDS_DESC	<44,,,R_AV_TSS>	;Cascade	;060H
HINT2_S0	CDS_DESC	<ST_I2_E,,,R_K_STACK>		;068H
HINT3_TSK	CDS_DESC	<44,,,R_AV_TSS>	;COM2		;070H
HINT3_S0	CDS_DESC	<ST_I3_E,,,R_K_STACK>		;078H
HINT4_TSK	CDS_DESC	<44,,,R_AV_TSS>	;COM1		;080H
HINT4_S0	CDS_DESC	<ST_I4_E,,,R_K_STACK>		;088H
HINT5_TSK	CDS_DESC	<44,,,R_AV_TSS>	;Paralell port 1;090H
HINT5_S0	CDS_DESC	<ST_I5_E,,,R_K_STACK>		;098H
HINT6_TSK	CDS_DESC	<44,,,R_AV_TSS>	;FDC		;0A0H
HINT6_S0	CDS_DESC	<ST_I6_E,,,R_K_STACK>		;0A8H
HINT7_TSK	CDS_DESC	<44,,,R_AV_TSS>	;Paralell port 2;0B0H
HINT7_S0	CDS_DESC	<ST_I7_E,,,R_K_STACK>		;08BH
HINT8_TSK	CDS_DESC	<44,,,R_AV_TSS> ;Real time ora	;0C0H
HINT8_S0	CDS_DESC	<ST_I8_E,,,R_K_STACK>		;0C8H
HINT9_TSK	CDS_DESC	<44,,,R_AV_TSS>	;Nem hasznalt	;0D0H
HINT9_S0	CDS_DESC	<ST_I9_E,,,R_K_STACK>		;0D8H
HINT10_TSK	CDS_DESC	<44,,,R_AV_TSS>	;    - " -	;0E0H
HINT10_S0	CDS_DESC	<ST_I10_E,,,R_K_STACK>		;0E8H
HINT11_TSK	CDS_DESC	<44,,,R_AV_TSS>	;    - " -	;0F0H
HINT11_S0	CDS_DESC	<ST_I11_E,,,R_K_STACK>		;0F8H
HINT12_TSK	CDS_DESC	<44,,,R_AV_TSS>	;    - " -	;100H
HINT12_S0	CDS_DESC	<ST_I12_E,,,R_K_STACK>		;108H
HINT13_TSK	CDS_DESC	<44,,,R_AV_TSS>	;80287 hiba	;110H
HINT13_S0	CDS_DESC	<ST_I13_E,,,R_K_STACK>		;118H
HINT14_TSK	CDS_DESC	<44,,,R_AV_TSS>	;HDC		;120H
HINT14_S0	CDS_DESC	<ST_I14_E,,,R_K_STACK>		;128H
HINT15_TSK	CDS_DESC	<44,,,R_AV_TSS>	;Nem hasznalt	;130H
HINT15_S0	CDS_DESC	<ST_I15_E,,,R_K_STACK>		;138H
_swtch_tsk	CDS_DESC	<44,,,R_AV_TSS> ;swtch task	;140h
swtch_s0	CDS_DESC	<st_swtch_e,,,R_K_STACK>	;148h
sysc		GAT_DESC	<OFFSET sysentry,18H,5,11100100B>;150h

HINT0a_TSK	CDS_DESC	<44,,,R_AV_TSS>	;alternativ	;158H

_in0_tsk	cds_desc	<44,,,R_AV_TSS>			;160H
_int0_s		cds_desc	<st_e0_e,,,R_K_STACK>		;168H
_in1_tsk	cds_desc	<44,,,R_AV_TSS>			;170H
_int1_s		cds_desc	<st_e0_e,,,R_K_STACK>		;178H
_in2_tsk	cds_desc	<44,,,R_AV_TSS>			;180H
_int2_s		cds_desc	<st_e0_e,,,R_K_STACK>		;188H
_in3_tsk	cds_desc	<44,,,R_AV_TSS>			;190H
_int3_s		cds_desc	<st_e0_e,,,R_K_STACK>		;198H
_in4_tsk	cds_desc	<44,,,R_AV_TSS>			;1a0H
_int4_s		cds_desc	<st_e0_e,,,R_K_STACK>		;1a8H
_in5_tsk	cds_desc	<44,,,R_AV_TSS>			;1b0H
_int5_s		cds_desc	<st_e0_e,,,R_K_STACK>		;1b8H
_in6_tsk	cds_desc	<44,,,R_AV_TSS>			;1c0H
_int6_s		cds_desc	<st_e0_e,,,R_K_STACK>		;1c8H
_in7_tsk	cds_desc	<44,,,R_AV_TSS>			;1d0H
_int7_s		cds_desc	<st_e0_e,,,R_K_STACK>		;1d8H
_in8_tsk	cds_desc	<44,,,R_AV_TSS>			;1e0H
_int8_s		cds_desc	<st_e0_e,,,R_K_STACK>		;1e8H
_in9_tsk	cds_desc	<44,,,R_AV_TSS>			;1f0H
_int9_s		cds_desc	<st_e0_e,,,R_K_STACK>		;1f8H
_in10_tsk	cds_desc	<44,,,R_AV_TSS>			;200H
_int10_s	cds_desc	<st_e0_e,,,R_K_STACK>		;208H
_in11_tsk	cds_desc	<44,,,R_AV_TSS>			;210H
_int11_s	cds_desc	<st_e0_e,,,R_K_STACK>		;218H
_in12_tsk	cds_desc	<44,,,R_AV_TSS>			;220H
_int12_s	cds_desc	<st_e0_e,,,R_K_STACK>		;228H
_in13_tsk	cds_desc	<44,,,R_AV_TSS>			;230H
_int13_s	cds_desc	<st_e0_e,,,R_K_STACK>		;238H
_in16_tsk	cds_desc	<44,,,R_AV_TSS>			;240H
_int16_s	cds_desc	<st_e0_e,,,R_K_STACK>		;248H


USER_LDT	CDS_DESC  NPROC	DUP ( <5*8,,,R_U_LDT> )         ;250h
USER_TSK	CDS_DESC  NPROC DUP ( <44,,,R_U_TSS>)           ;250h+NPROC*8

_memdesc	cds_desc	<0,0,0,R_K_DATA>	;mem seged
_hddesc1	cds_desc	<0,0,0,R_K_DATA>	;winch desc 1
_hddesc2	cds_desc	<0,0,0,R_K_DATA>	;winch desc 2
_kdesc1		cds_desc	<0,0,0,R_K_DATA>	;kernel seged desc 1
_kdesc2		cds_desc	<0,0,0,R_K_DATA>	;kernel seged desc 2
_kdesc3		cds_desc	<0,0,0,R_K_DATA>	;kernel seged desc 3
_kdesc4		cds_desc	<0,0,0,R_K_DATA>	;kernel seged desc 4

public _memdesc,_hddesc1,_hddesc2,_kdesc1,_kdesc2,_kdesc3,_kdesc4;

END_GDT         LABEL FAR
GDT_SIZ	EQU	END_GDT-GLOB_DESC_TAB
IDT_SIZ	EQU	END_IDT-INT_DESC_TAB

PUBLIC	GDT_SIZ,IDT_SIZ
DUMMY_TSS	TSS		<?>		;indulaskor ezt toltjuk be.
hint0_beg:
HINT0_TSS	TSS	<0,0,0,0,0,0,0,OFFSET t_clock,0,\
			 0,0,0,0,ST_I0_B,0,0,0,0,S_K_CODE,048H,S_K_DATA,0>

HINT1_TSS	TSS	<0,0,0,0,0,0,0,OFFSET t_coint,0,\
			 0,0,0,0,ST_I1_B,0,0,0,0,S_K_CODE,058H,S_K_DATA,0>

HINT2_TSS	TSS	<0,ST_I2_B,068H,0,0,0,0,OFFSET _int_hunxp,HINT_FLAG,\
			 0,0,0,0,ST_I2_B,0,0,0,0,S_K_CODE,068H,S_K_DATA,0>

HINT3_TSS	TSS	<0,0,0,0,0,0,0,OFFSET t_asy2,0,\
			 0,0,0,0,ST_I3_B,0,0,0,0,S_K_CODE,078H,S_K_DATA,0>

HINT4_TSS	TSS	<0,0,0,0,0,0,0,OFFSET t_asy1,0,\
			 0,0,0,0,ST_I4_B,0,0,0,0,S_K_CODE,088H,S_K_DATA,0>

HINT5_TSS	TSS	<0,0,0,0,0,0,0,OFFSET t_lp2,HINT_FLAG,\
			 0,0,0,0,ST_I5_B,0,0,0,0,S_K_CODE,098H,S_K_DATA,0>

HINT6_TSS	TSS	<0,0,0,0,0,0,0,OFFSET t_fdc,HINT_FLAG,\
			 0,0,0,0,ST_I6_B,0,0,0,0,S_K_CODE,0A8H,S_K_DATA,0>

HINT7_TSS	TSS	<0,0,0,0,0,0,0,OFFSET t_lp1,HINT_FLAG,\
			 0,0,0,0,ST_I7_B,0,0,0,0,S_K_CODE,0B8H,S_K_DATA,0>

HINT8_TSS	TSS	<0,0,0,0,0,0,0,OFFSET _int_hunxp,HINT_FLAG,\
			 0,0,0,0,ST_I8_B,0,0,0,0,S_K_CODE,0C8H,S_K_DATA,0>

HINT9_TSS	TSS	<0,0,0,0,0,0,0,OFFSET _int_hunxp,HINT_FLAG,\
			 0,0,0,0,ST_I9_B,0,0,0,0,S_K_CODE,0D8H,S_K_DATA,0>

HINT10_TSS	TSS	<0,0,0,0,0,0,0,OFFSET _int_hunxp,HINT_FLAG,\
			 0,0,0,0,ST_I10_B,0,0,0,0,S_K_CODE,0E8H,S_K_DATA,0>

HINT11_TSS	TSS	<0,0,0,0,0,0,0,OFFSET _int_hunxp,HINT_FLAG,\
			 0,0,0,0,ST_I11_B,0,0,0,0,S_K_CODE,0F8H,S_K_DATA,0>

HINT12_TSS	TSS	<0,0,0,0,0,0,0,OFFSET _int_hunxp,HINT_FLAG,\
			 0,0,0,0,ST_I12_B,0,0,0,0,S_K_CODE,108H,S_K_DATA,0>

HINT13_TSS	TSS	<0,0,0,0,0,0,0,OFFSET _int_hunxp,HINT_FLAG,\
			 0,0,0,0,ST_I13_B,0,0,0,0,S_K_CODE,118H,S_K_DATA,0>

HINT14_TSS	TSS	<0,0,0,0,0,0,0,OFFSET t_hdc,HINT_FLAG,\
			 0,0,0,0,ST_I14_B,0,0,0,0,S_K_CODE,128H,S_K_DATA,0>

HINT15_TSS	TSS	<0,0,0,0,0,0,0,OFFSET _int_hunxp,HINT_FLAG,\
			 0,0,0,0,ST_I15_B,0,0,0,0,S_K_CODE,138H,S_K_DATA,0>

_swtch_tss	TSS	<0,0,0,0,0,0,0,OFFSET __swtch ,0,\
			 0,0,0,0,st_swtch_b,0,0,0,0,S_K_CODE,148h,S_K_DATA,0>

HINT0a_TSS	TSS	<0,ST_KERN_B,020h,0,0,0,0,OFFSET t_clocka,HINT_FLAG,\
			 0,0,0,0,ST_KERN_B,0,0,0,0,S_K_CODE,020H,S_K_DATA,0>
_stf_tss	tss	<0,0,0,0,0,0,0,offset _int_12   ,0,\
			 0,0,0,0,ST_sf_b,  0,0,0,0,s_k_code,020h,s_k_data,0>

_int0_tss	tss	<0,0,0,0,0,0,0,offset _int_0 ,0,0,0,0,0,st_e0_b,\
			 0,0,0,0,s_k_code,168h ,s_k_data,0>
_int1_tss	tss	<0,0,0,0,0,0,0,offset _int_1 ,0,0,0,0,0,st_e1_b,\
			 0,0,0,0,s_k_code,178h ,s_k_data,0>
_int2_tss	tss	<0,0,0,0,0,0,0,offset _int_2 ,0,0,0,0,0,st_e2_b,\
			 0,0,0,0,s_k_code,188h ,s_k_data,0>
_int3_tss	tss	<0,0,0,0,0,0,0,offset _int_3 ,0,0,0,0,0,st_e3_b,\
			 0,0,0,0,s_k_code,198h ,s_k_data,0>
_int4_tss	tss	<0,0,0,0,0,0,0,offset _int_4 ,0,0,0,0,0,st_e4_b,\
			 0,0,0,0,s_k_code,1a8h ,s_k_data,0>
_int5_tss	tss	<0,0,0,0,0,0,0,offset _int_5 ,0,0,0,0,0,st_e5_b,\
			 0,0,0,0,s_k_code,1b8h ,s_k_data,0>
_int6_tss	tss	<0,0,0,0,0,0,0,offset _int_6 ,0,0,0,0,0,st_e6_b,\
			 0,0,0,0,s_k_code,1c8h ,s_k_data,0>
_int7_tss	tss	<0,0,0,0,0,0,0,offset _int_7 ,0,0,0,0,0,st_e7_b,\
			 0,0,0,0,s_k_code,1d8h ,s_k_data,0>
_int8_tss	tss	<0,0,0,0,0,0,0,offset _int_8 ,0,0,0,0,0,st_e8_b,\
			 0,0,0,0,s_k_code,1e8h ,s_k_data,0>
_int9_tss	tss	<0,0,0,0,0,0,0,offset _int_9 ,0,0,0,0,0,st_e9_b,\
			 0,0,0,0,s_k_code,1f8h ,s_k_data,0>
_int10_tss	tss	<0,0,0,0,0,0,0,offset _int_10,0,0,0,0,0,st_e10_b,\
			 0,0,0,0,s_k_code,208h ,s_k_data,0>
_int11_tss	tss	<0,0,0,0,0,0,0,offset _int_11,0,0,0,0,0,st_e11_b,\
			 0,0,0,0,s_k_code,218h ,s_k_data,0>
_int12_tss	tss	<0,0,0,0,0,0,0,offset _int_12,0,0,0,0,0,st_e12_b,\
			 0,0,0,0,s_k_code,228h ,s_k_data,0>
_int13_tss	tss	<0,0,0,0,0,0,0,offset _int_13,0,0,0,0,0,st_e13_b,\
			 0,0,0,0,s_k_code,238h ,s_k_data,0>
_int16_tss	tss	<0,0,0,0,0,0,0,offset _int_16,0,0,0,0,0,st_e16_b,\
			 0,0,0,0,s_k_code,248h ,s_k_data,0>


PUBLIC	d_sw_code,D_K_CODE,D_K_STACK,D_K_DATA
PUBLIC  DUMMY_TSS,DUMMY_TSK,hint0_beg,_swtch_tss
PUBLIC	_swtch_tsk,USER_LDT,USER_TSK
public  hint0_tss,hint1_tss,hint6_tss,_stf_tss
public  _int0_tss
;************************************************
;*	Interrupt taskok stack-jei		*
;*		es egyeb stackek		*
;************************************************

ST_KERN_S	EQU	128
ST_I0_S		EQU	256 	; clock
ST_I1_S		EQU	256     ; keyboard
ST_I2_S		EQU	32	; cascade
ST_I3_S		EQU	256	; com2
ST_I4_S		EQU	256	; com1
ST_I5_S		EQU	256     ; lp2
ST_I6_S		EQU	256     ; fdc
ST_I7_S		EQU	256     ; lp1
ST_I8_S		EQU	32      ; cmos
ST_I9_S		EQU	32      ; --
ST_I10_S	EQU	32      ; --
ST_I11_S	EQU	32      ; --
ST_I12_S	EQU	32      ; --
ST_I13_S	EQU	32      ; 287 error
ST_I14_S	EQU	256     ; hdc
ST_I15_S	EQU	32      ; --
st_swtch_s	EQU	256
st_e_s		EQU	200
even

ST_KERN_E	DW	ST_KERN_S DUP (?)	;Stack vege
ST_KERN_B  EQU	THIS 	WORD			;- " - kezdete, lefele no!
PUBLIC	ST_KERN_B

ST_I0_E		Db	ST_I0_S	  DUP (?)
ST_I0_B  EQU	THIS	WORD
ST_I1_E		Db	ST_I1_S	  DUP (?)
ST_I1_B  EQU	THIS	WORD
ST_I2_E		Db	ST_I2_S	  DUP (?)
ST_I2_B  EQU	THIS	WORD
ST_I3_E		Db	ST_I3_S	  DUP (?)
ST_I3_B  EQU	THIS	WORD
ST_I4_E		Db	ST_I4_S	  DUP (?)
ST_I4_B  EQU	THIS	WORD
ST_I5_E		Db	ST_I5_S	  DUP (?)
ST_I5_B  EQU	THIS	WORD
ST_I6_E		Db	ST_I6_S	  DUP (?)
ST_I6_B  EQU	THIS	WORD
ST_I7_E		Db	ST_I7_S	  DUP (?)
ST_I7_B  EQU	THIS	WORD
ST_I8_E		Db	ST_I8_S	  DUP (?)
ST_I8_B  EQU	THIS	WORD
ST_I9_E		Db	ST_I9_S	  DUP (?)
ST_I9_B  EQU	THIS	WORD
ST_I10_E	Db	ST_I10_S  DUP (?)
ST_I10_B  EQU	THIS	WORD
ST_I11_E	Db	ST_I11_S  DUP (?)
ST_I11_B  EQU	THIS	WORD
ST_I12_E	Db	ST_I12_S  DUP (?)
ST_I12_B  EQU	THIS	WORD
ST_I13_E	Db	ST_I13_S  DUP (?)
ST_I13_B  EQU	THIS	WORD
ST_I14_E	Db	ST_I14_S  DUP (?)
ST_I14_B  EQU	THIS	WORD
ST_I15_E	Db	ST_I15_S  DUP (?)
ST_I15_B  EQU	THIS	WORD

st_e0_e 		db	st_e_s	dup (?)
st_e0_b 	equ	this	word
st_e1_e 		db	st_e_s	dup (?)
st_e1_b 	equ	this	word
st_e2_e 		db	st_e_s	dup (?)
st_e2_b 	equ	this	word
st_e3_e 		db	st_e_s	dup (?)
st_e3_b 	equ	this	word
st_e4_e 		db	st_e_s	dup (?)
st_e4_b  	equ	this	word
st_e5_e 		db	st_e_s	dup (?)
st_e5_b 	equ	this	word
st_e6_e 		db	st_e_s	dup (?)
st_e6_b  	equ	this	word
st_e7_e 		db	st_e_s	dup (?)
st_e7_b 	equ	this	word
st_e8_e 	 	db	st_e_s	dup (?)
st_e8_b 	equ	this	word
st_e9_e 		db	st_e_s	dup (?)
st_e9_b 	equ	this	word
st_e10_e		db	st_e_s	dup (?)
st_e10_b	equ	this	word
st_e11_e		db	st_e_s	dup (?)
st_e11_b	equ	this	word
st_e12_e		db	st_e_s	dup (?)
st_e12_b	equ	this	word
st_e13_e		db	st_e_s	dup (?)
st_e13_b	equ	this	word
st_e16_e		db	st_e_s	dup (?)
st_e16_b	equ	this	word

st_sf_e		db	128	  dup (?)
st_sf_b	  equ	this	byte

st_swtch_e	Db	st_swtch_s DUP (?)
st_swtch_b  EQU	THIS	WORD
even

_stk0e	dw	254 dup(?)   ;\
_stk0  equ	this word    ; |
_stk1e	dw	254 dup(?)   ; |
_stk1  equ	this word    ; |____\ ideiglenes process stack
_stk2e	dw	254 dup(?)   ; |    /
_stk2  equ	this word    ; |
_stk3e	dw	254 dup(?)   ; |
_stk3  equ	this word    ;/

public _stk0,_stk1,_stk2,_stk3,_stk0e,_stk1e,_stk2e,_stk3e
comment @
_stk00e	dw	254 dup(?)   ;\
_stk00 equ	this word    ; |
_stk10e	dw	254 dup(?)   ; |
_stk10 equ	this word    ; |____\ ideiglenes process stack
_stk20e	dw	254 dup(?)   ; |    /
_stk20 equ	this word    ; |
_stk30e	dw	254 dup(?)   ; |
_stk30 equ	this word    ;/

public _stk00,_stk10,_stk20,_stk30,_stk00e,_stk10e,_stk20e,_stk30e
@

K_DATA		ENDS
;************************************************

CODE_86	SEGMENT	PARA	PUBLIC	'CODE_86'
ASSUME	CS:CODE_86,ES:K_DATA

FILL_DESCRIPT	PROC	NEAR		;Interrupt taskok deszkriptorainak
		MOV	AX,K_DATA	;kitoltese
		MOV	ES,AX
		FILL_DESC DUMMY_TSK, K_DATA,DUMMY_TSS
		FILL_DESC HINT0_TSK, K_DATA,HINT0_TSS
		FILL_DESC HINT0_S0 , k_DATA,0
		FILL_DESC HINT1_TSK, K_DATA,HINT1_TSS
		FILL_DESC HINT1_S0 , k_DATA,0
		FILL_DESC HINT2_TSK, K_DATA,HINT2_TSS
		FILL_DESC HINT2_S0 , k_DATA,0
		FILL_DESC HINT3_TSK, K_DATA,HINT3_TSS
		FILL_DESC HINT3_S0 , k_DATA,0
		FILL_DESC HINT4_TSK, K_DATA,HINT4_TSS
		FILL_DESC HINT4_S0 , k_DATA,0
		FILL_DESC HINT5_TSK, K_DATA,HINT5_TSS
		FILL_DESC HINT5_S0 , k_DATA,0
		FILL_DESC HINT6_TSK, K_DATA,HINT6_TSS
		FILL_DESC HINT6_S0 , k_DATA,0
		FILL_DESC HINT7_TSK, K_DATA,HINT7_TSS
		FILL_DESC HINT7_S0 , k_DATA,0
		FILL_DESC HINT8_TSK, K_DATA,HINT8_TSS
		FILL_DESC HINT8_S0 , k_DATA,0
		FILL_DESC HINT9_TSK, K_DATA,HINT9_TSS
		FILL_DESC HINT9_S0 , k_DATA,0
		FILL_DESC HINT10_TSK,K_DATA,HINT10_TSS
		FILL_DESC HINT10_S0 , k_DATA,0
		FILL_DESC HINT11_TSK,K_DATA,HINT11_TSS
		FILL_DESC HINT11_S0 , k_DATA,0
		FILL_DESC HINT12_TSK,K_DATA,HINT12_TSS
		FILL_DESC HINT12_S0 , k_DATA,0
		FILL_DESC HINT13_TSK,K_DATA,HINT13_TSS
		FILL_DESC HINT13_S0 , k_DATA,0
		FILL_DESC HINT14_TSK,K_DATA,HINT14_TSS
		FILL_DESC HINT14_S0 , k_DATA,0
		FILL_DESC HINT15_TSK,K_DATA,HINT15_TSS
		FILL_DESC HINT15_S0 , k_DATA,0

		fill_desc _in0_tsk ,k_data,_int0_tss
		fill_desc _int0_s  ,k_data,0
		fill_desc _in1_tsk ,k_data,_int1_tss
		fill_desc _int1_s  ,k_data,0
		fill_desc _in2_tsk ,k_data,_int2_tss
		fill_desc _int2_s  ,k_data,0
		fill_desc _in3_tsk ,k_data,_int3_tss
		fill_desc _int3_s  ,k_data,0
		fill_desc _in4_tsk ,k_data,_int4_tss
		fill_desc _int4_s  ,k_data,0
		fill_desc _in5_tsk ,k_data,_int5_tss
		fill_desc _int5_s  ,k_data,0
		fill_desc _in6_tsk ,k_data,_int6_tss
		fill_desc _int6_s  ,k_data,0
		fill_desc _in7_tsk ,k_data,_int7_tss
		fill_desc _int7_s  ,k_data,0
		fill_desc _in8_tsk ,k_data,_int8_tss
		fill_desc _int8_s  ,k_data,0
		fill_desc _in9_tsk ,k_data,_int9_tss
		fill_desc _int9_s  ,k_data,0
		fill_desc _in10_tsk ,k_data,_int10_tss
		fill_desc _int10_s  ,k_data,0
		fill_desc _in11_tsk ,k_data,_int11_tss
		fill_desc _int11_s  ,k_data,0
		fill_desc _in12_tsk ,k_data,_int12_tss
		fill_desc _int12_s  ,k_data,0
		fill_desc _in13_tsk ,k_data,_int13_tss
		fill_desc _int13_s  ,k_data,0
		fill_desc _in16_tsk ,k_data,_int16_tss
		fill_desc _int16_s  ,k_data,0

		fill_desc _swtch_tsk,k_data,_swtch_tss
		fill_desc swtch_s0,  k_data,0
		FILL_DESC HINT0a_TSK,K_DATA,HINT0a_TSS
		fill_desc sf_tsk,k_data,_stf_tss

		RET
FILL_DESCRIPT	ENDP
PUBLIC FILL_DESCRIPT
CODE_86		ENDS

END

