/*
 * Miscellaneous virtual memory subsystem variables and structures.
 */

#ifdef KERNEL
int	freemem;		/* remaining blocks of free memory */
int	avefree;		/* moving average of remaining free blocks */
int	avefree30;		/* 30 sec (avefree is 5 sec) moving average */
int	deficit;		/* estimate of needs of new swapped in procs */
int	nscan;			/* number of scans in last second */
int	desscan;		/* desired pages scanned per second */
int	kmapwnt;		/* kernel map wanted flag */

/* writable copies of tunables */
int	maxpgio;		/* max paging i/o per sec before start swaps */
int	maxslp;			/* max sleep time before very swappable */
int	lotsfree;		/* max free before clock freezes */
int	minfree;		/* minimum free pages before swapping begins */
int	desfree;		/* no of pages to try to keep free via daemon */
int	saferss;		/* no pages not to steal; decays with slptime */
#endif

/*
 * Swap kind accounting.
 */
struct	swptstat
{
	int	pteasy;		/* easy pt swaps */
	int	ptexpand;	/* pt expansion swaps */
	int	ptshrink;	/* pt shrinking swaps */
	int	ptpack;		/* pt swaps involving spte copying */
};
#ifdef KERNEL
struct	swptstat swptstat;
#endif

#ifdef KERNEL
swblk_t	vtod();
int	vmemall();
int	memall();
#endif
